/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.ha;

import com.questdb.model.Quote;
import com.questdb.net.ha.MockByteChannel;
import com.questdb.net.ha.comsumer.JournalClientStateConsumer;
import com.questdb.net.ha.comsumer.JournalSymbolTableConsumer;
import com.questdb.net.ha.comsumer.PartitionDeltaConsumer;
import com.questdb.net.ha.model.IndexedJournal;
import com.questdb.net.ha.model.JournalClientState;
import com.questdb.net.ha.producer.JournalClientStateProducer;
import com.questdb.net.ha.producer.JournalSymbolTableProducer;
import com.questdb.net.ha.producer.PartitionDeltaProducer;
import com.questdb.std.ex.JournalNetworkException;
import com.questdb.std.time.DateFormatUtils;
import com.questdb.store.JournalWriter;
import com.questdb.store.Partition;
import com.questdb.test.tools.AbstractTest;
import com.questdb.test.tools.TestUtils;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PartitionTest
extends AbstractTest {
    private static final long timestamp = DateFormatUtils.parseDateTimeQuiet((CharSequence)"2013-12-12T00:00:00.000Z");
    private JournalWriter<Quote> origin;
    private JournalWriter<Quote> master;
    private JournalWriter<Quote> slave;
    private PartitionDeltaProducer producer;
    private PartitionDeltaConsumer consumer;
    private MockByteChannel channel;
    private Partition<Quote> masterPartition;
    private Partition<Quote> slavePartition;

    @Before
    public void setUp() throws Exception {
        this.origin = this.getFactory().writer(Quote.class, "origin");
        this.master = this.getFactory().writer(Quote.class, "master");
        this.slave = this.getFactory().writer(Quote.class, "slave");
        this.masterPartition = this.master.getAppendPartition(timestamp);
        this.slavePartition = this.slave.getAppendPartition(timestamp);
        this.producer = new PartitionDeltaProducer(this.masterPartition);
        this.consumer = new PartitionDeltaConsumer(this.slavePartition);
        this.channel = new MockByteChannel();
        TestUtils.generateQuoteData(this.origin, 1000, timestamp);
    }

    @Override
    @After
    public void tearDown() {
        this.origin.close();
        this.master.close();
        this.slave.close();
    }

    @Test
    public void testConsumerEqualToProducer() throws Exception {
        this.master.append(this.origin);
        this.slave.append(this.origin);
        Assert.assertEquals((long)1000L, (long)this.masterPartition.size());
        Assert.assertEquals((long)1000L, (long)this.slavePartition.size());
        this.producer.configure(this.slave.size());
        Assert.assertFalse((boolean)this.producer.hasContent());
    }

    @Test
    public void testConsumerLargerThanProducer() throws Exception {
        this.master.append(this.origin.query().all().asResultSet().subset(0, 700));
        this.slave.append(this.origin);
        this.producer.configure(this.slave.size());
        Assert.assertFalse((boolean)this.producer.hasContent());
    }

    @Test
    public void testConsumerReset() throws Exception {
        this.master.append(this.origin);
        this.slave.append(this.origin.query().all().asResultSet().subset(0, 600));
        this.producer.configure(this.slave.size());
        Assert.assertTrue((boolean)this.producer.hasContent());
        this.syncSymbolTables();
        this.producer.write((WritableByteChannel)this.channel);
        this.consumer.read((ReadableByteChannel)this.channel);
        this.comparePartitions();
        TestUtils.generateQuoteData(this.master, 200, DateFormatUtils.parseDateTime((CharSequence)"2014-01-01T00:00:00.000Z"));
        this.producer.configure(this.slave.size());
        this.producer.write((WritableByteChannel)this.channel);
        this.consumer.read((ReadableByteChannel)this.channel);
        this.comparePartitions();
    }

    @Test
    public void testConsumerSmallerThanProducer() throws Exception {
        this.master.append(this.origin);
        this.slave.append(this.origin.query().all().asResultSet().subset(0, 700));
        Assert.assertEquals((long)1000L, (long)this.masterPartition.size());
        Assert.assertEquals((long)700L, (long)this.slavePartition.size());
        this.producer.configure(this.slave.size());
        Assert.assertTrue((boolean)this.producer.hasContent());
        this.producer.write((WritableByteChannel)this.channel);
        this.consumer.read((ReadableByteChannel)this.channel);
        this.comparePartitions();
    }

    @Test
    public void testEmptyConsumerAndPopulatedProducer() throws Exception {
        this.master.append(this.origin);
        this.producer.configure(this.slave.size());
        Assert.assertTrue((boolean)this.producer.hasContent());
        this.syncSymbolTables();
        this.producer.write((WritableByteChannel)this.channel);
        this.consumer.read((ReadableByteChannel)this.channel);
        this.comparePartitions();
    }

    @Test
    public void testEmptyConsumerAndProducer() throws Exception {
        this.producer.configure(this.slave.size());
        Assert.assertFalse((boolean)this.producer.hasContent());
    }

    private void comparePartitions() {
        Assert.assertEquals((long)this.masterPartition.size(), (long)this.slavePartition.size());
        int i = 0;
        while ((long)i < this.slavePartition.size()) {
            Assert.assertEquals((Object)this.masterPartition.read((long)i), (Object)this.slavePartition.read((long)i));
            ++i;
        }
    }

    private void syncSymbolTables() throws JournalNetworkException {
        JournalClientStateProducer sp = new JournalClientStateProducer();
        JournalClientStateConsumer sc = new JournalClientStateConsumer();
        sp.write((WritableByteChannel)this.channel, (Object)new IndexedJournal(0, this.slave));
        sc.read((ReadableByteChannel)this.channel);
        JournalSymbolTableProducer p = new JournalSymbolTableProducer(this.master);
        JournalSymbolTableConsumer c = new JournalSymbolTableConsumer(this.slave);
        p.configure(this.master.find(((JournalClientState)sc.getValue()).getTxn(), ((JournalClientState)sc.getValue()).getTxPin()));
        p.write((WritableByteChannel)this.channel);
        c.read((ReadableByteChannel)this.channel);
    }
}

