/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.ha;

import com.questdb.net.ha.JournalClient;
import com.questdb.net.ha.JournalServer;
import com.questdb.net.ha.config.ClientConfig;
import com.questdb.net.ha.config.ServerConfig;
import com.questdb.net.ha.config.ServerNode;
import com.questdb.net.ha.mcast.OnDemandAddressPoller;
import com.questdb.net.ha.mcast.OnDemandAddressSender;
import com.questdb.std.ex.JournalNetworkException;
import com.questdb.store.factory.ReaderFactory;
import com.questdb.store.factory.WriterFactory;
import com.questdb.test.tools.AbstractTest;
import java.net.Inet6Address;
import java.net.InterfaceAddress;
import java.net.SocketException;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class MulticastTest
extends AbstractTest {
    private boolean multicastDisabled = MulticastTest.isMulticastDisabled();

    @Test
    public void testAllNics() throws Exception {
        if (this.multicastDisabled) {
            return;
        }
        this.assertMulticast();
    }

    @Test
    public void testDefaultNICBehaviour() throws Exception {
        if (this.multicastDisabled) {
            return;
        }
        this.assertMulticast();
    }

    @Test
    public void testIPV4Forced() throws Exception {
        if (this.multicastDisabled) {
            return;
        }
        System.setProperty("java.net.preferIPv4Stack", "true");
        this.assertMulticast();
    }

    @Test
    public void testIPv6() throws Exception {
        if (this.multicastDisabled || !MulticastTest.hasIPv6()) {
            return;
        }
        JournalServer server = new JournalServer(new ServerConfig(){
            {
                this.addNode(new ServerNode(0, "[0:0:0:0:0:0:0:0]"));
                this.setHeartbeatFrequency(100L);
            }
        }, (ReaderFactory)this.getFactory(), null, 0);
        CountDownLatch connected = new CountDownLatch(1);
        JournalClient client = new JournalClient(new ClientConfig(), (WriterFactory)this.getFactory(), null, evt -> {
            if (evt == 32) {
                connected.countDown();
            }
        });
        server.start();
        client.start();
        connected.await(3L, TimeUnit.SECONDS);
        client.halt();
        server.halt();
    }

    @Test
    public void testLocalhostBehaviour() throws Exception {
        if (this.multicastDisabled) {
            return;
        }
        this.assertMulticast();
    }

    private static boolean isMulticastDisabled() throws JournalNetworkException, SocketException {
        return !new ServerConfig().getMultiCastInterface(0).supportsMulticast();
    }

    private static boolean hasIPv6() throws JournalNetworkException {
        List<InterfaceAddress> ifs = new ServerConfig().getMultiCastInterface(0).getInterfaceAddresses();
        for (int i = 0; i < ifs.size(); ++i) {
            if (!(ifs.get(i).getAddress() instanceof Inet6Address)) continue;
            return true;
        }
        return false;
    }

    private void assertMulticast() throws JournalNetworkException, InterruptedException {
        OnDemandAddressSender sender = new OnDemandAddressSender(new ServerConfig(), 120, 150, 0);
        sender.start();
        Thread.sleep(1000L);
        OnDemandAddressPoller poller = new OnDemandAddressPoller(new ClientConfig(), 150, 120);
        ServerNode address = (ServerNode)poller.poll(2, 500L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)address);
        sender.halt();
    }
}

