/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.ha;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;

class MockByteChannel
extends ByteArrayOutputStream
implements ByteChannel {
    private int offset = 0;
    private int cutoffIndex = -1;
    private boolean interrupted = false;

    MockByteChannel() {
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public int read(ByteBuffer dst) {
        if (this.offset == this.buf.length) {
            return -1;
        }
        if (this.interrupted) {
            this.interrupted = false;
            this.cutoffIndex = -1;
            return 0;
        }
        int oldOffset = this.offset;
        while (dst.remaining() > 0 && this.offset < this.buf.length) {
            if (this.offset == this.cutoffIndex) {
                this.interrupted = true;
                break;
            }
            dst.put(this.buf[this.offset++]);
        }
        return this.offset - oldOffset;
    }

    @Override
    public String toString() {
        return "MockByteChannel{offset=" + this.offset + '}';
    }

    @Override
    public void close() {
    }

    @Override
    public int write(ByteBuffer src) {
        int result = src.remaining();
        while (src.remaining() > 0) {
            this.write(src.get());
        }
        return result;
    }
}

