/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.ha;

import com.questdb.model.RDFNode;
import com.questdb.net.ha.MockByteChannel;
import com.questdb.net.ha.comsumer.JournalClientStateConsumer;
import com.questdb.net.ha.comsumer.JournalSymbolTableConsumer;
import com.questdb.net.ha.model.IndexedJournal;
import com.questdb.net.ha.model.JournalClientState;
import com.questdb.net.ha.producer.JournalClientStateProducer;
import com.questdb.net.ha.producer.JournalSymbolTableProducer;
import com.questdb.std.ex.JournalNetworkException;
import com.questdb.store.JournalWriter;
import com.questdb.test.tools.AbstractTest;
import com.questdb.test.tools.TestUtils;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LinkedJournalSymbolTableTest
extends AbstractTest {
    private final JournalClientStateProducer journalClientStateProducer = new JournalClientStateProducer();
    private final JournalClientStateConsumer journalClientStateConsumer = new JournalClientStateConsumer();
    private JournalWriter<RDFNode> origin;
    private JournalWriter<RDFNode> master;
    private JournalWriter<RDFNode> slave;
    private MockByteChannel channel;
    private JournalSymbolTableProducer journalSymbolTableProducer;
    private JournalSymbolTableConsumer journalSymbolTableConsumer;

    @Before
    public void setUp() throws Exception {
        this.origin = this.getFactory().writer(RDFNode.class, "origin");
        this.master = this.getFactory().writer(RDFNode.class, "master");
        this.slave = this.getFactory().writer(RDFNode.class, "slave");
        this.channel = new MockByteChannel();
        this.journalSymbolTableProducer = new JournalSymbolTableProducer(this.master);
        this.journalSymbolTableConsumer = new JournalSymbolTableConsumer(this.slave);
        this.origin.append((Object)new RDFNode().setObj("O1").setSubj("S1"));
        this.origin.append((Object)new RDFNode().setObj("O2").setSubj("S1"));
        this.origin.append((Object)new RDFNode().setObj("O3").setSubj("S2"));
        this.origin.append((Object)new RDFNode().setObj("S2").setSubj("S1"));
    }

    @Override
    @After
    public void tearDown() {
        this.origin.close();
        this.master.close();
        this.slave.close();
    }

    @Test
    public void testSameAsSymbolTable() throws Exception {
        this.master.append(this.origin.query().all().asResultSet().subset(0, 2));
        this.master.commit(false, 101L, 10L);
        this.master.append(this.origin.query().all().asResultSet().subset(2, 4));
        this.master.commit(false, 102L, 20L);
        this.slave.append(this.origin.query().all().asResultSet().subset(0, 2));
        this.slave.commit(false, 101L, 10L);
        this.executeSequence(true);
    }

    private void executeSequence(boolean expectContent) throws JournalNetworkException {
        this.journalClientStateProducer.write((WritableByteChannel)this.channel, (Object)new IndexedJournal(0, this.slave));
        this.journalClientStateConsumer.read((ReadableByteChannel)this.channel);
        this.journalSymbolTableProducer.configure(this.master.find(((JournalClientState)this.journalClientStateConsumer.getValue()).getTxn(), ((JournalClientState)this.journalClientStateConsumer.getValue()).getTxPin()));
        Assert.assertEquals((Object)expectContent, (Object)this.journalSymbolTableProducer.hasContent());
        if (expectContent) {
            this.journalSymbolTableProducer.write((WritableByteChannel)this.channel);
            this.journalSymbolTableConsumer.read((ReadableByteChannel)this.channel);
            TestUtils.compareSymbolTables(this.master, this.slave);
        }
    }
}

