/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.ha;

import com.questdb.model.Quote;
import com.questdb.net.ha.AbstractJournalTest;
import com.questdb.std.time.DateFormatUtils;
import com.questdb.store.Journal;
import com.questdb.store.JournalWriter;
import com.questdb.test.tools.TestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JournalTest
extends AbstractJournalTest {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        TestUtils.generateQuoteData((JournalWriter<Quote>)this.origin, 1000);
    }

    @Test
    public void testConsumerEqualToProducer() throws Exception {
        this.master.append((Journal)this.origin);
        this.master.commit(false, 101L, 10L);
        this.slave.append((Journal)this.origin);
        this.slave.commit(false, 101L, 10L);
        this.executeSequence(false);
    }

    @Test
    public void testConsumerLargerThanProducer() throws Exception {
        this.master.append(this.origin.query().all().asResultSet().subset(0, 550));
        this.master.commit(false, 101L, 10L);
        this.slave.append((Journal)this.origin);
        this.slave.commit(false, 101L, 10L);
        this.executeSequence(false);
    }

    @Test
    public void testConsumerPartitionEdge() throws Exception {
        this.origin.truncate();
        TestUtils.generateQuoteData((JournalWriter<Quote>)this.origin, 500, DateFormatUtils.parseDateTime((CharSequence)"2013-10-01T00:00:00.000Z"));
        TestUtils.generateQuoteData((JournalWriter<Quote>)this.origin, 500, DateFormatUtils.parseDateTime((CharSequence)"2013-11-01T00:00:00.000Z"));
        TestUtils.generateQuoteData((JournalWriter<Quote>)this.origin, 500, DateFormatUtils.parseDateTime((CharSequence)"2013-12-01T00:00:00.000Z"));
        this.master.append(this.origin.query().all().asResultSet().subset(0, 500));
        this.master.commit(false, 101L, 10L);
        this.master.append(this.origin.query().all().asResultSet().subset(500, 1500));
        this.master.commit(false, 102L, 20L);
        this.slave.append(this.origin.query().all().asResultSet().subset(0, 500));
        this.slave.commit(false, 101L, 10L);
        Assert.assertEquals((long)1L, (long)this.slave.getPartitionCount());
        this.executeSequence(true);
    }

    @Test
    public void testConsumerReset() throws Exception {
        this.master.append(this.origin.query().all().asResultSet().subset(0, 200));
        this.master.commit(false, 101L, 10L);
        this.master.append(this.origin.query().all().asResultSet().subset(200, 550));
        this.master.commit(false, 102L, 20L);
        this.slave.append(this.origin.query().all().asResultSet().subset(0, 200));
        this.slave.commit(false, 101L, 10L);
        this.executeSequence(true);
        this.master.append(this.origin.query().all().asResultSet().subset(550, 1000));
        this.master.commit(false, 103L, 30L);
        this.executeSequence(true);
    }

    @Test
    public void testConsumerSmallerThanProducer() throws Exception {
        this.master.append(this.origin.query().all().asResultSet().subset(0, 655));
        this.master.commit(false, 101L, 10L);
        this.master.append(this.origin.query().all().asResultSet().subset(655, (int)this.origin.size()));
        this.master.commit(false, 102L, 20L);
        this.slave.append(this.origin.query().all().asResultSet().subset(0, 655));
        this.slave.commit(false, 101L, 10L);
        Assert.assertEquals((long)655L, (long)this.slave.size());
        this.executeSequence(true);
    }

    @Test
    public void testEmptyConsumerAndPopulatedProducer() throws Exception {
        this.master.append((Journal)this.origin);
        this.master.commit();
        this.executeSequence(true);
        Assert.assertEquals((long)1000L, (long)this.slave.size());
    }

    @Test
    public void testEmptyConsumerAndProducer() throws Exception {
        this.executeSequence(false);
    }

    @Test
    public void testEmptyPartitionAdd() throws Exception {
        this.master.append((Journal)this.origin);
        this.master.getAppendPartition(DateFormatUtils.parseDateTime((CharSequence)"2013-12-01T00:00:00.000Z"));
        this.master.append((Object)new Quote().setTimestamp(DateFormatUtils.parseDateTime((CharSequence)"2014-01-01T00:00:00.000Z")));
        this.master.commit();
        this.executeSequence(true);
        Assert.assertEquals((long)this.master.getPartitionCount(), (long)this.slave.getPartitionCount());
    }

    @Test
    public void testLagConsumerSmallerThanProducer() throws Exception {
        this.master.append(this.origin.query().all().asResultSet().subset(0, 350));
        this.master.mergeAppend(this.origin.query().all().asResultSet().subset(350, 600));
        this.master.commit();
        this.executeSequence(true);
    }

    @Test
    public void testLagReplace() throws Exception {
        this.master.append(this.origin.query().all().asResultSet().subset(0, 350));
        this.master.mergeAppend(this.origin.query().all().asResultSet().subset(350, 600));
        this.master.commit(false, 101L, 10L);
        this.slave.append(this.origin.query().all().asResultSet().subset(0, 350));
        this.slave.mergeAppend(this.origin.query().all().asResultSet().subset(350, 600));
        this.slave.commit(false, 101L, 10L);
        this.master.mergeAppend(this.origin.query().all().asResultSet().subset(600, 1000));
        this.master.commit(false, 102L, 20L);
        this.executeSequence(true);
    }
}

