/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.ha;

import com.questdb.model.Quote;
import com.questdb.net.ha.MockByteChannel;
import com.questdb.net.ha.comsumer.JournalClientStateConsumer;
import com.questdb.net.ha.comsumer.JournalSymbolTableConsumer;
import com.questdb.net.ha.model.IndexedJournal;
import com.questdb.net.ha.model.JournalClientState;
import com.questdb.net.ha.producer.JournalClientStateProducer;
import com.questdb.net.ha.producer.JournalSymbolTableProducer;
import com.questdb.std.ex.JournalNetworkException;
import com.questdb.store.JournalWriter;
import com.questdb.test.tools.AbstractTest;
import com.questdb.test.tools.TestUtils;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JournalSymbolTableTest
extends AbstractTest {
    private final JournalClientStateProducer journalClientStateProducer = new JournalClientStateProducer();
    private final JournalClientStateConsumer journalClientStateConsumer = new JournalClientStateConsumer();
    private JournalWriter<Quote> origin;
    private JournalWriter<Quote> master;
    private JournalWriter<Quote> slave;
    private MockByteChannel channel;
    private JournalSymbolTableProducer journalSymbolTableProducer;
    private JournalSymbolTableConsumer journalSymbolTableConsumer;

    @Before
    public void setUp() throws Exception {
        this.origin = this.getFactory().writer(Quote.class, "origin");
        this.master = this.getFactory().writer(Quote.class, "master");
        this.slave = this.getFactory().writer(Quote.class, "slave");
        this.channel = new MockByteChannel();
        this.journalSymbolTableProducer = new JournalSymbolTableProducer(this.master);
        this.journalSymbolTableConsumer = new JournalSymbolTableConsumer(this.slave);
        this.origin.append((Object)new Quote().setSym("AB").setEx("EX1").setMode("M1"));
        this.origin.append((Object)new Quote().setSym("CD").setEx("EX2").setMode("M2"));
        this.origin.append((Object)new Quote().setSym("EF").setEx("EX3").setMode("M2"));
        this.origin.append((Object)new Quote().setSym("GH").setEx("EX3").setMode("M3"));
    }

    @Override
    @After
    public void tearDown() {
        this.origin.close();
        this.master.close();
        this.slave.close();
    }

    @Test
    public void testConsumerEqualToProducer() throws Exception {
        this.master.append(this.origin);
        this.master.commit(false, 101L, 10L);
        this.slave.append(this.origin);
        this.slave.commit(false, 101L, 10L);
        this.executeSequence(false);
    }

    @Test
    public void testConsumerLargerThanProducer() throws Exception {
        this.slave.append(this.origin);
        this.slave.commit(false, 101L, 10L);
        this.master.append(this.origin.query().all().asResultSet().subset(0, 3));
        this.master.commit(false, 101L, 10L);
        this.executeSequence(false);
    }

    @Test
    public void testConsumerSmallerThanProducer() throws Exception {
        this.master.append(this.origin.query().all().asResultSet().subset(0, 2));
        this.master.commit(false, 101L, 10L);
        this.master.append(this.origin.query().all().asResultSet().subset(2, 4));
        this.master.commit(false, 102L, 20L);
        this.slave.append(this.origin.query().all().asResultSet().subset(0, 2));
        this.slave.commit(false, 101L, 10L);
        this.executeSequence(true);
    }

    @Test
    public void testEmptyConsumerAndPopulatedProducer() throws Exception {
        this.master.append(this.origin);
        this.master.commit();
        this.executeSequence(true);
    }

    @Test
    public void testEmptyConsumerAndProducer() throws Exception {
        this.executeSequence(false);
    }

    private void executeSequence(boolean expectContent) throws JournalNetworkException {
        this.journalClientStateProducer.write((WritableByteChannel)this.channel, (Object)new IndexedJournal(0, this.slave));
        this.journalClientStateConsumer.read((ReadableByteChannel)this.channel);
        this.journalSymbolTableProducer.configure(this.master.find(((JournalClientState)this.journalClientStateConsumer.getValue()).getTxn(), ((JournalClientState)this.journalClientStateConsumer.getValue()).getTxPin()));
        Assert.assertEquals((Object)expectContent, (Object)this.journalSymbolTableProducer.hasContent());
        if (expectContent) {
            this.journalSymbolTableProducer.write((WritableByteChannel)this.channel);
            this.journalSymbolTableConsumer.read((ReadableByteChannel)this.channel);
            TestUtils.compareSymbolTables(this.master, this.slave);
        }
    }
}

