/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.ha;

import com.questdb.model.Quote;
import com.questdb.net.ha.AbstractJournalTest;
import com.questdb.std.time.DateFormatUtils;
import com.questdb.store.JournalWriter;
import com.questdb.test.tools.TestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JournalLagTest
extends AbstractJournalTest {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        TestUtils.generateQuoteData((JournalWriter<Quote>)this.origin, 500, DateFormatUtils.parseDateTime((CharSequence)"2013-02-01T00:00:00.000Z"), 100L);
        TestUtils.generateQuoteData((JournalWriter<Quote>)this.origin, 500, DateFormatUtils.parseDateTime((CharSequence)"2013-02-01T01:00:00.000Z"), 100L);
        TestUtils.generateQuoteData((JournalWriter<Quote>)this.origin, 500, DateFormatUtils.parseDateTime((CharSequence)"2013-02-01T13:00:00.000Z"), 100L);
        TestUtils.generateQuoteData((JournalWriter<Quote>)this.origin, 500, DateFormatUtils.parseDateTime((CharSequence)"2013-05-01T00:00:00.000Z"), 100L);
    }

    @Test
    public void testLagDetach() throws Exception {
        this.master.append(this.origin.query().all().asResultSet().subset(0, 500));
        this.master.mergeAppend(this.origin.query().all().asResultSet().subset(500, 600));
        this.master.commit();
        this.executeSequence(true);
        this.master.removeIrregularPartition();
        this.master.commit();
        this.executeSequence(true);
    }

    @Test
    public void testLagOnlyPropagation() throws Exception {
        this.master.append(this.origin.query().all().asResultSet().subset(0, 500));
        this.master.mergeAppend(this.origin.query().all().asResultSet().subset(500, 600));
        this.master.commit();
        String lagName = this.master.getIrregularPartition().getName();
        this.executeSequence(true);
        this.master.mergeAppend(this.origin.query().all().asResultSet().subset(600, 700));
        this.master.commit();
        Assert.assertEquals((Object)lagName, (Object)this.master.getIrregularPartition().getName());
        this.executeSequence(true);
    }
}

