/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.ha;

import com.questdb.net.ha.MockByteChannel;
import com.questdb.net.ha.comsumer.FixedColumnDeltaConsumer;
import com.questdb.net.ha.producer.FixedColumnDeltaProducer;
import com.questdb.std.ex.JournalException;
import com.questdb.store.AbstractColumn;
import com.questdb.store.FixedColumn;
import com.questdb.store.MemoryFile;
import java.io.File;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class FixedColumnTest {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();
    private MemoryFile file;
    private MemoryFile file2;
    private MockByteChannel channel;

    @After
    public void cleanup() {
        this.file.delete();
        this.file2.delete();
    }

    @Before
    public void setUp() throws JournalException {
        this.file = new MemoryFile(new File(this.temporaryFolder.getRoot(), "col.d"), 22, 2, false);
        this.file2 = new MemoryFile(new File(this.temporaryFolder.getRoot(), "col2.d"), 18, 2, false);
        this.channel = new MockByteChannel();
    }

    @After
    public void tearDown() {
        this.file.close();
        this.file2.close();
    }

    @Test
    public void testConsumerEqualToProducer() {
        int i;
        FixedColumn col1 = new FixedColumn(this.file, 4);
        FixedColumn col2 = new FixedColumn(this.file2, 4);
        FixedColumnDeltaProducer producer = new FixedColumnDeltaProducer((AbstractColumn)col1);
        int max = 1500000;
        for (i = 0; i < max; ++i) {
            col1.putInt(max - i);
            col1.commit();
        }
        for (i = 0; i < max; ++i) {
            col2.putInt(max - i);
            col2.commit();
        }
        producer.configure(col2.size(), col1.size());
        Assert.assertFalse((boolean)producer.hasContent());
        Assert.assertEquals((long)col1.size(), (long)col2.size());
        for (i = 0; i < max; ++i) {
            Assert.assertEquals((long)(max - i), (long)col2.getInt((long)i));
        }
    }

    @Test
    public void testConsumerLargerThanProducer() {
        int i;
        FixedColumn col1 = new FixedColumn(this.file, 4);
        FixedColumn col2 = new FixedColumn(this.file2, 4);
        FixedColumnDeltaProducer producer = new FixedColumnDeltaProducer((AbstractColumn)col1);
        int max = 1500000;
        for (i = 0; i < max - 500000; ++i) {
            col1.putInt(max - i);
            col1.commit();
        }
        for (i = 0; i < max; ++i) {
            col2.putInt(max - i);
            col2.commit();
        }
        producer.configure(col2.size(), col1.size());
        Assert.assertFalse((boolean)producer.hasContent());
    }

    @Test
    public void testConsumerReset() throws Exception {
        int i;
        FixedColumn col1 = new FixedColumn(this.file, 4);
        FixedColumn col2 = new FixedColumn(this.file2, 4);
        FixedColumnDeltaProducer producer = new FixedColumnDeltaProducer((AbstractColumn)col1);
        FixedColumnDeltaConsumer consumer = new FixedColumnDeltaConsumer((AbstractColumn)col2);
        int max = 1500000;
        for (i = 0; i < max; ++i) {
            col1.putInt(max - i);
            col1.commit();
        }
        for (i = 0; i < max - 500000; ++i) {
            col2.putInt(max - i);
            col2.commit();
        }
        producer.configure(col2.size(), col1.size());
        Assert.assertTrue((boolean)producer.hasContent());
        producer.write((WritableByteChannel)this.channel);
        consumer.read((ReadableByteChannel)this.channel);
        col2.commit();
        Assert.assertEquals((long)col1.size(), (long)col2.size());
        for (i = 0; i < 10000; ++i) {
            col1.putInt(max + 10000 - i);
            col1.commit();
        }
        producer.configure(col2.size(), col1.size());
        Assert.assertTrue((boolean)producer.hasContent());
        producer.write((WritableByteChannel)this.channel);
        consumer.read((ReadableByteChannel)this.channel);
        col2.commit();
        Assert.assertEquals((long)col1.size(), (long)col2.size());
        for (i = 0; i < max; ++i) {
            Assert.assertEquals((long)(max - i), (long)col2.getInt((long)i));
        }
        for (i = max; i < max + 10000; ++i) {
            Assert.assertEquals((long)(max + max + 10000 - i), (long)col2.getInt((long)i));
        }
    }

    @Test
    public void testConsumerSmallerThanProducer() throws Exception {
        int i;
        FixedColumn col1 = new FixedColumn(this.file, 4);
        FixedColumn col2 = new FixedColumn(this.file2, 4);
        FixedColumnDeltaProducer producer = new FixedColumnDeltaProducer((AbstractColumn)col1);
        FixedColumnDeltaConsumer consumer = new FixedColumnDeltaConsumer((AbstractColumn)col2);
        int max = 1500000;
        for (i = 0; i < max; ++i) {
            col1.putInt(max - i);
            col1.commit();
        }
        for (i = 0; i < max - 500000; ++i) {
            col2.putInt(max - i);
            col2.commit();
        }
        producer.configure(col2.size(), col1.size());
        Assert.assertTrue((boolean)producer.hasContent());
        producer.write((WritableByteChannel)this.channel);
        consumer.read((ReadableByteChannel)this.channel);
        col2.commit();
        Assert.assertEquals((long)col1.size(), (long)col2.size());
        for (i = 0; i < max; ++i) {
            Assert.assertEquals((long)(max - i), (long)col2.getInt((long)i));
        }
    }

    @Test
    public void testEmptyConsumerAndPopulatedProducer() throws Exception {
        int i;
        FixedColumn col1 = new FixedColumn(this.file, 4);
        FixedColumn col2 = new FixedColumn(this.file2, 4);
        FixedColumnDeltaProducer producer = new FixedColumnDeltaProducer((AbstractColumn)col1);
        FixedColumnDeltaConsumer consumer = new FixedColumnDeltaConsumer((AbstractColumn)col2);
        int max = 1500000;
        for (i = 0; i < max; ++i) {
            col1.putInt(max - i);
            col1.commit();
        }
        producer.configure(col2.size(), col1.size());
        Assert.assertTrue((boolean)producer.hasContent());
        producer.write((WritableByteChannel)this.channel);
        consumer.read((ReadableByteChannel)this.channel);
        col2.commit();
        Assert.assertEquals((long)col1.size(), (long)col2.size());
        for (i = 0; i < max; ++i) {
            Assert.assertEquals((long)(max - i), (long)col2.getInt((long)i));
        }
    }

    @Test
    public void testEmptyConsumerAndProducer() {
        FixedColumn col1 = new FixedColumn(this.file, 4);
        FixedColumn col2 = new FixedColumn(this.file2, 4);
        FixedColumnDeltaProducer producer = new FixedColumnDeltaProducer((AbstractColumn)col1);
        producer.configure(col2.size(), col1.size());
        Assert.assertFalse((boolean)producer.hasContent());
        Assert.assertEquals((long)col1.size(), (long)col2.size());
    }
}

