/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.ha;

import com.questdb.model.Quote;
import com.questdb.net.ha.JournalClient;
import com.questdb.net.ha.JournalServer;
import com.questdb.net.ha.config.ClientConfig;
import com.questdb.net.ha.config.ServerConfig;
import com.questdb.net.ha.config.ServerNode;
import com.questdb.store.JournalListener;
import com.questdb.store.JournalWriter;
import com.questdb.store.factory.ReaderFactory;
import com.questdb.store.factory.WriterFactory;
import com.questdb.test.tools.AbstractTest;
import com.questdb.test.tools.TestUtils;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class DataLossTest
extends AbstractTest {
    @Test
    @Ignore
    public void testDiscardFile() throws Exception {
        try (JournalWriter master = this.getFactory().writer(Quote.class, "master");){
            TestUtils.generateQuoteData((JournalWriter<Quote>)master, 300, master.getMaxTimestamp());
            master.commit();
            JournalServer server = new JournalServer(new ServerConfig(){
                {
                    this.addNode(new ServerNode(0, "localhost"));
                    this.setEnableMultiCast(false);
                    this.setHeartbeatFrequency(50L);
                }
            }, (ReaderFactory)this.getFactory());
            server.publish(master);
            server.start();
            final AtomicInteger counter = new AtomicInteger();
            final AtomicInteger doNotExpect = new AtomicInteger();
            JournalClient client = new JournalClient(new ClientConfig("localhost"){
                {
                    this.setEnableMultiCast(false);
                }
            }, (WriterFactory)this.getFactory());
            client.subscribe(Quote.class, "master", "slave", new JournalListener(){

                public void onCommit() {
                    counter.incrementAndGet();
                }

                public void onEvent(int event) {
                }
            });
            client.start();
            TestUtils.assertCounter(counter, 1, 10L, TimeUnit.SECONDS);
            client.halt();
            System.out.println("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
            try (JournalWriter slave = this.getFactory().writer(Quote.class, "slave");){
                TestUtils.generateQuoteData((JournalWriter<Quote>)slave, 200, slave.getMaxTimestamp());
                slave.commit();
            }
            client = new JournalClient(new ClientConfig("localhost"), (WriterFactory)this.getFactory());
            client.subscribe(Quote.class, "master", "slave", new JournalListener(){

                public void onCommit() {
                    doNotExpect.incrementAndGet();
                }

                public void onEvent(int event) {
                    counter.incrementAndGet();
                }
            });
            client.start();
            TestUtils.assertCounter(counter, 2, 180L, TimeUnit.SECONDS);
            client.halt();
            Assert.assertEquals((long)0L, (long)doNotExpect.get());
            var8_10 = null;
            try (JournalWriter w = this.getFactory().writer(Quote.class, "slave");){
                Assert.assertNotNull((Object)w);
            }
            catch (Throwable throwable) {
                var8_10 = throwable;
                throw throwable;
            }
            server.halt();
        }
    }
}

