/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.ha;

import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import com.questdb.model.Quote;
import com.questdb.model.configuration.ModelConfiguration;
import com.questdb.net.ha.ClusterController;
import com.questdb.net.ha.ClusterStatusListener;
import com.questdb.net.ha.config.ClientConfig;
import com.questdb.net.ha.config.ServerConfig;
import com.questdb.net.ha.config.ServerNode;
import com.questdb.std.NumericException;
import com.questdb.std.ex.JournalException;
import com.questdb.store.JournalWriter;
import com.questdb.store.factory.Factory;
import com.questdb.test.tools.AbstractTest;
import com.questdb.test.tools.FactoryContainer;
import com.questdb.test.tools.TestUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.After;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;

public class ClusterControllerTest
extends AbstractTest {
    private static final Log LOG = LogFactory.getLog(ClusterController.class);
    @Rule
    public final FactoryContainer tf = new FactoryContainer(ModelConfiguration.MAIN);
    @Rule
    public final FactoryContainer tf1 = new FactoryContainer(ModelConfiguration.MAIN);
    @Rule
    public final FactoryContainer tf2 = new FactoryContainer(ModelConfiguration.MAIN);
    @Rule
    public final FactoryContainer tf3 = new FactoryContainer(ModelConfiguration.MAIN);
    @Rule
    public final FactoryContainer tf4 = new FactoryContainer(ModelConfiguration.MAIN);
    @Rule
    public final FactoryContainer tf5 = new FactoryContainer(ModelConfiguration.MAIN);

    @Override
    @After
    public void tearDown() {
        Assert.assertEquals((long)0L, (long)this.tf.getFactory().getBusyWriterCount());
        Assert.assertEquals((long)0L, (long)this.tf1.getFactory().getBusyWriterCount());
        Assert.assertEquals((long)0L, (long)this.tf2.getFactory().getBusyWriterCount());
        Assert.assertEquals((long)0L, (long)this.tf3.getFactory().getBusyWriterCount());
        Assert.assertEquals((long)0L, (long)this.tf4.getFactory().getBusyWriterCount());
        Assert.assertEquals((long)0L, (long)this.tf5.getFactory().getBusyWriterCount());
        Assert.assertEquals((long)0L, (long)this.tf.getFactory().getBusyReaderCount());
        Assert.assertEquals((long)0L, (long)this.tf1.getFactory().getBusyReaderCount());
        Assert.assertEquals((long)0L, (long)this.tf2.getFactory().getBusyReaderCount());
        Assert.assertEquals((long)0L, (long)this.tf3.getFactory().getBusyReaderCount());
        Assert.assertEquals((long)0L, (long)this.tf4.getFactory().getBusyReaderCount());
        Assert.assertEquals((long)0L, (long)this.tf5.getFactory().getBusyReaderCount());
    }

    @Test
    @Ignore
    public void testBusyFailOver() throws Exception {
        try (final JournalWriter writer1 = this.getFactory().writer(Quote.class);
             final JournalWriter writer2 = this.tf.getFactory().writer(Quote.class);){
            final CountDownLatch active1 = new CountDownLatch(1);
            final CountDownLatch active2 = new CountDownLatch(1);
            final CountDownLatch standby2 = new CountDownLatch(1);
            final AtomicLong expected = new AtomicLong();
            final AtomicLong actual = new AtomicLong();
            ClusterController controller1 = new ClusterController(new ServerConfig(){
                {
                    this.addNode(new ServerNode(0, "localhost:7080"));
                    this.addNode(new ServerNode(1, "localhost:7090"));
                    this.setEnableMultiCast(false);
                    this.setHeartbeatFrequency(50L);
                }
            }, new ClientConfig(){
                {
                    this.setEnableMultiCast(false);
                }
            }, this.getFactory(), 0, (List)new ArrayList<JournalWriter>(){
                {
                    this.add(writer1);
                }
            }, new ClusterStatusListener(){

                public void goActive() {
                    try {
                        TestUtils.generateQuoteData((JournalWriter<Quote>)writer1, 100000);
                        TestUtils.generateQuoteData((JournalWriter<Quote>)writer1, 100000, writer1.getMaxTimestamp());
                        writer1.commit();
                        TestUtils.generateQuoteData((JournalWriter<Quote>)writer1, 100000, writer1.getMaxTimestamp());
                        writer1.commit();
                        TestUtils.generateQuoteData((JournalWriter<Quote>)writer1, 100000, writer1.getMaxTimestamp());
                        writer1.commit();
                        TestUtils.generateQuoteData((JournalWriter<Quote>)writer1, 100000, writer1.getMaxTimestamp());
                        writer1.commit();
                        expected.set(writer1.size());
                        active1.countDown();
                    }
                    catch (NumericException | JournalException e) {
                        e.printStackTrace();
                    }
                }

                public void goPassive(ServerNode activeNode) {
                }

                public void onShutdown() {
                }
            });
            ClusterController controller2 = new ClusterController(new ServerConfig(){
                {
                    this.addNode(new ServerNode(0, "localhost:7080"));
                    this.addNode(new ServerNode(1, "localhost:7090"));
                    this.setEnableMultiCast(false);
                    this.setHeartbeatFrequency(50L);
                }
            }, new ClientConfig(){
                {
                    this.setEnableMultiCast(false);
                }
            }, this.tf.getFactory(), 1, (List)new ArrayList<JournalWriter>(){
                {
                    this.add(writer2);
                }
            }, new ClusterStatusListener(){

                public void goActive() {
                    try {
                        actual.set(writer2.size());
                        active2.countDown();
                    }
                    catch (JournalException e) {
                        e.printStackTrace();
                    }
                }

                public void goPassive(ServerNode activeNode) {
                    standby2.countDown();
                }

                public void onShutdown() {
                }
            });
            controller1.start();
            Assert.assertTrue((boolean)active1.await(30L, TimeUnit.SECONDS));
            Assert.assertEquals((long)0L, (long)active1.getCount());
            controller2.start();
            standby2.await(60L, TimeUnit.SECONDS);
            Assert.assertEquals((long)0L, (long)standby2.getCount());
            controller1.halt();
            active2.await(10L, TimeUnit.SECONDS);
            Assert.assertEquals((long)0L, (long)active2.getCount());
            controller2.halt();
            Assert.assertTrue((expected.get() > 0L ? 1 : 0) != 0);
            Assert.assertEquals((long)expected.get(), (long)actual.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFiveNodesVoting() throws Exception {
        AtomicInteger active = new AtomicInteger();
        AtomicInteger standby = new AtomicInteger();
        AtomicInteger shutdown = new AtomicInteger();
        LOG.info().$((CharSequence)"======= VOTING TEST ==========").$();
        try (JournalWriter writer1 = this.tf1.getFactory().writer(Quote.class);
             JournalWriter writer2 = this.tf2.getFactory().writer(Quote.class);
             JournalWriter writer3 = this.tf3.getFactory().writer(Quote.class);
             JournalWriter writer4 = this.tf4.getFactory().writer(Quote.class);
             JournalWriter writer5 = this.tf5.getFactory().writer(Quote.class);){
            ClusterController c1 = this.createController2(writer1, 0, this.tf1.getFactory(), active, standby, shutdown);
            ClusterController c2 = this.createController2(writer2, 1, this.tf2.getFactory(), active, standby, shutdown);
            ClusterController c3 = this.createController2(writer3, 2, this.tf3.getFactory(), active, standby, shutdown);
            ClusterController c4 = this.createController2(writer4, 3, this.tf4.getFactory(), active, standby, shutdown);
            ClusterController c5 = this.createController2(writer5, 4, this.tf5.getFactory(), active, standby, shutdown);
            c1.start();
            c2.start();
            c3.start();
            c4.start();
            c5.start();
            long t = System.currentTimeMillis();
            while (standby.get() < 4 && TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - t) < 600L) {
                Thread.yield();
            }
            Assert.assertEquals((long)4L, (long)standby.get());
            t = System.currentTimeMillis();
            while (active.get() < 1 && TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - t) < 600L) {
                Thread.yield();
            }
            Assert.assertEquals((long)1L, (long)active.get());
            Thread.sleep(1000L);
            standby.set(0);
            active.set(0);
            LOG.info().$((CharSequence)"Stage 1, halt leader").$();
            if (c5.isLeader()) {
                c5.halt();
                LOG.info().$((CharSequence)"halted 4").$();
            } else if (c4.isLeader()) {
                c4.halt();
                LOG.info().$((CharSequence)"halted 3").$();
            } else if (c3.isLeader()) {
                c3.halt();
                LOG.info().$((CharSequence)"halted 2").$();
            } else if (c2.isLeader()) {
                c2.halt();
                LOG.info().$((CharSequence)"halted 1").$();
            } else if (c1.isLeader()) {
                c1.halt();
                LOG.info().$((CharSequence)"halted 0").$();
            } else {
                Assert.fail((String)"No leader");
            }
            LOG.info().$((CharSequence)"Stage 2, waiting for election process to complete").$();
            t = System.currentTimeMillis();
            while ((active.get() < 1 || standby.get() < 3) && TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - t) < 180L) {
                Thread.yield();
            }
            LOG.info().$((CharSequence)"Checking leader").$();
            try {
                Assert.assertEquals((long)3L, (long)standby.get());
                Assert.assertEquals((long)1L, (long)active.get());
                LOG.info().$((CharSequence)"Test complete").$();
            }
            finally {
                c1.halt();
                c2.halt();
                c3.halt();
                c4.halt();
            }
        }
    }

    @Test
    public void testStaggeredFailOver() throws Exception {
        CountDownLatch active1Latch = new CountDownLatch(1);
        CountDownLatch active2Latch = new CountDownLatch(1);
        CountDownLatch standby1Latch = new CountDownLatch(1);
        CountDownLatch standby2Latch = new CountDownLatch(1);
        CountDownLatch shutdown1 = new CountDownLatch(1);
        CountDownLatch shutdown2 = new CountDownLatch(1);
        try (JournalWriter writer1 = this.getFactory().writer(Quote.class);
             JournalWriter writer2 = this.tf.getFactory().writer(Quote.class);){
            ClusterController controller1 = this.createControllerX(writer1, 0, this.getFactory(), active1Latch, standby1Latch, shutdown1);
            controller1.start();
            Assert.assertTrue((boolean)active1Latch.await(5L, TimeUnit.SECONDS));
            Assert.assertEquals((String)"Node 1 is expected to be active", (long)0L, (long)active1Latch.getCount());
            standby1Latch.await(200L, TimeUnit.MILLISECONDS);
            Assert.assertEquals((String)"Node 1 standby callback is not expected to be called", (long)1L, (long)standby1Latch.getCount());
            ClusterController controller2 = this.createControllerX(writer2, 1, this.tf.getFactory(), active2Latch, standby2Latch, shutdown2);
            controller2.start();
            standby2Latch.await(5L, TimeUnit.SECONDS);
            Assert.assertEquals((String)"Node 2 is expected to be standing by", (long)0L, (long)standby2Latch.getCount());
            active2Latch.await(200L, TimeUnit.MILLISECONDS);
            Assert.assertEquals((String)"Node 2 active() callback is not expected to be called", (long)1L, (long)active2Latch.getCount());
            controller1.halt();
            shutdown1.await(5L, TimeUnit.SECONDS);
            Assert.assertEquals((long)0L, (long)shutdown1.getCount());
            active2Latch.await(5L, TimeUnit.SECONDS);
            Assert.assertEquals((long)0L, (long)active2Latch.getCount());
            controller2.halt();
            shutdown2.await(5L, TimeUnit.SECONDS);
            Assert.assertEquals((long)0L, (long)shutdown2.getCount());
        }
    }

    @Test
    public void testStaggeredStartup() throws Exception {
        CountDownLatch active1Latch = new CountDownLatch(1);
        CountDownLatch active2Latch = new CountDownLatch(1);
        CountDownLatch standby1Latch = new CountDownLatch(1);
        CountDownLatch standby2Latch = new CountDownLatch(1);
        CountDownLatch shutdown1 = new CountDownLatch(1);
        CountDownLatch shutdown2 = new CountDownLatch(1);
        try (JournalWriter writer1 = this.getFactory().writer(Quote.class);
             JournalWriter writer2 = this.tf.getFactory().writer(Quote.class);){
            ClusterController controller1 = this.createControllerX(writer1, 0, this.getFactory(), active1Latch, standby1Latch, shutdown1);
            controller1.start();
            Assert.assertTrue((boolean)active1Latch.await(5L, TimeUnit.SECONDS));
            Assert.assertEquals((String)"Node 1 is expected to be active", (long)0L, (long)active1Latch.getCount());
            standby1Latch.await(200L, TimeUnit.MILLISECONDS);
            Assert.assertEquals((String)"Node 1 standby callback is not expected to be called", (long)1L, (long)standby1Latch.getCount());
            ClusterController controller2 = this.createControllerX(writer2, 1, this.tf.getFactory(), active2Latch, standby2Latch, shutdown2);
            controller2.start();
            standby2Latch.await(5L, TimeUnit.SECONDS);
            Assert.assertEquals((String)"Node 2 is expected to be standing by", (long)0L, (long)standby2Latch.getCount());
            active2Latch.await(200L, TimeUnit.MILLISECONDS);
            Assert.assertEquals((String)"Node 2 active() callback is not expected to be called", (long)1L, (long)active2Latch.getCount());
            controller2.halt();
            shutdown2.await(5L, TimeUnit.SECONDS);
            Assert.assertEquals((long)0L, (long)shutdown2.getCount());
            controller1.halt();
            shutdown1.await(5L, TimeUnit.SECONDS);
            Assert.assertEquals((long)0L, (long)shutdown1.getCount());
        }
    }

    @Test
    public void testStandalone() throws Exception {
        CountDownLatch active = new CountDownLatch(1);
        CountDownLatch standby = new CountDownLatch(1);
        CountDownLatch shutdown = new CountDownLatch(1);
        try (JournalWriter writer = this.getFactory().writer(Quote.class);){
            ClusterController controller = this.createControllerX(writer, 1, this.getFactory(), active, standby, shutdown);
            controller.start();
            Assert.assertTrue((boolean)active.await(5L, TimeUnit.SECONDS));
            Assert.assertEquals((String)"goActive() did not fire", (long)0L, (long)active.getCount());
            standby.await(200L, TimeUnit.MILLISECONDS);
            Assert.assertEquals((String)"goPassive() not expected to fire", (long)1L, (long)standby.getCount());
            controller.halt();
            shutdown.await(5L, TimeUnit.SECONDS);
            Assert.assertEquals((long)0L, (long)shutdown.getCount());
            controller.halt();
        }
    }

    @Test
    public void testTiebreakFailOver() throws Exception {
        CountDownLatch active1Latch = new CountDownLatch(1);
        CountDownLatch active2Latch = new CountDownLatch(1);
        CountDownLatch standby1Latch = new CountDownLatch(1);
        CountDownLatch standby2Latch = new CountDownLatch(1);
        CountDownLatch shutdown1 = new CountDownLatch(1);
        CountDownLatch shutdown2 = new CountDownLatch(1);
        try (JournalWriter writer1 = this.getFactory().writer(Quote.class);
             JournalWriter writer2 = this.tf.getFactory().writer(Quote.class);){
            ClusterController controller1 = this.createControllerX(writer1, 0, this.getFactory(), active1Latch, standby1Latch, shutdown1);
            ClusterController controller2 = this.createControllerX(writer2, 1, this.tf.getFactory(), active2Latch, standby2Latch, shutdown2);
            controller2.start();
            controller1.start();
            this.getFactory().close();
            long t = System.currentTimeMillis();
            do {
                active1Latch.await(1L, TimeUnit.MICROSECONDS);
                active2Latch.await(1L, TimeUnit.MICROSECONDS);
            } while (active1Latch.getCount() > 0L && active2Latch.getCount() > 0L && System.currentTimeMillis() - t < 2000L);
            Assert.assertFalse((String)"Two nodes are active simultaneously", (active1Latch.getCount() == 0L && active2Latch.getCount() == 0L ? 1 : 0) != 0);
            Assert.assertFalse((String)"No leader", (active1Latch.getCount() > 0L && active2Latch.getCount() > 0L ? 1 : 0) != 0);
            if (active1Latch.getCount() == 0L) {
                standby2Latch.await(2L, TimeUnit.SECONDS);
                Assert.assertEquals((String)"Node 2 is expected to be on standby", (long)0L, (long)standby2Latch.getCount());
                standby1Latch.await(200L, TimeUnit.MILLISECONDS);
                Assert.assertEquals((String)"Node 1 is NOT expected to be on standby", (long)1L, (long)standby1Latch.getCount());
            } else {
                standby1Latch.await(2L, TimeUnit.SECONDS);
                Assert.assertEquals((String)"Node 1 is expected to be on standby", (long)0L, (long)standby1Latch.getCount());
                standby2Latch.await(200L, TimeUnit.MILLISECONDS);
                Assert.assertEquals((String)"Node 2 is NOT expected to be on standby", (long)1L, (long)standby2Latch.getCount());
            }
            controller2.halt();
            shutdown2.await(5L, TimeUnit.SECONDS);
            Assert.assertEquals((String)"Controller 2 should have shut down", (long)0L, (long)shutdown2.getCount());
            active1Latch.await(10L, TimeUnit.SECONDS);
            Assert.assertEquals((String)"Node 1 is expected to become active", (long)0L, (long)active1Latch.getCount());
            controller1.halt();
            shutdown1.await(10L, TimeUnit.SECONDS);
            Assert.assertEquals((String)"Controller 1 should have shut down", (long)0L, (long)shutdown1.getCount());
        }
    }

    private ClusterController createController2(final JournalWriter writer, int instance, Factory factory, final AtomicInteger active, final AtomicInteger standby, final AtomicInteger shutdown) {
        return new ClusterController(new ServerConfig(){
            {
                this.addNode(new ServerNode(4, "localhost:7040"));
                this.addNode(new ServerNode(3, "localhost:7041"));
                this.addNode(new ServerNode(2, "localhost:7042"));
                this.addNode(new ServerNode(1, "localhost:7043"));
                this.addNode(new ServerNode(0, "localhost:7044"));
                this.setHeartbeatFrequency(50L);
                this.setEnableMultiCast(false);
            }
        }, new ClientConfig(){
            {
                this.setEnableMultiCast(false);
                this.setConnectionTimeout(30000L);
            }
        }, factory, instance, (List)new ArrayList<JournalWriter>(){
            {
                this.add(writer);
            }
        }, new ClusterStatusListener(){

            public void goActive() {
                active.incrementAndGet();
            }

            public void goPassive(ServerNode activeNode) {
                standby.incrementAndGet();
            }

            public void onShutdown() {
                shutdown.incrementAndGet();
            }
        });
    }

    private ClusterController createControllerX(final JournalWriter writer, int instance, Factory factory, final CountDownLatch active, final CountDownLatch standby, final CountDownLatch shutdown) {
        return new ClusterController(new ServerConfig(){
            {
                this.addNode(new ServerNode(0, "localhost:7080"));
                this.addNode(new ServerNode(1, "localhost:7090"));
                this.setEnableMultiCast(false);
                this.setHeartbeatFrequency(50L);
            }
        }, new ClientConfig(){
            {
                this.setEnableMultiCast(false);
            }
        }, factory, instance, (List)new ArrayList<JournalWriter>(){
            {
                this.add(writer);
            }
        }, new ClusterStatusListener(){

            public void goActive() {
                active.countDown();
            }

            public void goPassive(ServerNode activeNode) {
                standby.countDown();
            }

            public void onShutdown() {
                shutdown.countDown();
            }
        });
    }
}

