/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.ha;

import com.questdb.model.Quote;
import com.questdb.net.ha.JournalClient;
import com.questdb.net.ha.JournalServer;
import com.questdb.net.ha.auth.CredentialProvider;
import com.questdb.net.ha.config.ClientConfig;
import com.questdb.net.ha.config.ServerConfig;
import com.questdb.net.ha.config.ServerNode;
import com.questdb.net.ha.krb.SSOCredentialProvider;
import com.questdb.std.NumericException;
import com.questdb.std.ex.FatalError;
import com.questdb.std.ex.JournalException;
import com.questdb.std.ex.JournalNetworkException;
import com.questdb.store.Journal;
import com.questdb.store.JournalListener;
import com.questdb.store.JournalWriter;
import com.questdb.store.factory.ReaderFactory;
import com.questdb.store.factory.WriterFactory;
import com.questdb.test.tools.AbstractTest;
import com.questdb.test.tools.TestUtils;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;

public class AuthorizationTest
extends AbstractTest {
    private final ClientConfig local = new ClientConfig("localhost"){
        {
            this.addNode(new ServerNode(1, "xyz"));
            this.addNode(new ServerNode(2, "localhost"));
        }
    };

    @Test
    public void testClientAndServerSuccessfulAuth() throws Exception {
        JournalServer server = new JournalServer(new ServerConfig(){
            {
                this.setHeartbeatFrequency(TimeUnit.MILLISECONDS.toMillis(100L));
                this.setEnableMultiCast(false);
            }
        }, (ReaderFactory)this.getFactory(), (token, requestedKeys) -> "SECRET".equals(new String(token)));
        JournalClient client = new JournalClient(this.local, (WriterFactory)this.getFactory(), "SECRET"::getBytes);
        this.beginSync(server, client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClientWithoutAuthProvider() throws Exception {
        JournalServer server = new JournalServer(new ServerConfig(){
            {
                this.setHeartbeatFrequency(TimeUnit.MILLISECONDS.toMillis(500L));
                this.setEnableMultiCast(false);
            }
        }, (ReaderFactory)this.getFactory(), (token, requestedKeys) -> "SECRET".equals(new String(token)));
        server.start();
        try {
            AtomicInteger authErrors = new AtomicInteger();
            CountDownLatch error = new CountDownLatch(1);
            JournalClient client = new JournalClient(this.local, (WriterFactory)this.getFactory(), null, evt -> {
                switch (evt) {
                    case 64: {
                        authErrors.incrementAndGet();
                        break;
                    }
                    case 256: {
                        error.countDown();
                        break;
                    }
                }
            });
            client.start();
            Assert.assertTrue((boolean)error.await(5L, TimeUnit.SECONDS));
            Assert.assertFalse((boolean)client.isRunning());
        }
        finally {
            server.halt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClientWrongAuth() throws Exception {
        JournalServer server = new JournalServer(new ServerConfig(){
            {
                this.setHeartbeatFrequency(TimeUnit.MILLISECONDS.toMillis(500L));
                this.setEnableMultiCast(false);
            }
        }, (ReaderFactory)this.getFactory(), (token, requestedKeys) -> "SECRET".equals(new String(token)));
        AtomicInteger authErrorCount = new AtomicInteger();
        CountDownLatch serverError = new CountDownLatch(1);
        JournalClient client = new JournalClient(this.local, (WriterFactory)this.getFactory(), "NON_SECRET"::getBytes, evt -> {
            switch (evt) {
                case 128: {
                    authErrorCount.incrementAndGet();
                    break;
                }
                case 256: {
                    serverError.countDown();
                    break;
                }
            }
        });
        server.start();
        try {
            client.start();
            Assert.assertTrue((boolean)serverError.await(5L, TimeUnit.SECONDS));
            Assert.assertFalse((boolean)client.isRunning());
            Assert.assertEquals((long)1L, (long)authErrorCount.get());
        }
        finally {
            server.halt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExceptionInCredentialProvider() throws Exception {
        JournalServer server = new JournalServer(new ServerConfig(){
            {
                this.setHeartbeatFrequency(TimeUnit.MILLISECONDS.toMillis(500L));
                this.setEnableMultiCast(false);
            }
        }, (ReaderFactory)this.getFactory(), (token, requestedKeys) -> "SECRET".equals(new String(token)));
        AtomicInteger authErrorCount = new AtomicInteger();
        CountDownLatch terminated = new CountDownLatch(1);
        JournalClient client = new JournalClient(this.local, (WriterFactory)this.getFactory(), (CredentialProvider)new SSOCredentialProvider("HOST/test"), evt -> {
            switch (evt) {
                case 64: {
                    authErrorCount.incrementAndGet();
                    break;
                }
                case 256: {
                    terminated.countDown();
                    break;
                }
            }
        });
        server.start();
        try {
            client.start();
            Assert.assertTrue((boolean)terminated.await(5L, TimeUnit.SECONDS));
            Assert.assertEquals((long)1L, (long)authErrorCount.get());
            Assert.assertFalse((boolean)client.isRunning());
        }
        finally {
            server.halt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testServerAuthException() throws Exception {
        JournalServer server = new JournalServer(new ServerConfig(){
            {
                this.setHeartbeatFrequency(TimeUnit.MILLISECONDS.toMillis(500L));
                this.setEnableMultiCast(false);
            }
        }, (ReaderFactory)this.getFactory(), (token, requestedKeys) -> {
            throw new FatalError("BANG!");
        });
        AtomicInteger authErrorCount = new AtomicInteger();
        CountDownLatch serverError = new CountDownLatch(1);
        JournalClient client = new JournalClient(this.local, (WriterFactory)this.getFactory(), "SECRET"::getBytes, evt -> {
            switch (evt) {
                case 128: {
                    authErrorCount.incrementAndGet();
                    break;
                }
                case 256: {
                    serverError.countDown();
                    break;
                }
            }
        });
        server.start();
        try {
            client.start();
            Assert.assertTrue((boolean)serverError.await(5L, TimeUnit.SECONDS));
            Assert.assertFalse((boolean)client.isRunning());
            Assert.assertEquals((long)1L, (long)authErrorCount.get());
        }
        finally {
            server.halt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beginSync(JournalServer server, JournalClient client) throws JournalException, JournalNetworkException, InterruptedException, NumericException {
        int size = 100000;
        try (JournalWriter remote = this.getFactory().writer(Quote.class, "remote", 2 * size);){
            server.publish(remote);
            server.start();
            try {
                final CountDownLatch latch = new CountDownLatch(1);
                client.subscribe(Quote.class, "remote", "local", 2 * size, new JournalListener(){

                    public void onCommit() {
                        latch.countDown();
                    }

                    public void onEvent(int event) {
                    }
                });
                client.start();
                try {
                    TestUtils.generateQuoteData((JournalWriter<Quote>)remote, size);
                    latch.await();
                    try (Journal local = this.getFactory().reader(Quote.class, "local");){
                        TestUtils.assertDataEquals(remote, local);
                    }
                }
                finally {
                    client.halt();
                }
            }
            finally {
                server.halt(0L, TimeUnit.SECONDS);
            }
        }
    }
}

