/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.ha;

import com.questdb.model.Quote;
import com.questdb.net.ha.MockByteChannel;
import com.questdb.net.ha.comsumer.JournalClientStateConsumer;
import com.questdb.net.ha.comsumer.JournalDeltaConsumer;
import com.questdb.net.ha.model.IndexedJournal;
import com.questdb.net.ha.model.JournalClientState;
import com.questdb.net.ha.producer.JournalClientStateProducer;
import com.questdb.net.ha.producer.JournalDeltaProducer;
import com.questdb.std.ex.JournalException;
import com.questdb.std.ex.JournalNetworkException;
import com.questdb.store.Journal;
import com.questdb.store.JournalWriter;
import com.questdb.test.tools.AbstractTest;
import com.questdb.test.tools.TestUtils;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public abstract class AbstractJournalTest
extends AbstractTest {
    JournalWriter<Quote> origin;
    JournalWriter<Quote> master;
    JournalWriter<Quote> slave;
    private MockByteChannel channel;
    private JournalDeltaProducer journalDeltaProducer;
    private JournalDeltaConsumer journalDeltaConsumer;
    private JournalClientStateProducer journalClientStateProducer;
    private JournalClientStateConsumer journalClientStateConsumer;
    private Journal<Quote> masterReader;

    @Before
    public void setUp() throws Exception {
        this.origin = this.getFactory().writer(Quote.class, "origin");
        this.slave = this.getFactory().writer(Quote.class, "slave");
        this.master = this.getFactory().writer(Quote.class, "master");
        this.journalClientStateProducer = new JournalClientStateProducer();
        this.journalClientStateConsumer = new JournalClientStateConsumer();
        this.masterReader = this.getFactory().reader(Quote.class, "master");
        this.journalDeltaProducer = new JournalDeltaProducer(this.masterReader);
        this.journalDeltaConsumer = new JournalDeltaConsumer(this.slave);
        this.channel = new MockByteChannel();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.origin.close();
        this.slave.close();
        this.master.close();
        this.masterReader.close();
        this.journalDeltaProducer.free();
        this.journalDeltaConsumer.free();
        super.tearDown();
    }

    void executeSequence(boolean expectContent) throws JournalNetworkException, JournalException {
        this.slave.refresh();
        this.journalClientStateProducer.write((WritableByteChannel)this.channel, (Object)new IndexedJournal(0, this.slave));
        this.journalClientStateConsumer.read((ReadableByteChannel)this.channel);
        this.journalDeltaProducer.configure(((JournalClientState)this.journalClientStateConsumer.getValue()).getTxn(), ((JournalClientState)this.journalClientStateConsumer.getValue()).getTxPin());
        Assert.assertEquals((Object)expectContent, (Object)this.journalDeltaProducer.hasContent());
        if (expectContent) {
            this.journalDeltaProducer.write((WritableByteChannel)this.channel);
            this.journalDeltaConsumer.read((ReadableByteChannel)this.channel);
            TestUtils.assertEquals(this.master, this.slave);
        }
    }
}

