/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net;

import com.questdb.net.GZipWritableChannel;
import com.questdb.test.tools.TestUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.util.zip.GZIPInputStream;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class GZipWritableChannelTest {
    @Rule
    public final TemporaryFolder temp = new TemporaryFolder();

    @Test
    public void testGzip() throws Exception {
        File expected = new File(GZipWritableChannelTest.class.getResource("/large.csv").getFile());
        File compressed = this.temp.newFile();
        try (FileInputStream fis = new FileInputStream(expected);
             FileOutputStream fos = new FileOutputStream(compressed);
             FileChannel in = fis.getChannel();
             FileChannel out = fos.getChannel();
             GZipWritableChannel gzip = new GZipWritableChannel(65536).of((WritableByteChannel)out);){
            MappedByteBuffer buf = in.map(FileChannel.MapMode.READ_ONLY, 0L, fis.available());
            gzip.write((ByteBuffer)buf);
            gzip.flush();
        }
        File actual = this.temp.newFile();
        try (GZIPInputStream is = new GZIPInputStream(new FileInputStream(compressed));
             FileOutputStream fos = new FileOutputStream(actual);){
            int l;
            byte[] buf = new byte[16384];
            while ((l = is.read(buf)) > 0) {
                fos.write(buf, 0, l);
            }
        }
        TestUtils.assertEquals(expected, actual);
    }
}

