/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.mp;

import com.questdb.mp.Barrier;
import com.questdb.mp.ConcurrentTest;
import com.questdb.mp.Event;
import com.questdb.mp.RingQueue;
import com.questdb.mp.SCSequence;
import com.questdb.mp.SPSequence;
import com.questdb.mp.Sequence;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;

public class OneToOnePerformanceTest {
    public static void main(String[] args) throws BrokenBarrierException, InterruptedException {
        int i;
        int cycle = 1024;
        int size = 1024 * cycle * 100;
        RingQueue queue = new RingQueue(Event.FACTORY, cycle);
        SPSequence pubSeq = new SPSequence(cycle);
        SCSequence subSeq = new SCSequence((long)cycle, null);
        pubSeq.then((Barrier)subSeq).then((Barrier)pubSeq);
        int workerCount = 1;
        CyclicBarrier barrier = new CyclicBarrier(workerCount + 1);
        CountDownLatch latch = new CountDownLatch(workerCount);
        BusyConsumer[] consumers = new BusyConsumer[workerCount];
        for (i = 0; i < workerCount; ++i) {
            consumers[i] = new BusyConsumer((Sequence)subSeq, (RingQueue<Event>)queue, barrier, latch);
        }
        for (i = 0; i < workerCount; ++i) {
            consumers[i].start();
        }
        barrier.await();
        long t = System.currentTimeMillis();
        int i2 = 0;
        while (true) {
            long cursor;
            if ((cursor = pubSeq.next()) < 0L) {
                continue;
            }
            ((Event)queue.get((long)cursor)).value = i2++;
            pubSeq.done(cursor);
            if (i2 == size) break;
        }
        for (int j = 0; j < workerCount; ++j) {
            ConcurrentTest.publishEOE((RingQueue<Event>)queue, (Sequence)pubSeq);
        }
        latch.await();
        System.out.format("Processed = %,d ops/sec%n", (long)size * 1000L / (System.currentTimeMillis() - t));
    }

    static class BusyConsumer
    extends Thread {
        private final Sequence sequence;
        private final RingQueue<Event> queue;
        private final CyclicBarrier barrier;
        private final CountDownLatch latch;

        BusyConsumer(Sequence sequence, RingQueue<Event> queue, CyclicBarrier barrier, CountDownLatch latch) {
            this.sequence = sequence;
            this.queue = queue;
            this.barrier = barrier;
            this.latch = latch;
        }

        @Override
        public void run() {
            try {
                this.barrier.await();
                while (true) {
                    long cursor;
                    if ((cursor = this.sequence.next()) < 0L) {
                        continue;
                    }
                    int v = ((Event)this.queue.get((long)cursor)).value;
                    this.sequence.done(cursor);
                    if (v == Integer.MIN_VALUE) break;
                }
                this.latch.countDown();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

