/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.model;

public class Quote {
    private long timestamp;
    private String sym;
    private double bid;
    private double ask;
    private int bidSize;
    private int askSize;
    private String mode;
    private String ex;

    public void clear() {
        this.timestamp = 0L;
        this.sym = null;
        this.bid = 0.0;
        this.ask = 0.0;
        this.bidSize = 0;
        this.askSize = 0;
        this.mode = null;
        this.ex = null;
    }

    public double getAsk() {
        return this.ask;
    }

    public Quote setAsk(double ask) {
        this.ask = ask;
        return this;
    }

    public int getAskSize() {
        return this.askSize;
    }

    public Quote setAskSize(int askSize) {
        this.askSize = askSize;
        return this;
    }

    public double getBid() {
        return this.bid;
    }

    public Quote setBid(double bid) {
        this.bid = bid;
        return this;
    }

    public int getBidSize() {
        return this.bidSize;
    }

    public Quote setBidSize(int bidSize) {
        this.bidSize = bidSize;
        return this;
    }

    public String getEx() {
        return this.ex;
    }

    public Quote setEx(String ex) {
        this.ex = ex;
        return this;
    }

    public String getMode() {
        return this.mode;
    }

    public Quote setMode(String mode) {
        this.mode = mode;
        return this;
    }

    public CharSequence getSym() {
        return this.sym;
    }

    public Quote setSym(String sym) {
        this.sym = sym;
        return this;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Quote setTimestamp(long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public int hashCode() {
        int result = (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + (this.sym != null ? this.sym.hashCode() : 0);
        long temp = Double.doubleToLongBits(this.bid);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.ask);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.bidSize;
        result = 31 * result + this.askSize;
        result = 31 * result + (this.mode != null ? this.mode.hashCode() : 0);
        result = 31 * result + (this.ex != null ? this.ex.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Quote)) {
            return false;
        }
        Quote quote = (Quote)o;
        return !(Double.compare(quote.ask, this.ask) != 0 || this.askSize != quote.askSize || Double.compare(quote.bid, this.bid) != 0 || this.bidSize != quote.bidSize || this.timestamp != quote.timestamp || (this.ex == null ? quote.ex != null : !this.ex.equals(quote.ex)) || (this.mode == null ? quote.mode != null : !this.mode.equals(quote.mode)) || (this.sym == null ? quote.sym != null : !this.sym.equals(quote.sym)));
    }

    public String toString() {
        return "Quote{timestamp=" + this.timestamp + ", sym='" + this.sym + '\'' + ", bid=" + this.bid + ", ask=" + this.ask + ", bidSize=" + this.bidSize + ", askSize=" + this.askSize + ", mode='" + this.mode + '\'' + ", ex='" + this.ex + '\'' + '}';
    }
}

