/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.misc;

import com.questdb.std.Files;
import com.questdb.std.Unsafe;
import com.questdb.std.Zip;
import com.questdb.std.ex.FatalError;
import com.questdb.std.str.LPSZ;
import com.questdb.std.str.Path;
import com.questdb.test.tools.TestUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.zip.GZIPInputStream;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class ZipTest {
    @Rule
    public final TemporaryFolder temp = new TemporaryFolder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGzip() throws Exception {
        try (Path path = new Path();){
            File outFile = this.temp.newFile("x");
            File expected = new File(ZipTest.class.getResource("/large.csv").getFile());
            int available = 65536;
            long in = Unsafe.malloc((long)65536L);
            long out = Unsafe.malloc((long)32768L);
            try {
                long strm = Zip.deflateInit();
                try {
                    long pIn = 0L;
                    long pOut = 0L;
                    long fdIn = Files.openRO((LPSZ)path.of((CharSequence)expected.getAbsolutePath()).$());
                    try {
                        long fdOut = Files.openRW((LPSZ)path.of((CharSequence)outFile.getAbsolutePath()).$());
                        try {
                            int have;
                            int ret;
                            int len;
                            Files.write((long)fdOut, (long)Zip.gzipHeader, (long)10L, (long)pOut);
                            pOut += 10L;
                            int crc = 0;
                            while ((len = (int)Files.read((long)fdIn, (long)in, (long)65536L, (long)pIn)) > 0) {
                                pIn += (long)len;
                                Zip.setInput((long)strm, (long)in, (int)len);
                                crc = Zip.crc32((int)crc, (long)in, (int)len);
                                do {
                                    if ((ret = Zip.deflate((long)strm, (long)out, (int)65536, (boolean)false)) < 0) {
                                        throw new FatalError("Error in deflator: " + ret);
                                    }
                                    have = 65536 - Zip.availOut((long)strm);
                                    if (have <= 0) continue;
                                    Files.write((long)fdOut, (long)out, (long)have, (long)pOut);
                                    pOut += (long)have;
                                } while (Zip.availIn((long)strm) > 0);
                            }
                            do {
                                if ((ret = Zip.deflate((long)strm, (long)out, (int)65536, (boolean)true)) < 0) {
                                    throw new FatalError("Error in deflator: " + ret);
                                }
                                have = 65536 - Zip.availOut((long)strm);
                                if (have <= 0) continue;
                                Files.write((long)fdOut, (long)out, (long)have, (long)pOut);
                                pOut += (long)have;
                            } while (ret != 1);
                            Unsafe.getUnsafe().putInt(out, crc);
                            Unsafe.getUnsafe().putInt(out + 4L, (int)pIn);
                            Files.write((long)fdOut, (long)out, (long)8L, (long)pOut);
                        }
                        finally {
                            Files.close((long)fdOut);
                        }
                    }
                    finally {
                        Files.close((long)fdIn);
                    }
                }
                finally {
                    Zip.deflateEnd((long)strm);
                }
            }
            finally {
                Unsafe.free((long)in, (long)65536L);
                Unsafe.free((long)out, (long)32768L);
            }
            File actual = this.temp.newFile();
            try (GZIPInputStream is = new GZIPInputStream(new FileInputStream(outFile));
                 FileOutputStream fos = new FileOutputStream(actual);){
                int l;
                byte[] buf = new byte[16384];
                while ((l = is.read(buf)) > 0) {
                    fos.write(buf, 0, l);
                }
            }
            TestUtils.assertEquals(expected, actual);
        }
    }
}

