/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.misc;

import com.questdb.std.Numbers;
import com.questdb.std.NumericException;
import com.questdb.std.Rnd;
import com.questdb.std.str.CharSink;
import com.questdb.std.str.StringSink;
import com.questdb.test.tools.TestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NumbersTest {
    private final StringSink sink = new StringSink();
    private Rnd rnd;

    @Test(expected=NumericException.class)
    public void parseExplicitDouble2() throws Exception {
        Numbers.parseDouble((CharSequence)"1234dx");
    }

    @Test
    public void parseExplicitLong() throws Exception {
        Assert.assertEquals((long)10000L, (long)Numbers.parseLong((CharSequence)"10000L"));
    }

    @Test(expected=NumericException.class)
    public void parseExplicitLong2() throws Exception {
        Numbers.parseLong((CharSequence)"10000LL");
    }

    @Before
    public void setUp() {
        this.rnd = new Rnd();
        this.sink.clear();
    }

    @Test
    public void testCeilPow2() {
        Assert.assertEquals((long)16L, (long)Numbers.ceilPow2((int)15));
        Assert.assertEquals((long)16L, (long)Numbers.ceilPow2((int)16));
        Assert.assertEquals((long)32L, (long)Numbers.ceilPow2((int)17));
    }

    @Test(expected=NumericException.class)
    public void testEmptyDouble() throws Exception {
        Numbers.parseDouble((CharSequence)"D");
    }

    @Test(expected=NumericException.class)
    public void testEmptyFloat() throws Exception {
        Numbers.parseFloat((CharSequence)"f");
    }

    @Test(expected=NumericException.class)
    public void testEmptyLong() throws Exception {
        Numbers.parseLong((CharSequence)"L");
    }

    @Test
    public void testFormatByte() {
        for (int i = 0; i < 1000; ++i) {
            byte n = (byte)this.rnd.nextInt();
            this.sink.clear();
            Numbers.append((CharSink)this.sink, (int)n);
            Assert.assertEquals((Object)Byte.toString(n), (Object)this.sink.toString());
        }
    }

    @Test
    public void testFormatChar() {
        for (int i = 0; i < 1000; ++i) {
            char n = (char)this.rnd.nextInt();
            this.sink.clear();
            Numbers.append((CharSink)this.sink, (int)n);
            Assert.assertEquals((Object)Integer.toString(n), (Object)this.sink.toString());
        }
    }

    @Test
    public void testFormatDouble() {
        Numbers.append((CharSink)this.sink, (double)Double.POSITIVE_INFINITY, (int)3);
        Assert.assertEquals((Object)Double.toString(Double.POSITIVE_INFINITY), (Object)this.sink.toString());
        this.sink.clear();
        Numbers.append((CharSink)this.sink, (double)Double.NEGATIVE_INFINITY, (int)3);
        Assert.assertEquals((Object)Double.toString(Double.NEGATIVE_INFINITY), (Object)this.sink.toString());
        this.sink.clear();
        Numbers.append((CharSink)this.sink, (double)Double.NaN, (int)3);
        Assert.assertEquals((Object)Double.toString(Double.NaN), (Object)this.sink.toString());
        for (int i = 0; i < 1000; ++i) {
            int n = this.rnd.nextPositiveInt() % 10;
            double d = this.rnd.nextDouble2() * Math.pow(10.0, n);
            this.sink.clear();
            Numbers.append((CharSink)this.sink, (double)d, (int)8);
            String actual = this.sink.toString();
            String expected = Double.toString(d);
            Assert.assertEquals((double)Double.parseDouble(expected), (double)Double.parseDouble(actual), (double)1.0E-6);
        }
    }

    @Test
    public void testFormatDoubleNoPadding() {
        this.sink.clear();
        Numbers.appendTrim((CharSink)this.sink, (double)40.2345, (int)12);
        Assert.assertEquals((Object)"40.2345", (Object)this.sink.toString());
        this.sink.clear();
        Numbers.appendTrim((CharSink)this.sink, (double)4000.0, (int)12);
        Assert.assertEquals((Object)"4000.0", (Object)this.sink.toString());
    }

    @Test
    public void testFormatFloat() {
        Numbers.append((CharSink)this.sink, (float)Float.POSITIVE_INFINITY, (int)3);
        Assert.assertEquals((Object)Float.toString(Float.POSITIVE_INFINITY), (Object)this.sink.toString());
        this.sink.clear();
        Numbers.append((CharSink)this.sink, (float)Float.NEGATIVE_INFINITY, (int)3);
        Assert.assertEquals((Object)Float.toString(Float.NEGATIVE_INFINITY), (Object)this.sink.toString());
        this.sink.clear();
        Numbers.append((CharSink)this.sink, (float)Float.NaN, (int)3);
        Assert.assertEquals((Object)Float.toString(Float.NaN), (Object)this.sink.toString());
        for (int i = 0; i < 1000; ++i) {
            int n = this.rnd.nextPositiveInt() % 10;
            float f = this.rnd.nextFloat2() * (float)Math.pow(10.0, n);
            this.sink.clear();
            Numbers.append((CharSink)this.sink, (float)f, (int)8);
            String actual = this.sink.toString();
            String expected = Float.toString(f);
            Assert.assertEquals((double)Float.parseFloat(expected), (double)Float.parseFloat(actual), (double)1.0E-5);
        }
    }

    @Test
    public void testFormatInt() {
        for (int i = 0; i < 1000; ++i) {
            int n = this.rnd.nextInt();
            this.sink.clear();
            Numbers.append((CharSink)this.sink, (int)n);
            Assert.assertEquals((Object)Integer.toString(n), (Object)this.sink.toString());
        }
    }

    @Test
    public void testFormatLong() {
        for (int i = 0; i < 1000; ++i) {
            long n = this.rnd.nextLong();
            this.sink.clear();
            Numbers.append((CharSink)this.sink, (long)n);
            Assert.assertEquals((Object)Long.toString(n), (Object)this.sink.toString());
        }
    }

    @Test
    public void testFormatShort() {
        for (int i = 0; i < 1000; ++i) {
            short n = (short)this.rnd.nextInt();
            this.sink.clear();
            Numbers.append((CharSink)this.sink, (int)n);
            Assert.assertEquals((Object)Short.toString(n), (Object)this.sink.toString());
        }
    }

    @Test
    public void testFormatSpecialDouble() {
        double d = -1.040218505859375E10;
        Numbers.append((CharSink)this.sink, (double)d, (int)8);
        Assert.assertEquals((Object)Double.toString(d), (Object)this.sink.toString());
        this.sink.clear();
        d = -1.040218505859375E-10;
        Numbers.append((CharSink)this.sink, (double)d, (int)18);
        Assert.assertEquals((Object)Double.toString(d), (Object)this.sink.toString());
    }

    @Test
    public void testHexInt() throws Exception {
        Assert.assertEquals((long)119L, (long)((char)Numbers.parseHexInt((CharSequence)"77")));
        Assert.assertEquals((long)240L, (long)Numbers.parseHexInt((CharSequence)"F0"));
        Assert.assertEquals((long)172L, (long)Numbers.parseHexInt((CharSequence)"ac"));
    }

    @Test
    public void testIntEdge() throws Exception {
        Numbers.append((CharSink)this.sink, (int)Integer.MAX_VALUE);
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)Numbers.parseInt((CharSequence)this.sink));
        this.sink.clear();
        Numbers.append((CharSink)this.sink, (int)Integer.MIN_VALUE);
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)Numbers.parseIntQuiet((CharSequence)this.sink));
    }

    @Test
    public void testLong() throws Exception {
        Rnd rnd = new Rnd();
        StringSink sink = new StringSink();
        for (int i = 0; i < 100; ++i) {
            long l1 = rnd.nextLong();
            long l2 = rnd.nextLong();
            sink.clear();
            Numbers.append((CharSink)sink, (long)l1);
            int p = sink.length();
            Numbers.append((CharSink)sink, (long)l2);
            Assert.assertEquals((long)l1, (long)Numbers.parseLong((CharSequence)sink, (int)0, (int)p));
            Assert.assertEquals((long)l2, (long)Numbers.parseLong((CharSequence)sink, (int)p, (int)sink.length()));
        }
    }

    @Test
    public void testLongEdge() throws Exception {
        Numbers.append((CharSink)this.sink, (long)Long.MAX_VALUE);
        Assert.assertEquals((long)Long.MAX_VALUE, (long)Numbers.parseLong((CharSequence)this.sink));
        this.sink.clear();
        Numbers.append((CharSink)this.sink, (long)Long.MIN_VALUE);
        Assert.assertEquals((long)Long.MIN_VALUE, (long)Numbers.parseLongQuiet((CharSequence)this.sink));
    }

    @Test
    public void testLongToString() {
        Numbers.append((CharSink)this.sink, (long)6103390276L);
        TestUtils.assertEquals((CharSequence)"6103390276", (CharSequence)this.sink);
    }

    @Test
    public void testParseDouble() throws Exception {
        String s9 = "0.33458980809808359835083490580348503845E203";
        Assert.assertEquals((double)Double.parseDouble(s9), (double)Numbers.parseDouble((CharSequence)s9), (double)1.0E-9);
        String s0 = "0.33458980809808359835083490580348503845";
        Assert.assertEquals((double)Double.parseDouble(s0), (double)Numbers.parseDouble((CharSequence)s0), (double)1.0E-9);
        String s1 = "0.45677888912387699";
        Assert.assertEquals((double)Double.parseDouble(s1), (double)Numbers.parseDouble((CharSequence)s1), (double)1.0E-9);
        String s2 = "1.459983E35";
        Assert.assertEquals((double)(Double.parseDouble(s2) / 1.0E35), (double)(Numbers.parseDouble((CharSequence)s2) / 1.0E35), (double)1.0E-5);
        String s3 = "0.000000023E-30";
        Assert.assertEquals((double)Double.parseDouble(s3), (double)Numbers.parseDouble((CharSequence)s3), (double)1.0E-9);
        String s4 = "0.000000023E-204";
        Assert.assertEquals((double)Double.parseDouble(s4), (double)Numbers.parseDouble((CharSequence)s4), (double)1.0E-9);
        String s5 = "0.0000E-204";
        Assert.assertEquals((double)Double.parseDouble(s5), (double)Numbers.parseDouble((CharSequence)s5), (double)1.0E-9);
        String s6 = "200E2";
        Assert.assertEquals((double)Double.parseDouble(s6), (double)Numbers.parseDouble((CharSequence)s6), (double)1.0E-9);
        String s7 = "NaN";
        Assert.assertEquals((double)Double.parseDouble(s7), (double)Numbers.parseDouble((CharSequence)s7), (double)1.0E-9);
        String s8 = "-Infinity";
        Assert.assertEquals((double)Double.parseDouble(s8), (double)Numbers.parseDouble((CharSequence)s8), (double)1.0E-9);
    }

    @Test
    public void testParseExplicitDouble() throws Exception {
        Assert.assertEquals((double)1234.123, (double)Numbers.parseDouble((CharSequence)"1234.123d"), (double)1.0E-6);
    }

    @Test
    public void testParseExplicitFloat() throws Exception {
        Assert.assertEquals((float)12345.02f, (float)Numbers.parseFloat((CharSequence)"12345.02f"), (float)1.0E-4f);
    }

    @Test(expected=NumericException.class)
    public void testParseExplicitFloat2() throws Exception {
        Numbers.parseFloat((CharSequence)"12345.02fx");
    }

    @Test
    public void testParseFloat() throws Exception {
        String s1 = "0.45677899234";
        Assert.assertEquals((double)Float.parseFloat(s1), (double)Numbers.parseFloat((CharSequence)s1), (double)1.0E-9);
        String s2 = "1.459983E35";
        Assert.assertEquals((double)((double)Float.parseFloat(s2) / 1.0E35), (double)((double)Numbers.parseFloat((CharSequence)s2) / 1.0E35), (double)1.0E-5);
        String s3 = "0.000000023E-30";
        Assert.assertEquals((double)Float.parseFloat(s3), (double)Numbers.parseFloat((CharSequence)s3), (double)1.0E-9);
        String s4 = "0.000000023E-38";
        Assert.assertEquals((double)Float.parseFloat(s4), (double)Numbers.parseFloat((CharSequence)s4), (double)1.0E-9);
        String s5 = "0.0000E-204";
        Assert.assertEquals((double)Float.parseFloat(s5), (double)Numbers.parseFloat((CharSequence)s5), (double)1.0E-9);
        String s6 = "200E2";
        Assert.assertEquals((double)Float.parseFloat(s6), (double)Numbers.parseFloat((CharSequence)s6), (double)1.0E-9);
        String s7 = "NaN";
        Assert.assertEquals((double)Float.parseFloat(s7), (double)Numbers.parseFloat((CharSequence)s7), (double)1.0E-9);
        String s8 = "-Infinity";
        Assert.assertEquals((double)Float.parseFloat(s8), (double)Numbers.parseFloat((CharSequence)s8), (double)1.0E-9);
    }

    @Test
    public void testParseInt() throws Exception {
        Assert.assertEquals((long)567963L, (long)Numbers.parseInt((CharSequence)"567963"));
        Assert.assertEquals((long)-23346346L, (long)Numbers.parseInt((CharSequence)"-23346346"));
    }

    @Test(expected=NumericException.class)
    public void testParseIntEmpty() throws Exception {
        Numbers.parseInt((CharSequence)"");
    }

    @Test(expected=NumericException.class)
    public void testParseIntNull() throws Exception {
        Numbers.parseInt(null);
    }

    @Test(expected=NumericException.class)
    public void testParseIntOverflow1() throws Exception {
        String i1 = "12345566787";
        Numbers.parseInt((CharSequence)i1);
    }

    @Test(expected=NumericException.class)
    public void testParseIntOverflow2() throws Exception {
        Numbers.parseInt((CharSequence)"2147483648");
    }

    @Test(expected=NumericException.class)
    public void testParseIntSignOnly() throws Exception {
        Numbers.parseInt((CharSequence)"-");
    }

    @Test
    public void testParseIntToDelim() throws Exception {
        String in = "1234x5";
        long val = Numbers.parseIntSafely((CharSequence)in, (int)0, (int)in.length());
        Assert.assertEquals((long)1234L, (long)Numbers.decodeLowInt((long)val));
        Assert.assertEquals((long)4L, (long)Numbers.decodeHighInt((long)val));
    }

    @Test(expected=NumericException.class)
    public void testParseIntToDelimEmpty() throws Exception {
        String in = "x";
        Numbers.parseIntSafely((CharSequence)in, (int)0, (int)in.length());
    }

    @Test
    public void testParseIntToDelimNoChar() throws Exception {
        String in = "12345";
        long val = Numbers.parseIntSafely((CharSequence)in, (int)0, (int)in.length());
        Assert.assertEquals((long)12345L, (long)Numbers.decodeLowInt((long)val));
        Assert.assertEquals((long)5L, (long)Numbers.decodeHighInt((long)val));
    }

    @Test(expected=NumericException.class)
    public void testParseIntWrongChars() throws Exception {
        Numbers.parseInt((CharSequence)"123ab");
    }

    @Test(expected=NumericException.class)
    public void testParseLongEmpty() throws Exception {
        Numbers.parseLong((CharSequence)"");
    }

    @Test(expected=NumericException.class)
    public void testParseLongNull() throws Exception {
        Numbers.parseLong(null);
    }

    @Test(expected=NumericException.class)
    public void testParseLongNull2() throws Exception {
        Numbers.parseLong(null, (int)0, (int)10);
    }

    @Test(expected=NumericException.class)
    public void testParseLongOverflow1() throws Exception {
        String i1 = "1234556678723234234234234234234";
        Numbers.parseLong((CharSequence)i1);
    }

    @Test(expected=NumericException.class)
    public void testParseLongOverflow2() throws Exception {
        Numbers.parseLong((CharSequence)"9223372036854775808");
    }

    @Test(expected=NumericException.class)
    public void testParseLongSignOnly() throws Exception {
        Numbers.parseLong((CharSequence)"-");
    }

    @Test(expected=NumericException.class)
    public void testParseLongWrongChars() throws Exception {
        Numbers.parseLong((CharSequence)"123ab");
    }

    @Test(expected=NumericException.class)
    public void testParseSizeFail() throws Exception {
        Numbers.parseIntSize((CharSequence)"5Kb");
    }

    @Test
    public void testParseSizeKb() throws Exception {
        Assert.assertEquals((long)5120L, (long)Numbers.parseIntSize((CharSequence)"5K"));
        Assert.assertEquals((long)5120L, (long)Numbers.parseIntSize((CharSequence)"5k"));
    }

    @Test
    public void testParseSizeMb() throws Exception {
        Assert.assertEquals((long)0x500000L, (long)Numbers.parseIntSize((CharSequence)"5M"));
        Assert.assertEquals((long)0x500000L, (long)Numbers.parseIntSize((CharSequence)"5m"));
    }

    @Test(expected=NumericException.class)
    public void testParseWrongHexInt() throws Exception {
        Numbers.parseHexInt((CharSequence)"0N");
    }

    @Test(expected=NumericException.class)
    public void testParseWrongNan() throws Exception {
        Numbers.parseDouble((CharSequence)"NaN1");
    }

    @Test
    public void testRoundDown() throws Exception {
        Rnd rnd = new Rnd();
        for (int i = 0; i < 1000; ++i) {
            double d = rnd.nextDouble2();
            double n = Numbers.roundDown((double)d, (int)8);
            Assert.assertTrue((String)(d + " " + n + " " + (d - n - 1.0E-8)), (d - n - 1.0E-8 < 1.0E-10 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testRoundHalfDown() throws Exception {
        Assert.assertEquals((double)-1.235, (double)Numbers.roundHalfDown((double)-1.2346, (int)3), (double)1.0E-10);
        Assert.assertEquals((double)-1.23489, (double)Numbers.roundHalfDown((double)-1.234895, (int)5), (double)1.0E-10);
        Assert.assertEquals((double)1.23489, (double)Numbers.roundHalfDown((double)1.234895, (int)5), (double)1.0E-10);
    }

    @Test
    public void testRoundHalfEven() throws Exception {
        Assert.assertEquals((double)-1.235, (double)Numbers.roundHalfEven((double)-1.2346, (int)3), (double)1.0E-10);
        Assert.assertEquals((double)-1.2349, (double)Numbers.roundHalfEven((double)-1.234899, (int)5), (double)1.0E-10);
        Assert.assertEquals((double)1.2349, (double)Numbers.roundHalfEven((double)1.234899, (int)5), (double)1.0E-10);
        Assert.assertEquals((double)1.2349, (double)Numbers.roundHalfEven((double)1.2348995, (int)6), (double)1.0E-10);
        Assert.assertEquals((double)-1.2349, (double)Numbers.roundHalfEven((double)-1.234895, (int)5), (double)1.0E-10);
        Assert.assertEquals((double)1.2349, (double)Numbers.roundHalfEven((double)1.234895, (int)5), (double)1.0E-10);
        Assert.assertEquals((double)1.0008, (double)Numbers.roundHalfEven((double)1.00075, (int)4), (double)1.0E-10);
        Assert.assertEquals((double)1.0008, (double)Numbers.roundHalfEven((double)1.00085, (int)4), (double)1.0E-10);
    }

    @Test
    public void testRoundHalfUp() throws Exception {
        Assert.assertEquals((double)-1.235, (double)Numbers.roundHalfUp((double)-1.2346, (int)3), (double)1.0E-10);
        Assert.assertEquals((double)-1.2349, (double)Numbers.roundHalfUp((double)-1.234899, (int)5), (double)1.0E-10);
        Assert.assertEquals((double)1.2349, (double)Numbers.roundHalfUp((double)1.234895, (int)5), (double)1.0E-10);
        Assert.assertEquals((double)1.0009, (double)Numbers.roundHalfUp((double)1.00091, (int)4), (double)1.0E-10);
        Assert.assertEquals((double)-1.0009, (double)Numbers.roundHalfUp((double)-1.00091, (int)4), (double)1.0E-10);
    }

    @Test
    public void testRoundUp() throws Exception {
        Assert.assertEquals((double)-0.2345678098023, (double)Numbers.roundUp((double)-0.23456780980224246, (int)13), (double)1.0E-14);
        Assert.assertEquals((double)0.2345678098023, (double)Numbers.roundUp((double)0.23456780980224246, (int)13), (double)1.0E-14);
        Rnd rnd = new Rnd();
        for (int i = 0; i < 1000; ++i) {
            double d = rnd.nextDouble2();
            double n = Numbers.roundUp((double)d, (int)8);
            Assert.assertTrue((String)(d + " " + n + " " + (n - d - 1.0E-8)), (n - d - 1.0E-8 < 1.0E-10 ? 1 : 0) != 0);
        }
    }
}

