/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.misc;

import com.questdb.std.Chars;
import com.questdb.std.ObjList;
import com.questdb.std.Unsafe;
import com.questdb.std.str.CharSink;
import com.questdb.std.str.ConcatCharSequence;
import com.questdb.std.str.FileNameExtractorCharSequence;
import com.questdb.std.str.Path;
import com.questdb.std.str.StringSink;
import com.questdb.test.tools.TestUtils;
import java.nio.charset.StandardCharsets;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class CharsTest {
    private static final FileNameExtractorCharSequence extractor = new FileNameExtractorCharSequence();
    private static char separator;

    @BeforeClass
    public static void setUp() {
        separator = System.getProperty("file.separator").charAt(0);
    }

    @Test
    public void testConcat() {
        ConcatCharSequence concat = new ConcatCharSequence();
        concat.add((CharSequence)"this");
        concat.add((CharSequence)" is ");
        concat.add((CharSequence)"");
        concat.add((CharSequence)"working");
        TestUtils.assertEquals((CharSequence)"this is working", (CharSequence)concat);
        Assert.assertEquals((long)119L, (long)concat.charAt(8));
    }

    @Test
    public void testEmptyString() {
        TestUtils.assertEquals((CharSequence)"", extractor.of((CharSequence)""));
    }

    @Test
    public void testEndsWith() {
        Assert.assertFalse((boolean)Chars.endsWith(null, null));
        Assert.assertFalse((boolean)Chars.endsWith((CharSequence)"a", null));
        Assert.assertFalse((boolean)Chars.endsWith(null, (CharSequence)"a"));
        Assert.assertFalse((boolean)Chars.endsWith((CharSequence)"", (CharSequence)"a"));
        Assert.assertFalse((boolean)Chars.endsWith((CharSequence)"a", (CharSequence)""));
        Assert.assertFalse((boolean)Chars.endsWith((CharSequence)"ab", (CharSequence)"abc"));
        Assert.assertFalse((boolean)Chars.endsWith((CharSequence)"abc", (CharSequence)"x"));
        Assert.assertTrue((boolean)Chars.endsWith((CharSequence)"abcd", (CharSequence)"cd"));
    }

    @Test
    public void testNameFromPath() {
        StringBuilder name = new StringBuilder();
        name.append(separator).append("xyz").append(separator).append("dir1").append(separator).append("dir2").append(separator).append("this is my name");
        TestUtils.assertEquals((CharSequence)"this is my name", extractor.of((CharSequence)name));
    }

    @Test
    public void testPathList() {
        this.assertThat("[abc,d1]", (ObjList<Path>)Chars.splitLpsz((CharSequence)"abc d1"));
    }

    @Test
    public void testPathListLeadingSpaces() {
        this.assertThat("[abc,d1]", (ObjList<Path>)Chars.splitLpsz((CharSequence)"   abc d1"));
    }

    @Test
    public void testPathListQuotedSpace() {
        this.assertThat("[abc,d1 cd,x]", (ObjList<Path>)Chars.splitLpsz((CharSequence)"abc \"d1 cd\" x"));
    }

    @Test
    public void testPathListQuotedSpaceEmpty() {
        this.assertThat("[abc,x]", (ObjList<Path>)Chars.splitLpsz((CharSequence)"abc \"\" x"));
    }

    @Test
    public void testPathListTrailingSpace() {
        this.assertThat("[abc,d1]", (ObjList<Path>)Chars.splitLpsz((CharSequence)"abc d1    "));
    }

    @Test
    public void testPathListUnclosedQuote() {
        this.assertThat("[abc,c cd]", (ObjList<Path>)Chars.splitLpsz((CharSequence)"abc \"c cd"));
    }

    @Test
    public void testPlainName() {
        TestUtils.assertEquals((CharSequence)"xyz.txt", extractor.of((CharSequence)"xyz.txt"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUtf8Support() {
        StringBuilder expected = new StringBuilder();
        for (int i = 0; i < 55296; ++i) {
            expected.append((char)i);
        }
        String in = expected.toString();
        long p = Unsafe.malloc((long)524280L);
        try {
            byte[] bytes = in.getBytes(StandardCharsets.UTF_8);
            int n = bytes.length;
            for (int i = 0; i < n; ++i) {
                Unsafe.getUnsafe().putByte(p + (long)i, bytes[i]);
            }
            StringSink b = new StringSink();
            Chars.utf8Decode((long)p, (long)(p + (long)bytes.length), (CharSink)b);
            TestUtils.assertEquals((CharSequence)in, b.toString());
        }
        finally {
            Unsafe.free((long)p, (long)524280L);
        }
    }

    private void assertThat(String expected, ObjList<Path> list) {
        Assert.assertEquals((Object)expected, (Object)list.toString());
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            ((Path)list.getQuick(i)).close();
        }
    }
}

