/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.log;

import com.questdb.log.Log;
import com.questdb.log.LogConsoleWriter;
import com.questdb.log.LogError;
import com.questdb.log.LogFactory;
import com.questdb.log.LogFileWriter;
import com.questdb.log.LogRecord;
import com.questdb.log.LogWriterConfig;
import com.questdb.store.Files;
import com.questdb.test.tools.TestUtils;
import java.io.File;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class LogFactoryTest {
    @Rule
    public final TemporaryFolder temp = new TemporaryFolder();

    @Test(expected=LogError.class)
    public void testBadWriter() {
        System.setProperty("questdbLog", "/nfslog-bad-writer.conf");
        try (LogFactory factory = new LogFactory();){
            LogFactory.configureFromSystemProperties((LogFactory)factory);
        }
    }

    @Test
    public void testDefaultLevel() {
        try (LogFactory factory = new LogFactory();){
            factory.add(new LogWriterConfig(7, LogConsoleWriter::new));
            factory.bind();
            Log logger = factory.create((CharSequence)"x");
            LogFactoryTest.assertEnabled(logger.info());
            LogFactoryTest.assertEnabled(logger.error());
            LogFactoryTest.assertEnabled(logger.debug());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiplexing() throws Exception {
        File x = this.temp.newFile();
        File y = this.temp.newFile();
        try (LogFactory factory = new LogFactory();){
            factory.add(new LogWriterConfig(2, (ring, seq, level) -> {
                LogFileWriter w = new LogFileWriter(ring, seq, level);
                w.setLocation(x.getAbsolutePath());
                return w;
            }));
            factory.add(new LogWriterConfig(2, (ring, seq, level) -> {
                LogFileWriter w = new LogFileWriter(ring, seq, level);
                w.setLocation(y.getAbsolutePath());
                return w;
            }));
            factory.bind();
            factory.startThread();
            try {
                Log logger = factory.create((CharSequence)"x");
                for (int i = 0; i < 100000; ++i) {
                    logger.xinfo().$((CharSequence)"test ").$(' ').$(i).$();
                }
                Thread.sleep(100L);
                Assert.assertTrue((x.length() > 0L ? 1 : 0) != 0);
                TestUtils.assertEquals(x, y);
            }
            finally {
                factory.haltThread();
            }
        }
    }

    @Test
    public void testNoConfig() {
        System.setProperty("questdbLog", "/nfslog2.conf");
        try (LogFactory factory = new LogFactory();){
            LogFactory.configureFromSystemProperties((LogFactory)factory);
            Log logger = factory.create((CharSequence)"x");
            LogFactoryTest.assertDisabled(logger.debug());
            LogFactoryTest.assertEnabled(logger.info());
            LogFactoryTest.assertEnabled(logger.error());
        }
    }

    @Test
    public void testNoDefault() {
        System.setProperty("questdbLog", "/nfslog1.conf");
        try (LogFactory factory = new LogFactory();){
            LogFactory.configureFromSystemProperties((LogFactory)factory);
            Log logger = factory.create((CharSequence)"x");
            LogFactoryTest.assertDisabled(logger.debug());
            LogFactoryTest.assertDisabled(logger.info());
            LogFactoryTest.assertDisabled(logger.error());
            Log logger1 = factory.create((CharSequence)"com.questdb.x.y");
            LogFactoryTest.assertEnabled(logger1.debug());
            LogFactoryTest.assertDisabled(logger1.info());
            LogFactoryTest.assertEnabled(logger1.error());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOverlappedMultiplexing() throws Exception {
        File x = this.temp.newFile();
        File y = this.temp.newFile();
        try (LogFactory factory = new LogFactory();){
            factory.add(new LogWriterConfig(3, (ring, seq, level) -> {
                LogFileWriter w = new LogFileWriter(ring, seq, level);
                w.setLocation(x.getAbsolutePath());
                return w;
            }));
            factory.add(new LogWriterConfig(5, (ring, seq, level) -> {
                LogFileWriter w = new LogFileWriter(ring, seq, level);
                w.setLocation(y.getAbsolutePath());
                return w;
            }));
            factory.bind();
            factory.startThread();
            try {
                int i;
                Log logger = factory.create((CharSequence)"x");
                for (i = 0; i < 1000; ++i) {
                    logger.xerror().$((CharSequence)"test ").$(i).$();
                }
                Thread.sleep(100L);
                Assert.assertEquals((long)0L, (long)x.length());
                Assert.assertEquals((long)9890L, (long)y.length());
                for (i = 0; i < 1000; ++i) {
                    logger.xinfo().$((CharSequence)"test ").$(i).$();
                }
                Thread.sleep(100L);
                Assert.assertEquals((long)9890L, (long)x.length());
                Assert.assertEquals((long)9890L, (long)y.length());
            }
            finally {
                factory.haltThread();
            }
        }
    }

    @Test
    public void testPackageHierarchy() throws Exception {
        File a = this.temp.newFile();
        File b = this.temp.newFile();
        try (LogFactory factory = new LogFactory();){
            factory.add(new LogWriterConfig("com.questdb", 2, (ring, seq, level) -> {
                LogFileWriter w = new LogFileWriter(ring, seq, level);
                w.setLocation(a.getAbsolutePath());
                return w;
            }));
            factory.add(new LogWriterConfig("com.questdb.std", 2, (ring, seq, level) -> {
                LogFileWriter w = new LogFileWriter(ring, seq, level);
                w.setLocation(b.getAbsolutePath());
                return w;
            }));
            factory.bind();
            factory.startThread();
            Log logger = factory.create((CharSequence)"com.questdb.std.X");
            logger.xinfo().$((CharSequence)"this is for std").$();
            Log logger1 = factory.create((CharSequence)"com.questdb.net.Y");
            logger1.xinfo().$((CharSequence)"this is for network").$();
            Thread.sleep(100L);
            Assert.assertEquals((Object)"this is for network\r\n", (Object)Files.readStringFromFile((File)a));
            Assert.assertEquals((Object)"this is for std\r\n", (Object)Files.readStringFromFile((File)b));
        }
    }

    @Test
    public void testProgrammaticConfig() {
        try (LogFactory factory = new LogFactory();){
            factory.add(new LogWriterConfig(3, LogConsoleWriter::new));
            factory.bind();
            Log logger = factory.create((CharSequence)"x");
            LogFactoryTest.assertEnabled(logger.info());
            LogFactoryTest.assertDisabled(logger.error());
            LogFactoryTest.assertEnabled(logger.debug());
        }
    }

    @Test
    public void testSetProperties() throws Exception {
        File conf = this.temp.newFile();
        File out = this.temp.newFile();
        Files.writeStringToFile((File)conf, (String)("writers=file\nrecordLength=4096\nqueueDepth=1024\nw.file.class=com.questdb.log.LogFileWriter\nw.file.location=" + out.getAbsolutePath().replaceAll("\\\\", "/") + "\nw.file.level=INFO,ERROR\nw.file.bufferSize=4M"));
        System.setProperty("questdbLog", conf.getAbsolutePath());
        try (LogFactory factory = new LogFactory();){
            LogFactory.configureFromSystemProperties((LogFactory)factory);
            Log log = factory.create((CharSequence)"xyz");
            log.xinfo().$((CharSequence)"hello").$();
            Assert.assertEquals((long)1L, (long)factory.getJobs().size());
            Assert.assertTrue((boolean)(factory.getJobs().get(0) instanceof LogFileWriter));
            LogFileWriter w = (LogFileWriter)factory.getJobs().get(0);
            Assert.assertEquals((long)0x400000L, (long)w.getBufSize());
            Assert.assertEquals((long)1024L, (long)factory.getQueueDepth());
            Assert.assertEquals((long)4096L, (long)factory.getRecordLength());
        }
    }

    @Test
    public void testSilent() {
        System.setProperty("questdbLog", "/nfslog-silent.conf");
        try (LogFactory factory = new LogFactory();){
            LogFactory.configureFromSystemProperties((LogFactory)factory);
            Log logger = factory.create((CharSequence)"x");
            LogFactoryTest.assertDisabled(logger.debug());
            LogFactoryTest.assertDisabled(logger.info());
            LogFactoryTest.assertDisabled(logger.error());
            Log logger1 = factory.create((CharSequence)"com.questdb.x.y");
            LogFactoryTest.assertDisabled(logger1.debug());
            LogFactoryTest.assertDisabled(logger1.info());
            LogFactoryTest.assertDisabled(logger1.error());
        }
    }

    private static void assertEnabled(LogRecord r) {
        Assert.assertTrue((boolean)r.isEnabled());
        r.$();
    }

    private static void assertDisabled(LogRecord r) {
        Assert.assertFalse((boolean)r.isEnabled());
        r.$();
    }
}

