/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.griffin.model;

import com.questdb.griffin.GriffinParserTestUtils;
import com.questdb.griffin.SqlException;
import com.questdb.griffin.model.IntrinsicModel;
import com.questdb.std.LongList;
import com.questdb.std.microtime.DateFormatUtils;
import com.questdb.test.tools.TestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IntrinsicModelTest {
    private final LongList a = new LongList();
    private final LongList b = new LongList();
    private final LongList out = new LongList();

    @Before
    public void setUp() {
        this.a.clear();
        this.b.clear();
        this.out.clear();
    }

    @Test
    public void testIntersectContain2() throws Exception {
        this.a.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T10:00:00.000Z"));
        this.a.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T12:00:00.000Z"));
        this.b.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T09:00:00.000Z"));
        this.b.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T13:30:00.000Z"));
        this.assertIntersect("[{lo=2016-03-10T10:00:00.000000Z, hi=2016-03-10T12:00:00.000000Z}]");
    }

    @Test
    public void testIntersectMergeOverlap() throws Exception {
        this.a.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T10:00:00.000Z"));
        this.a.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T12:00:00.000Z"));
        this.b.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T11:00:00.000Z"));
        this.b.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T14:00:00.000Z"));
        this.assertIntersect("[{lo=2016-03-10T11:00:00.000000Z, hi=2016-03-10T12:00:00.000000Z}]");
    }

    @Test
    public void testIntersectMergeOverlap2() throws Exception {
        this.a.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T10:00:00.000Z"));
        this.a.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T12:00:00.000Z"));
        this.b.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T11:00:00.000Z"));
        this.b.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T14:00:00.000Z"));
        this.assertIntersect("[{lo=2016-03-10T11:00:00.000000Z, hi=2016-03-10T12:00:00.000000Z}]");
    }

    @Test
    public void testIntersectNoOverlap() throws Exception {
        this.a.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T10:00:00.000Z"));
        this.a.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T12:00:00.000Z"));
        this.a.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T14:00:00.000Z"));
        this.a.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T16:00:00.000Z"));
        this.b.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T13:00:00.000Z"));
        this.b.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T13:30:00.000Z"));
        this.assertIntersect("[]");
    }

    @Test
    public void testIntersectSame() throws Exception {
        this.a.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T10:00:00.000Z"));
        this.a.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T12:00:00.000Z"));
        this.b.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T10:00:00.000Z"));
        this.b.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T12:00:00.000Z"));
        this.assertIntersect("[{lo=2016-03-10T10:00:00.000000Z, hi=2016-03-10T12:00:00.000000Z}]");
    }

    @Test
    public void testIntersectTwoOverlapOne2() throws Exception {
        this.a.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T10:00:00.000Z"));
        this.a.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T12:00:00.000Z"));
        this.a.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T14:00:00.000Z"));
        this.a.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T16:00:00.000Z"));
        this.b.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T11:00:00.000Z"));
        this.b.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T15:00:00.000Z"));
        this.assertIntersect("[{lo=2016-03-10T11:00:00.000000Z, hi=2016-03-10T12:00:00.000000Z},{lo=2016-03-10T14:00:00.000000Z, hi=2016-03-10T15:00:00.000000Z}]");
    }

    @Test
    public void testInvert() throws SqlException {
        String intervalStr = "2018-01-10T10:30:00.000Z;30m;2d;2";
        LongList out = new LongList();
        IntrinsicModel.parseIntervalEx((CharSequence)"2018-01-10T10:30:00.000Z;30m;2d;2", (int)0, (int)"2018-01-10T10:30:00.000Z;30m;2d;2".length(), (int)0, (LongList)out);
        IntrinsicModel.invert((LongList)out);
        TestUtils.assertEquals((CharSequence)"[{lo=, hi=2018-01-10T10:29:59.999999Z},{lo=2018-01-10T11:00:00.000001Z, hi=2018-01-12T10:29:59.999999Z},{lo=2018-01-12T11:00:00.000001Z, hi=294247-01-10T04:00:54.775807Z}]", GriffinParserTestUtils.intervalToString(out));
    }

    @Test
    public void testParseLongInterval22() throws Exception {
        IntrinsicModelTest.assertShortInterval("[{lo=2015-03-12T10:00:00.000000Z, hi=2015-03-12T10:05:00.999999Z},{lo=2015-03-12T10:30:00.000000Z, hi=2015-03-12T10:35:00.999999Z},{lo=2015-03-12T11:00:00.000000Z, hi=2015-03-12T11:05:00.999999Z},{lo=2015-03-12T11:30:00.000000Z, hi=2015-03-12T11:35:00.999999Z},{lo=2015-03-12T12:00:00.000000Z, hi=2015-03-12T12:05:00.999999Z},{lo=2015-03-12T12:30:00.000000Z, hi=2015-03-12T12:35:00.999999Z},{lo=2015-03-12T13:00:00.000000Z, hi=2015-03-12T13:05:00.999999Z},{lo=2015-03-12T13:30:00.000000Z, hi=2015-03-12T13:35:00.999999Z},{lo=2015-03-12T14:00:00.000000Z, hi=2015-03-12T14:05:00.999999Z},{lo=2015-03-12T14:30:00.000000Z, hi=2015-03-12T14:35:00.999999Z}]", "2015-03-12T10:00:00;5m;30m;10");
    }

    @Test
    public void testParseLongInterval32() throws Exception {
        IntrinsicModelTest.assertShortInterval("[{lo=2016-03-21T00:00:00.000000Z, hi=2021-03-21T23:59:59.999999Z}]", "2016-03-21;3y;6M;5");
    }

    @Test
    public void testParseShortDayErr() {
        this.assertIntervalError("2016-02-30");
    }

    @Test
    public void testParseShortDayErr2() {
        this.assertIntervalError("2016-02-3");
    }

    @Test
    public void testParseShortHourErr1() {
        this.assertIntervalError("2016-02-15T1");
    }

    @Test
    public void testParseShortHourErr2() {
        this.assertIntervalError("2016-02-15T31");
    }

    @Test
    public void testParseShortHourErr3() {
        this.assertIntervalError("2016-02-15X1");
    }

    @Test
    public void testParseShortInterval1() throws Exception {
        IntrinsicModelTest.assertShortInterval("[{lo=2016-01-01T00:00:00.000000Z, hi=2016-12-31T23:59:59.999999Z}]", "2016");
    }

    @Test
    public void testParseShortInterval2() throws Exception {
        IntrinsicModelTest.assertShortInterval("[{lo=2016-03-01T00:00:00.000000Z, hi=2016-03-31T23:59:59.999999Z}]", "2016-03");
    }

    @Test
    public void testParseShortInterval3() throws Exception {
        IntrinsicModelTest.assertShortInterval("[{lo=2016-03-21T00:00:00.000000Z, hi=2016-03-21T23:59:59.999999Z}]", "2016-03-21");
    }

    @Test
    public void testParseShortInterval32() throws Exception {
        IntrinsicModelTest.assertShortInterval("[{lo=2016-03-21T00:00:00.000000Z, hi=2016-03-21T23:59:59.999999Z}]", "2016-03-21");
    }

    @Test
    public void testParseShortInterval4() throws Exception {
        IntrinsicModelTest.assertShortInterval("[{lo=2016-03-21T10:00:00.000000Z, hi=2016-03-21T10:59:59.999999Z}]", "2016-03-21T10");
    }

    @Test
    public void testParseShortInterval5() throws Exception {
        IntrinsicModelTest.assertShortInterval("[{lo=2016-03-21T10:30:00.000000Z, hi=2016-03-21T10:30:59.999999Z}]", "2016-03-21T10:30");
    }

    @Test
    public void testParseShortInterval6() throws Exception {
        IntrinsicModelTest.assertShortInterval("[{lo=2016-03-21T10:30:40.000000Z, hi=2016-03-21T10:30:40.999999Z}]", "2016-03-21T10:30:40");
    }

    @Test
    public void testParseShortInterval7() throws Exception {
        IntrinsicModelTest.assertShortInterval("[{lo=2016-03-21T10:30:40.100000Z, hi=2016-03-21T10:30:40.100000Z}]", "2016-03-21T10:30:40.100Z");
    }

    @Test
    public void testParseShortMilliErr() {
        this.assertIntervalError("2016-03-21T10:31:61.23");
    }

    @Test
    public void testParseShortMinErr() {
        this.assertIntervalError("2016-03-21T10:3");
    }

    @Test
    public void testParseShortMinErr2() {
        this.assertIntervalError("2016-03-21T10:69");
    }

    @Test
    public void testParseShortMonthErr() {
        this.assertIntervalError("2016-1");
    }

    @Test
    public void testParseShortMonthErr2() {
        this.assertIntervalError("2016x11");
    }

    @Test
    public void testParseShortMonthRange() {
        this.assertIntervalError("2016-66");
    }

    @Test
    public void testParseShortSecErr() {
        this.assertIntervalError("2016-03-21T10:31:61");
    }

    @Test
    public void testParseShortSecErr1() {
        this.assertIntervalError("2016-03-21T10:31:1");
    }

    @Test
    public void testParseShortYearErr() {
        this.assertIntervalError("201");
    }

    private static void assertShortInterval(String expected, String interval) throws SqlException {
        LongList out = new LongList();
        IntrinsicModel.parseIntervalEx((CharSequence)interval, (int)0, (int)interval.length(), (int)0, (LongList)out);
        TestUtils.assertEquals((CharSequence)expected, GriffinParserTestUtils.intervalToString(out));
    }

    private void assertIntersect(String expected) {
        IntrinsicModel.intersect((LongList)this.a, (LongList)this.b, (LongList)this.out);
        TestUtils.assertEquals((CharSequence)expected, GriffinParserTestUtils.intervalToString(this.out));
    }

    private void assertIntervalError(String interval) {
        try {
            IntrinsicModel.parseIntervalEx((CharSequence)interval, (int)0, (int)interval.length(), (int)0, (LongList)this.out);
            Assert.fail();
        }
        catch (SqlException sqlException) {
            // empty catch block
        }
    }
}

