/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.griffin.engine.table;

import com.questdb.cairo.AbstractCairoTest;
import com.questdb.cairo.CairoTestUtils;
import com.questdb.cairo.Engine;
import com.questdb.cairo.FullFwdDataFrameCursorFactory;
import com.questdb.cairo.GenericRecordMetadata;
import com.questdb.cairo.TableModel;
import com.questdb.cairo.TableReader;
import com.questdb.cairo.TableWriter;
import com.questdb.cairo.sql.CairoEngine;
import com.questdb.cairo.sql.DataFrameCursorFactory;
import com.questdb.cairo.sql.Record;
import com.questdb.cairo.sql.RecordCursor;
import com.questdb.cairo.sql.RecordMetadata;
import com.questdb.cairo.sql.RowCursorFactory;
import com.questdb.griffin.engine.functions.bind.BindVariableService;
import com.questdb.griffin.engine.table.DataFrameRecordCursorFactory;
import com.questdb.griffin.engine.table.SymbolIndexRowCursorFactory;
import com.questdb.std.Rnd;
import com.questdb.test.tools.TestUtils;
import org.junit.Test;

public class DataFrameRecordCursorFactoryTest
extends AbstractCairoTest {
    @Test
    public void testFactory() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            int N = 100;
            try (TableModel model = new TableModel(configuration, "x", 0).col("a", 7).col("b", 8).indexed(true, 25).col("i", 3).col("c", 8).indexed(true, 25).timestamp();){
                CairoTestUtils.create(model);
            }
            Rnd rnd = new Rnd();
            String[] symbols = new String[100];
            int M = 1000;
            long increment = 240000000L;
            for (int i = 0; i < 100; ++i) {
                symbols[i] = rnd.nextChars(8).toString();
            }
            rnd.reset();
            long timestamp = 0L;
            try (TableWriter writer = new TableWriter(configuration, (CharSequence)"x");){
                for (int i = 0; i < 1000; ++i) {
                    TableWriter.Row row = writer.newRow(timestamp += 240000000L);
                    row.putStr(0, rnd.nextChars(20));
                    row.putSym(1, (CharSequence)symbols[rnd.nextPositiveInt() % 100]);
                    row.putInt(2, rnd.nextInt());
                    row.putSym(3, (CharSequence)symbols[rnd.nextPositiveInt() % 100]);
                    row.append();
                }
                writer.commit();
            }
            var9_12 = null;
            try (Engine engine = new Engine(configuration);){
                GenericRecordMetadata metadata;
                int symbolKey;
                int columnIndex;
                String value = symbols[90];
                try (TableReader reader = engine.getReader((CharSequence)"x", -1L);){
                    columnIndex = reader.getMetadata().getColumnIndexQuiet((CharSequence)"b");
                    symbolKey = reader.getSymbolMapReader(columnIndex).getQuick((CharSequence)value);
                    metadata = GenericRecordMetadata.copyOf((RecordMetadata)reader.getMetadata());
                }
                SymbolIndexRowCursorFactory symbolIndexRowCursorFactory = new SymbolIndexRowCursorFactory(columnIndex, symbolKey, true);
                FullFwdDataFrameCursorFactory dataFrameFactory = new FullFwdDataFrameCursorFactory((CairoEngine)engine, "x", -1L);
                DataFrameRecordCursorFactory factory = new DataFrameRecordCursorFactory((RecordMetadata)metadata, (DataFrameCursorFactory)dataFrameFactory, (RowCursorFactory)symbolIndexRowCursorFactory, null);
                BindVariableService bindVariableService = new BindVariableService();
                try (RecordCursor cursor = factory.getCursor(bindVariableService);){
                    Record record = cursor.getRecord();
                    while (cursor.hasNext()) {
                        TestUtils.assertEquals((CharSequence)value, record.getSym(1));
                    }
                }
            }
            catch (Throwable throwable) {
                var9_12 = throwable;
                throw throwable;
            }
        });
    }
}

