/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.griffin.engine.join;

import com.questdb.griffin.engine.join.LongChain;
import com.questdb.std.LongList;
import com.questdb.std.ObjList;
import com.questdb.std.Rnd;
import com.questdb.test.tools.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class LongChainTest {
    @Test
    public void testAll() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try (LongChain chain = new LongChain(0x100000L);){
                int i;
                int N = 1000;
                int nChains = 10;
                Rnd rnd = new Rnd();
                LongList heads = new LongList(10);
                ObjList expectedValues = new ObjList();
                for (i = 0; i < 10; ++i) {
                    LongList expected = new LongList(1000);
                    heads.add(this.populateChain(chain, rnd, expected));
                    expectedValues.add((Object)expected);
                    Assert.assertEquals((long)1000L, (long)expected.size());
                }
                Assert.assertEquals((long)10L, (long)expectedValues.size());
                for (i = 0; i < 10; ++i) {
                    LongChain.TreeCursor cursor = chain.getCursor(heads.getQuick(i));
                    LongList expected = (LongList)expectedValues.get(i);
                    int count = 0;
                    while (cursor.hasNext()) {
                        Assert.assertEquals((long)expected.getQuick(count), (long)cursor.next());
                        ++count;
                    }
                    Assert.assertEquals((long)1000L, (long)count);
                }
            }
        });
    }

    private long populateChain(LongChain chain, Rnd rnd, LongList expectedValues) {
        long head = -1L;
        long tail = -1L;
        for (int i = 0; i < 1000; ++i) {
            long expected = rnd.nextLong();
            tail = chain.put(expected, tail);
            expectedValues.add(expected);
            if (i != 0) continue;
            head = tail;
        }
        return head;
    }
}

