/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.griffin.engine.join;

import com.questdb.cairo.AbstractCairoTest;
import com.questdb.cairo.ColumnType;
import com.questdb.griffin.engine.join.JoinRecordMetadata;
import com.questdb.std.str.StringSink;
import com.questdb.test.tools.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class JoinRecordMetadataTest
extends AbstractCairoTest {
    @Test
    public void testSimple() {
        JoinRecordMetadata metadata = new JoinRecordMetadata(configuration, 10);
        metadata.add((CharSequence)"a", (CharSequence)"x", 3);
        metadata.add((CharSequence)"a", (CharSequence)"y", 6);
        metadata.add((CharSequence)"a", (CharSequence)"m", 6);
        metadata.add((CharSequence)"b", (CharSequence)"x", 6);
        metadata.add((CharSequence)"b", (CharSequence)"y", 9);
        metadata.add((CharSequence)"b", (CharSequence)"z", 5);
        try {
            metadata.add((CharSequence)"b", (CharSequence)"y", 5);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        metadata.add(null, (CharSequence)"c.x", 7);
        Assert.assertEquals((long)-1L, (long)metadata.getColumnIndexQuiet((CharSequence)"x"));
        Assert.assertEquals((long)0L, (long)metadata.getColumnIndexQuiet((CharSequence)"a.x"));
        Assert.assertEquals((long)1L, (long)metadata.getColumnIndexQuiet((CharSequence)"a.y"));
        Assert.assertEquals((long)2L, (long)metadata.getColumnIndexQuiet((CharSequence)"m"));
        Assert.assertEquals((long)3L, (long)metadata.getColumnIndexQuiet((CharSequence)"b.x"));
        Assert.assertEquals((long)4L, (long)metadata.getColumnIndexQuiet((CharSequence)"b.y"));
        Assert.assertEquals((long)5L, (long)metadata.getColumnIndexQuiet((CharSequence)"b.z"));
        Assert.assertEquals((long)5L, (long)metadata.getColumnIndexQuiet((CharSequence)"z"));
        Assert.assertEquals((long)-1L, (long)metadata.getColumnIndexQuiet((CharSequence)"b.k"));
        metadata.add(null, (CharSequence)"z.m", 7);
        Assert.assertEquals((long)-1L, (long)metadata.getColumnIndexQuiet((CharSequence)"m"));
        Assert.assertEquals((long)9L, (long)metadata.getColumnType((CharSequence)"b.y"));
        Assert.assertEquals((long)3L, (long)metadata.getColumnType((CharSequence)"a.x"));
        String expected = "a.x:INT\na.y:DOUBLE\na.m:DOUBLE\nb.x:DOUBLE\nb.y:BINARY\nb.z:FLOAT\nc.x:STRING\nz.m:STRING\n";
        StringSink sink = new StringSink();
        int n = metadata.getColumnCount();
        for (int i = 0; i < n; ++i) {
            sink.put(metadata.getColumnName(i));
            sink.put(':');
            sink.put((CharSequence)ColumnType.nameOf((int)metadata.getColumnType(i)));
            sink.put('\n');
        }
        TestUtils.assertEquals((CharSequence)expected, (CharSequence)sink);
    }
}

