/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.griffin.engine.groupby;

import com.questdb.griffin.engine.groupby.YearTimestampSampler;
import com.questdb.std.NumericException;
import com.questdb.std.microtime.DateFormatUtils;
import com.questdb.std.str.StringSink;
import com.questdb.test.tools.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class YearTimestampSamplerTest {
    @Test
    public void testSimple() throws NumericException {
        StringSink sink = new StringSink();
        YearTimestampSampler sampler = new YearTimestampSampler(4);
        long timestamp = DateFormatUtils.parseTimestamp((CharSequence)"2018-11-16T15:00:00.000000Z");
        for (int i = 0; i < 20; ++i) {
            long ts = sampler.nextTimestamp(timestamp);
            sink.putISODate(ts).put('\n');
            Assert.assertEquals((long)timestamp, (long)sampler.previousTimestamp(ts));
            timestamp = ts;
        }
        TestUtils.assertEquals((CharSequence)"2022-11-16T15:00:00.000000Z\n2026-11-16T15:00:00.000000Z\n2030-11-16T15:00:00.000000Z\n2034-11-16T15:00:00.000000Z\n2038-11-16T15:00:00.000000Z\n2042-11-16T15:00:00.000000Z\n2046-11-16T15:00:00.000000Z\n2050-11-16T15:00:00.000000Z\n2054-11-16T15:00:00.000000Z\n2058-11-16T15:00:00.000000Z\n2062-11-16T15:00:00.000000Z\n2066-11-16T15:00:00.000000Z\n2070-11-16T15:00:00.000000Z\n2074-11-16T15:00:00.000000Z\n2078-11-16T15:00:00.000000Z\n2082-11-16T15:00:00.000000Z\n2086-11-16T15:00:00.000000Z\n2090-11-16T15:00:00.000000Z\n2094-11-16T15:00:00.000000Z\n2098-11-16T15:00:00.000000Z\n", (CharSequence)sink);
    }
}

