/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.griffin.engine.groupby;

import com.questdb.griffin.SqlException;
import com.questdb.griffin.engine.groupby.TimestampSampler;
import com.questdb.griffin.engine.groupby.TimestampSamplerFactory;
import com.questdb.std.NumericException;
import com.questdb.std.microtime.DateFormatUtils;
import com.questdb.std.microtime.Dates;
import com.questdb.std.str.StringSink;
import com.questdb.test.tools.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class TimestampSamplerFactoryTest {
    @Test
    public void testLongQualifier() {
        try {
            TimestampSamplerFactory.getInstance((CharSequence)"1sa", (int)130);
            Assert.fail();
        }
        catch (SqlException e) {
            Assert.assertEquals((long)131L, (long)e.getPosition());
            TestUtils.assertContains(e.getMessage(), "expected single letter qualifier");
        }
    }

    @Test
    public void testMinutes() throws NumericException, SqlException {
        StringSink sink = new StringSink();
        for (int k = 0; k < 61; ++k) {
            sink.clear();
            if (k > 0) {
                sink.put(k).put('m');
            } else {
                sink.put('m');
            }
            TimestampSampler sampler = TimestampSamplerFactory.getInstance((CharSequence)sink, (int)120);
            Assert.assertNotNull((Object)sampler);
            long n = 60000000L * (long)(k == 0 ? 1 : k);
            long timestamp = DateFormatUtils.parseTimestamp((CharSequence)"2018-04-15T10:23:00.000000Z");
            timestamp -= timestamp % n;
            for (int i = 0; i < 60; ++i) {
                long actual = sampler.round(timestamp + (long)i * 1000000L);
                if (timestamp == actual) continue;
                Assert.fail((String)("Failed at: " + sink + ". Expected: " + Dates.toString((long)timestamp) + ", actual: " + Dates.toString((long)actual)));
            }
        }
    }

    @Test
    public void testMissingInterval() {
        this.assertFailure(92, "missing interval", null, 92);
    }

    @Test
    public void testNoQualifier() {
        this.assertFailure(100, "expected interval qualifier", "45", 98);
    }

    @Test
    public void testSeconds() throws NumericException, SqlException {
        StringSink sink = new StringSink();
        for (int k = 0; k < 61; ++k) {
            sink.clear();
            if (k > 0) {
                sink.put(k).put('s');
            } else {
                sink.put('s');
            }
            TimestampSampler sampler = TimestampSamplerFactory.getInstance((CharSequence)sink, (int)120);
            Assert.assertNotNull((Object)sampler);
            long n = 1000000L * (long)(k == 0 ? 1 : k);
            long timestamp = DateFormatUtils.parseTimestamp((CharSequence)"2018-04-15T10:23:00.000000Z");
            timestamp -= timestamp % n;
            int i = 0;
            while ((long)i < n) {
                long actual = sampler.round(timestamp + (long)i);
                if (timestamp != actual) {
                    Assert.fail((String)("Failed at: " + sink + ". Expected: " + Dates.toString((long)timestamp) + ", actual: " + Dates.toString((long)actual)));
                }
                i += 4;
            }
        }
    }

    @Test
    public void testSecondsZero() {
        this.assertFailure(120, "zero is not a valid sample value", "0s", 120);
    }

    @Test
    public void testUnsupportedQualifier() {
        this.assertFailure(130, "unsupported interval qualifier", "K", 130);
    }

    @Test
    public void testUnsupportedQualifier2() {
        this.assertFailure(132, "unsupported interval qualifier", "21K", 130);
    }

    private void assertFailure(int expectedPosition, CharSequence expectedMessage, CharSequence sampleBy, int position) {
        try {
            TimestampSamplerFactory.getInstance((CharSequence)sampleBy, (int)position);
            Assert.fail();
        }
        catch (SqlException e) {
            Assert.assertEquals((long)expectedPosition, (long)e.getPosition());
            TestUtils.assertContains(e.getMessage(), expectedMessage);
        }
    }
}

