/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.griffin.engine.groupby;

import com.questdb.griffin.engine.groupby.MonthTimestampSampler;
import com.questdb.std.NumericException;
import com.questdb.std.microtime.DateFormatUtils;
import com.questdb.std.str.StringSink;
import com.questdb.test.tools.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class MonthTimestampSamplerTest {
    @Test
    public void testSimple() throws NumericException {
        StringSink sink = new StringSink();
        MonthTimestampSampler sampler = new MonthTimestampSampler(6);
        long timestamp = DateFormatUtils.parseTimestamp((CharSequence)"2018-11-16T15:00:00.000000Z");
        for (int i = 0; i < 20; ++i) {
            long ts = sampler.nextTimestamp(timestamp);
            sink.putISODate(ts).put('\n');
            Assert.assertEquals((long)timestamp, (long)sampler.previousTimestamp(ts));
            timestamp = ts;
        }
        TestUtils.assertEquals((CharSequence)"2019-05-16T15:00:00.000000Z\n2019-11-16T15:00:00.000000Z\n2020-05-16T15:00:00.000000Z\n2020-11-16T15:00:00.000000Z\n2021-05-16T15:00:00.000000Z\n2021-11-16T15:00:00.000000Z\n2022-05-16T15:00:00.000000Z\n2022-11-16T15:00:00.000000Z\n2023-05-16T15:00:00.000000Z\n2023-11-16T15:00:00.000000Z\n2024-05-16T15:00:00.000000Z\n2024-11-16T15:00:00.000000Z\n2025-05-16T15:00:00.000000Z\n2025-11-16T15:00:00.000000Z\n2026-05-16T15:00:00.000000Z\n2026-11-16T15:00:00.000000Z\n2027-05-16T15:00:00.000000Z\n2027-11-16T15:00:00.000000Z\n2028-05-16T15:00:00.000000Z\n2028-11-16T15:00:00.000000Z\n", (CharSequence)sink);
    }
}

