/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.griffin.engine.functions.str;

import com.questdb.cairo.CairoConfiguration;
import com.questdb.cairo.sql.Function;
import com.questdb.cairo.sql.Record;
import com.questdb.cairo.sql.RecordCursor;
import com.questdb.griffin.FunctionFactory;
import com.questdb.griffin.engine.functions.BooleanFunction;
import com.questdb.griffin.engine.functions.bind.BindVariableService;
import com.questdb.std.ObjList;
import java.util.concurrent.atomic.AtomicInteger;

public class TestMatchFunctionFactory
implements FunctionFactory {
    private static final AtomicInteger openCounter = new AtomicInteger();
    private static final AtomicInteger topCounter = new AtomicInteger();
    private static final AtomicInteger closeCount = new AtomicInteger();

    public static void clear() {
        openCounter.set(0);
        topCounter.set(0);
        closeCount.set(0);
    }

    public static int getCloseCount() {
        return closeCount.get();
    }

    public static int getOpenCount() {
        return openCounter.get();
    }

    public static int getTopCount() {
        return topCounter.get();
    }

    public String getSignature() {
        return "test_match()";
    }

    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration) {
        return new TestMatchFunction(position);
    }

    private static class TestMatchFunction
    extends BooleanFunction {
        public TestMatchFunction(int position) {
            super(position);
        }

        public void close() {
            closeCount.incrementAndGet();
        }

        public boolean getBool(Record rec) {
            return true;
        }

        public void init(RecordCursor recordCursor, BindVariableService bindVariableService) {
            openCounter.incrementAndGet();
        }

        public boolean isConstant() {
            return false;
        }

        public void toTop() {
            assert (openCounter.get() > 0);
            topCounter.incrementAndGet();
        }
    }
}

