/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.griffin.engine.functions.rnd;

import com.questdb.cairo.sql.Function;
import com.questdb.griffin.FunctionFactory;
import com.questdb.griffin.SqlException;
import com.questdb.griffin.engine.AbstractFunctionFactoryTest;
import com.questdb.griffin.engine.functions.math.NegIntFunctionFactory;
import com.questdb.griffin.engine.functions.rnd.RndTimestampFunctionFactory;
import org.junit.Assert;
import org.junit.Test;

public class RndTimestampFunctionFactoryTest
extends AbstractFunctionFactoryTest {
    @Test
    public void testInvalidNaNRate() {
        this.assertFailure(50, (CharSequence)"invalid NaN rate", 0L, 10000L, -2);
    }

    @Test
    public void testInvalidRange() {
        this.assertFailure(0, (CharSequence)"invalid range", 100000L, 0L, 1);
    }

    @Test
    public void testNaNs() throws SqlException {
        AbstractFunctionFactoryTest.Invocation invocation = this.call(0L, 10000L, 2);
        Function function = invocation.getFunction1();
        int nanCount = 0;
        for (int i = 0; i < 1000; ++i) {
            long value = function.getTimestamp(null);
            if (value != Long.MIN_VALUE) continue;
            ++nanCount;
        }
        Assert.assertTrue((nanCount > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testNoNaNs() throws SqlException {
        AbstractFunctionFactoryTest.Invocation invocation = this.call(0L, 10000L, 0);
        Function function = invocation.getFunction1();
        int nanCount = 0;
        for (int i = 0; i < 1000; ++i) {
            long value = function.getTimestamp(null);
            if (value != Long.MIN_VALUE) continue;
            ++nanCount;
        }
        Assert.assertEquals((long)0L, (long)nanCount);
    }

    @Override
    protected void addExtraFunctions() {
        functions.add(new NegIntFunctionFactory());
    }

    @Override
    protected FunctionFactory getFunctionFactory() {
        return new RndTimestampFunctionFactory();
    }
}

