/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.griffin.engine.functions.rnd;

import com.questdb.griffin.FunctionFactory;
import com.questdb.griffin.SqlException;
import com.questdb.griffin.engine.AbstractFunctionFactoryTest;
import com.questdb.griffin.engine.functions.rnd.RndSymbolListFunctionFactory;
import com.questdb.std.CharSequenceHashSet;
import org.junit.Assert;
import org.junit.Test;

public class RndSymbolListFunctionFactoryTest
extends AbstractFunctionFactoryTest {
    @Test
    public void testNonConstant() {
        this.assertFailure(false, 11, "STRING constant expected", "ABC", "CDE");
    }

    @Test
    public void testNonString() {
        this.assertFailure(true, 17, "STRING constant expected", "ABC", 1);
    }

    @Test
    public void testSimple() throws SqlException {
        int i;
        CharSequenceHashSet set1 = new CharSequenceHashSet();
        set1.add((CharSequence)"ABC");
        set1.add((CharSequence)"CDE");
        set1.add((CharSequence)"XYZ");
        set1.add(null);
        CharSequenceHashSet set2 = new CharSequenceHashSet();
        AbstractFunctionFactoryTest.Invocation invocation = this.callCustomised(true, "ABC", "CDE", "XYZ", null);
        for (i = 0; i < 1000; ++i) {
            Assert.assertTrue((boolean)set1.contains(invocation.getFunction1().getSymbol(null)));
            Assert.assertTrue((boolean)set1.contains(invocation.getFunction2().getSymbol(null)));
            set2.add(invocation.getFunction1().getSymbol(null));
        }
        int n = set1.size();
        for (i = 0; i < n; ++i) {
            Assert.assertTrue((boolean)set2.contains(set1.get(i)));
        }
    }

    @Override
    protected FunctionFactory getFunctionFactory() {
        return new RndSymbolListFunctionFactory();
    }
}

