/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.griffin.engine.functions.rnd;

import com.questdb.cairo.sql.Function;
import com.questdb.griffin.FunctionFactory;
import com.questdb.griffin.SqlException;
import com.questdb.griffin.engine.AbstractFunctionFactoryTest;
import com.questdb.griffin.engine.functions.math.NegIntFunctionFactory;
import com.questdb.griffin.engine.functions.rnd.RndSymbolFunctionFactory;
import com.questdb.std.ObjHashSet;
import org.junit.Assert;
import org.junit.Test;

public class RndSymbolFunctionFactoryTest
extends AbstractFunctionFactoryTest {
    @Test
    public void testFixedLength() throws SqlException {
        int symbolCount = 10;
        int symbolLen = 4;
        int nullRate = 2;
        AbstractFunctionFactoryTest.Invocation invocation = this.call(symbolCount, symbolLen, symbolLen, nullRate);
        this.assertFixLen(symbolCount, symbolLen, nullRate, invocation.getFunction1());
        this.assertFixLen(symbolCount, symbolLen, nullRate, invocation.getFunction2());
    }

    @Test
    public void testFixedLengthNoNull() throws SqlException {
        int symbolCount = 10;
        int symbolLen = 4;
        int nullRate = 0;
        AbstractFunctionFactoryTest.Invocation invocation = this.call(symbolCount, symbolLen, symbolLen, nullRate);
        this.assertFixLen(symbolCount, symbolLen, nullRate, invocation.getFunction1());
        this.assertFixLen(symbolCount, symbolLen, nullRate, invocation.getFunction2());
    }

    @Test
    public void testInvalidNullRate() {
        this.assertFailure(18, (CharSequence)"rate must be positive", 10, 1, 2, -5);
    }

    @Test
    public void testInvalidRange() {
        this.assertFailure(0, (CharSequence)"invalid range", 10, 8, 6, 2);
    }

    @Test
    public void testNegativeLen() {
        this.assertFailure(0, (CharSequence)"invalid range", 10, -8, -6, 2);
    }

    @Test
    public void testPositiveCount() {
        this.assertFailure(11, (CharSequence)"invalid symbol count", 0, 4, 6, 2);
    }

    @Test
    public void testVarLength() throws SqlException {
        int symbolCount = 10;
        int symbolMin = 4;
        int symbolMax = 6;
        int nullRate = 2;
        AbstractFunctionFactoryTest.Invocation invocation = this.call(symbolCount, symbolMin, symbolMax, nullRate);
        this.assertVarLen(symbolCount, symbolMin, symbolMax, nullRate, invocation.getFunction1());
        this.assertVarLen(symbolCount, symbolMin, symbolMax, nullRate, invocation.getFunction2());
    }

    @Test
    public void testVarLengthNoNull() throws SqlException {
        int symbolCount = 10;
        int symbolMin = 4;
        int symbolMax = 6;
        int nullRate = 0;
        AbstractFunctionFactoryTest.Invocation invocation = this.call(symbolCount, symbolMin, symbolMax, nullRate);
        this.assertVarLen(symbolCount, symbolMin, symbolMax, nullRate, invocation.getFunction1());
        this.assertVarLen(symbolCount, symbolMin, symbolMax, nullRate, invocation.getFunction2());
    }

    @Override
    protected void addExtraFunctions() {
        functions.add(new NegIntFunctionFactory());
    }

    @Override
    protected FunctionFactory getFunctionFactory() {
        return new RndSymbolFunctionFactory();
    }

    private void assertFixLen(int symbolCount, int symbolLen, int nullRate, Function function) {
        ObjHashSet set = new ObjHashSet();
        int nullCount = 0;
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        for (int i = 0; i < 100; ++i) {
            CharSequence value = function.getSymbol(null);
            if (value == null) {
                ++nullCount;
                continue;
            }
            if (value.length() < min) {
                min = value.length();
            }
            if (value.length() > max) {
                max = value.length();
            }
            set.add((Object)value);
        }
        if (nullRate > 0) {
            Assert.assertTrue((nullCount > 0 ? 1 : 0) != 0);
        } else {
            Assert.assertEquals((long)0L, (long)nullCount);
        }
        Assert.assertTrue((set.size() <= symbolCount ? 1 : 0) != 0);
        Assert.assertEquals((long)symbolLen, (long)max);
        Assert.assertEquals((long)symbolLen, (long)min);
    }

    private void assertVarLen(int symbolCount, int symbolMin, int symbolMax, int nullRate, Function function) {
        ObjHashSet set = new ObjHashSet();
        int nullCount = 0;
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        for (int i = 0; i < 100; ++i) {
            CharSequence value = function.getSymbol(null);
            if (value == null) {
                ++nullCount;
                continue;
            }
            if (value.length() < min) {
                min = value.length();
            }
            if (value.length() > max) {
                max = value.length();
            }
            set.add((Object)value);
        }
        if (nullRate > 0) {
            Assert.assertTrue((nullCount > 0 ? 1 : 0) != 0);
        } else {
            Assert.assertEquals((long)0L, (long)nullCount);
        }
        Assert.assertTrue((set.size() <= symbolCount ? 1 : 0) != 0);
        Assert.assertTrue((symbolMin <= min ? 1 : 0) != 0);
        Assert.assertTrue((symbolMax >= max ? 1 : 0) != 0);
        Assert.assertNotEquals((long)min, (long)max);
    }
}

