/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.griffin.engine.functions.rnd;

import com.questdb.cairo.sql.Function;
import com.questdb.griffin.FunctionFactory;
import com.questdb.griffin.SqlException;
import com.questdb.griffin.engine.AbstractFunctionFactoryTest;
import com.questdb.griffin.engine.functions.math.NegIntFunctionFactory;
import com.questdb.griffin.engine.functions.rnd.RndStrFunctionFactory;
import org.junit.Assert;
import org.junit.Test;

public class RndStrFunctionFactoryTest
extends AbstractFunctionFactoryTest {
    @Test
    public void testFixLength() throws SqlException {
        AbstractFunctionFactoryTest.Invocation invocation = this.call(3, 3, 5);
        this.assertFixedLengthFunction(invocation.getFunction1());
        this.assertFixedLengthFunction(invocation.getFunction2());
    }

    @Test
    public void testInvalidRange() {
        this.assertFailure(0, (CharSequence)"invalid range", 5, 3, 6);
        this.assertFailure(0, (CharSequence)"invalid range", 0, 3, 6);
        this.assertFailure(13, (CharSequence)"rate must be positive", 1, 10, -1);
    }

    @Test
    public void testInvalidRate() {
        this.assertFailure(12, (CharSequence)"rate must be positive", 3, 6, -1);
    }

    @Test
    public void testNoNulls() throws SqlException {
        this.assertFunction(2, 10, 0);
    }

    @Test
    public void testPositive() throws SqlException {
        this.assertFunction(5, 8, 5);
    }

    @Override
    protected void addExtraFunctions() {
        functions.add(new NegIntFunctionFactory());
    }

    @Override
    protected FunctionFactory getFunctionFactory() {
        return new RndStrFunctionFactory();
    }

    private void assertFixedLengthFunction(Function function) {
        this.assertFixedLengthFunctionA(function);
        this.assertFixedLengthFunctionB(function);
    }

    private void assertFixedLengthFunctionA(Function function) {
        int nullCount = 0;
        for (int i = 0; i < 100; ++i) {
            CharSequence value = function.getStr(null);
            if (value == null) {
                ++nullCount;
                continue;
            }
            int len = value.length();
            Assert.assertEquals((long)3L, (long)len);
        }
        Assert.assertTrue((nullCount > 0 ? 1 : 0) != 0);
    }

    private void assertFixedLengthFunctionB(Function function) {
        int nullCount = 0;
        for (int i = 0; i < 100; ++i) {
            CharSequence value = function.getStrB(null);
            if (value == null) {
                ++nullCount;
                continue;
            }
            int len = value.length();
            Assert.assertEquals((long)3L, (long)len);
        }
        Assert.assertTrue((nullCount > 0 ? 1 : 0) != 0);
    }

    private void assertFunction(int lo, int hi, int nullRate) throws SqlException {
        this.assertFunctionA(lo, hi, nullRate);
        this.assertFunctionB(lo, hi, nullRate);
    }

    private void assertFunctionA(int lo, int hi, int nullRate) throws SqlException {
        AbstractFunctionFactoryTest.Invocation invocation = this.call(lo, hi, nullRate);
        Function function = invocation.getFunction1();
        int nullCount = 0;
        for (int i = 0; i < 100; ++i) {
            CharSequence value = function.getStr(null);
            if (value == null) {
                ++nullCount;
                continue;
            }
            int len = value.length();
            Assert.assertTrue((len <= hi && len >= lo ? 1 : 0) != 0);
        }
        if (nullRate > 0) {
            Assert.assertTrue((nullCount > 0 ? 1 : 0) != 0);
        } else {
            Assert.assertEquals((long)0L, (long)nullCount);
        }
    }

    private void assertFunctionB(int lo, int hi, int nullRate) throws SqlException {
        AbstractFunctionFactoryTest.Invocation invocation = this.call(lo, hi, nullRate);
        Function function = invocation.getFunction1();
        int nullCount = 0;
        for (int i = 0; i < 100; ++i) {
            CharSequence value = function.getStrB(null);
            if (value == null) {
                ++nullCount;
                continue;
            }
            int len = value.length();
            Assert.assertTrue((len <= hi && len >= lo ? 1 : 0) != 0);
        }
        if (nullRate > 0) {
            Assert.assertTrue((nullCount > 0 ? 1 : 0) != 0);
        } else {
            Assert.assertEquals((long)0L, (long)nullCount);
        }
    }
}

