/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.griffin.engine.functions.rnd;

import com.questdb.cairo.sql.Function;
import com.questdb.griffin.FunctionFactory;
import com.questdb.griffin.SqlException;
import com.questdb.griffin.engine.AbstractFunctionFactoryTest;
import com.questdb.griffin.engine.functions.math.NegIntFunctionFactory;
import com.questdb.griffin.engine.functions.rnd.RndLongCCFunctionFactory;
import org.junit.Assert;
import org.junit.Test;

public class RndLongCCFunctionFactoryTest
extends AbstractFunctionFactoryTest {
    @Test
    public void testInvalidRange() {
        this.assertFailure(0, (CharSequence)"invalid range", 20L, 10L, 0);
    }

    @Test
    public void testInvalidRange2() {
        this.assertFailure(0, (CharSequence)"invalid range", 5L, 5L, 0);
    }

    @Test
    public void testInvalidRange3() {
        this.assertFailure(13, (CharSequence)"invalid NaN rate", 1L, 4L, -1);
    }

    @Test
    public void testNegativeRange() throws SqlException {
        this.assertValues(-134L, -40L, 4);
    }

    @Test
    public void testNoNaNs() throws SqlException {
        this.assertValues(10L, 20L, 0);
    }

    @Test
    public void testPositiveRange() throws SqlException {
        this.assertValues(10L, 20L, 5);
    }

    @Override
    protected void addExtraFunctions() {
        functions.add(new NegIntFunctionFactory());
    }

    @Override
    protected FunctionFactory getFunctionFactory() {
        return new RndLongCCFunctionFactory();
    }

    private void assertFunctionValues(long lo, long hi, boolean expectNan, AbstractFunctionFactoryTest.Invocation invocation, Function function1) {
        int nanCount = 0;
        for (int i = 0; i < 1000; ++i) {
            long value = function1.getLong(invocation.getRecord());
            if (value == Long.MIN_VALUE) {
                ++nanCount;
                continue;
            }
            Assert.assertTrue((value <= hi && value >= lo ? 1 : 0) != 0);
        }
        if (expectNan) {
            Assert.assertTrue((nanCount > 0 ? 1 : 0) != 0);
        } else {
            Assert.assertEquals((long)0L, (long)nanCount);
        }
    }

    private void assertValues(long lo, long hi, int nanRate) throws SqlException {
        AbstractFunctionFactoryTest.Invocation invocation = this.call(lo, hi, nanRate);
        this.assertFunctionValues(lo, hi, nanRate > 0, invocation, invocation.getFunction1());
        this.assertFunctionValues(lo, hi, nanRate > 0, invocation, invocation.getFunction2());
    }
}

