/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.griffin.engine.functions.rnd;

import com.questdb.cairo.sql.Function;
import com.questdb.griffin.FunctionFactory;
import com.questdb.griffin.SqlException;
import com.questdb.griffin.engine.AbstractFunctionFactoryTest;
import com.questdb.griffin.engine.functions.math.NegIntFunctionFactory;
import com.questdb.griffin.engine.functions.rnd.RndIntCCFunctionFactory;
import org.junit.Assert;
import org.junit.Test;

public class RndIntCCFunctionFactoryTest
extends AbstractFunctionFactoryTest {
    @Test
    public void testInvalidRange() {
        this.assertFailure(0, (CharSequence)"invalid range", 20, 10, 0);
        this.assertFailure(0, (CharSequence)"invalid range", 5, 5, 0);
        this.assertFailure(12, (CharSequence)"invalid NaN rate", 1, 4, -1);
    }

    @Test
    public void testNegativeRange() throws SqlException {
        this.assertValues(-134, -40, 4);
    }

    @Test
    public void testNoNaNs() throws SqlException {
        this.assertValues(10, 20, 0);
    }

    @Test
    public void testPositiveRange() throws SqlException {
        this.assertValues(10, 20, 5);
    }

    @Override
    protected void addExtraFunctions() {
        functions.add(new NegIntFunctionFactory());
    }

    @Override
    protected FunctionFactory getFunctionFactory() {
        return new RndIntCCFunctionFactory();
    }

    private void assertFunctionValues(int lo, int hi, boolean expectNan, AbstractFunctionFactoryTest.Invocation invocation, Function function1) {
        int nanCount = 0;
        for (int i = 0; i < 1000; ++i) {
            int value = function1.getInt(invocation.getRecord());
            if (value == Integer.MIN_VALUE) {
                ++nanCount;
                continue;
            }
            Assert.assertTrue((value <= hi && value >= lo ? 1 : 0) != 0);
        }
        if (expectNan) {
            Assert.assertTrue((nanCount > 0 ? 1 : 0) != 0);
        } else {
            Assert.assertEquals((long)0L, (long)nanCount);
        }
    }

    private void assertValues(int lo, int hi, int nanRate) throws SqlException {
        AbstractFunctionFactoryTest.Invocation invocation = this.call(lo, hi, nanRate);
        this.assertFunctionValues(lo, hi, nanRate > 0, invocation, invocation.getFunction1());
        this.assertFunctionValues(lo, hi, nanRate > 0, invocation, invocation.getFunction2());
    }
}

