/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.griffin.engine.functions.rnd;

import com.questdb.cairo.sql.Function;
import com.questdb.cairo.sql.Record;
import com.questdb.griffin.FunctionFactory;
import com.questdb.griffin.SqlException;
import com.questdb.griffin.engine.AbstractFunctionFactoryTest;
import com.questdb.griffin.engine.functions.math.NegIntFunctionFactory;
import com.questdb.griffin.engine.functions.rnd.RndDoubleFunctionFactory;
import org.junit.Assert;
import org.junit.Test;

public class RndDoubleFunctionFactoryTest
extends AbstractFunctionFactoryTest {
    @Test
    public void testNaNRate() {
        this.assertFailure(11, (CharSequence)"invalid NaN rate", -1);
    }

    @Test
    public void testNoNaN() throws SqlException {
        this.assertFunction(this.call(0), false);
    }

    @Test
    public void testSimple() throws SqlException {
        this.assertFunction(this.call(4), true);
    }

    @Override
    protected void addExtraFunctions() {
        functions.add(new NegIntFunctionFactory());
    }

    @Override
    protected FunctionFactory getFunctionFactory() {
        return new RndDoubleFunctionFactory();
    }

    private void assertFunction(AbstractFunctionFactoryTest.Invocation invocation, boolean expectNaN) {
        this.assertFunction(invocation.getFunction1(), invocation.getRecord(), expectNaN);
        this.assertFunction(invocation.getFunction2(), invocation.getRecord(), expectNaN);
    }

    private void assertFunction(Function function, Record record, boolean expectNaN) {
        int nanCount = 0;
        for (int i = 0; i < 100; ++i) {
            double d = function.getDouble(record);
            if (d != d) {
                ++nanCount;
                continue;
            }
            Assert.assertTrue((d > 0.0 && d < 1.0 ? 1 : 0) != 0);
        }
        if (expectNaN) {
            Assert.assertTrue((nanCount > 0 ? 1 : 0) != 0);
        } else {
            Assert.assertEquals((long)0L, (long)nanCount);
        }
    }
}

