/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.griffin.engine.functions.rnd;

import com.questdb.cairo.Engine;
import com.questdb.cairo.sql.CairoEngine;
import com.questdb.cairo.sql.RecordCursorFactory;
import com.questdb.griffin.FunctionFactory;
import com.questdb.griffin.SqlCompiler;
import com.questdb.griffin.SqlException;
import com.questdb.griffin.engine.AbstractFunctionFactoryTest;
import com.questdb.griffin.engine.functions.bind.BindVariableService;
import com.questdb.griffin.engine.functions.math.NegIntFunctionFactory;
import com.questdb.griffin.engine.functions.rnd.RndBinFunctionFactory;
import com.questdb.griffin.engine.functions.rnd.SharedRandom;
import com.questdb.std.Rnd;
import java.io.IOException;
import org.junit.Before;
import org.junit.Test;

public class RndBinFunctionFactoryTest
extends AbstractFunctionFactoryTest {
    private static final CairoEngine engine = new Engine(configuration);
    private static final SqlCompiler compiler = new SqlCompiler(engine, configuration);
    private static final BindVariableService bindVariableService = new BindVariableService();

    @Before
    public void setup() {
        SharedRandom.RANDOM.set(new Rnd());
    }

    @Test
    public void testBadMinimum() {
        this.assertFailure(8, (CharSequence)"minimum has to be grater than 0", 0L, 10L, 2);
    }

    @Test
    public void testFixedLength() throws SqlException, IOException {
        this.assertQuery("x\n00000000 ee 41 1d 15 55 8a\n\n00000000 d8 cc 14 ce f1 59\n00000000 c4 91 3b 72 db f3\n00000000 1b c7 88 de a0 79\n00000000 77 15 68 61 26 af\n00000000 c4 95 94 36 53 49\n\n\n00000000 3b 08 a1 1e 38 8d\n", "random_cursor(10, 'x', to_char(rnd_bin(6,6,2)))");
    }

    @Test
    public void testFixedLengthNoNulls() throws SqlException, IOException {
        this.assertQuery("x\n00000000 ee 41 1d 15 55\n00000000 17 fa d8 cc 14\n00000000 f1 59 88 c4 91\n00000000 72 db f3 04 1b\n00000000 88 de a0 79 3c\n00000000 15 68 61 26 af\n00000000 c4 95 94 36 53\n00000000 b4 59 7e 3b 08\n00000000 1e 38 8d 1b 9e\n00000000 c8 39 09 fe d8\n", "random_cursor(10, 'x', to_char(rnd_bin(5,5,0)))");
    }

    @Test
    public void testInvalidRange() {
        this.assertFailure(0, (CharSequence)"invalid range", 150L, 140L, 3);
    }

    @Test
    public void testNegativeNullRate() {
        this.assertFailure(14, (CharSequence)"invalid null rate", 20L, 30L, -1);
    }

    @Test
    public void testVarLength() throws SqlException, IOException {
        this.assertQuery("x\n00000000 41 1d 15\n00000000 17 fa d8 cc 14\n\n\n\n00000000 91 3b 72 db f3\n00000000 c7 88 de a0 79 3c 77 15\n00000000 26 af 19 c4 95 94 36 53\n\n\n", "random_cursor(10, 'x', to_char(rnd_bin(3,8,2)))");
    }

    @Test
    public void testVarLengthNoNulls() throws SqlException, IOException {
        this.assertQuery("x\n00000000 41 1d 15\n00000000 17 fa d8 cc 14\n00000000 59 88 c4 91 3b 72\n00000000 04 1b c7 88 de a0\n00000000 77 15 68\n00000000 af 19 c4 95 94 36 53\n00000000 59 7e 3b 08 a1\n00000000 8d 1b 9e f4 c8 39 09\n00000000 9d 30 78\n00000000 32 de e4\n", "random_cursor(10, 'x', to_char(rnd_bin(3,8,0)))");
    }

    @Override
    protected void addExtraFunctions() {
        functions.add(new NegIntFunctionFactory());
    }

    @Override
    protected FunctionFactory getFunctionFactory() {
        return new RndBinFunctionFactory();
    }

    private void assertQuery(CharSequence expected, CharSequence sql) throws SqlException, IOException {
        RecordCursorFactory factory = compiler.compile(sql, bindVariableService);
        this.assertOnce(expected, factory.getCursor(bindVariableService), factory.getMetadata(), true);
    }
}

