/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.griffin.engine.functions.rnd;

import com.questdb.cairo.CairoConfiguration;
import com.questdb.cairo.GenericRecordMetadata;
import com.questdb.cairo.TableColumnMetadata;
import com.questdb.cairo.sql.Function;
import com.questdb.cairo.sql.Record;
import com.questdb.cairo.sql.RecordCursor;
import com.questdb.cairo.sql.RecordCursorFactory;
import com.questdb.cairo.sql.RecordMetadata;
import com.questdb.cairo.sql.VirtualRecord;
import com.questdb.griffin.FunctionFactory;
import com.questdb.griffin.SqlException;
import com.questdb.griffin.engine.functions.CursorFunction;
import com.questdb.griffin.engine.functions.GenericRecordCursorFactory;
import com.questdb.griffin.engine.functions.rnd.RandomRecordCursor;
import com.questdb.std.ObjList;

public class RandomCursorFunctionFactory
implements FunctionFactory {
    public String getSignature() {
        return "random_cursor(lV)";
    }

    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration) throws SqlException {
        int argLen = args.size();
        if (argLen % 2 == 0) {
            throw SqlException.position((int)position).put((CharSequence)"invalid number of arguments. Expected rnd_table(count, 'column', rnd_function(), ...)");
        }
        if (argLen < 3) {
            throw SqlException.$((int)position, (CharSequence)"not enough arguments");
        }
        long recordCount = ((Function)args.getQuick(0)).getLong(null);
        if (recordCount < 0L) {
            throw SqlException.$((int)((Function)args.getQuick(0)).getPosition(), (CharSequence)"invalid record count");
        }
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        ObjList functions = new ObjList();
        int n = args.size();
        for (int i = 1; i < n; i += 2) {
            Function columnName = (Function)args.getQuick(i);
            if (!columnName.isConstant() || columnName.getType() != 7) {
                throw SqlException.position((int)columnName.getPosition()).put((CharSequence)"STRING constant expected");
            }
            CharSequence columnNameStr = columnName.getStr(null);
            if (columnNameStr == null) {
                throw SqlException.position((int)columnName.getPosition()).put((CharSequence)"column name must not be NULL");
            }
            Function rndFunc = (Function)args.getQuick(i + 1);
            metadata.add(new TableColumnMetadata(columnNameStr.toString(), rndFunc.getType()));
            functions.add((Object)rndFunc);
        }
        VirtualRecord record = new VirtualRecord(functions);
        return new CursorFunction(position, (RecordCursorFactory)new GenericRecordCursorFactory((RecordMetadata)metadata, (RecordCursor)new RandomRecordCursor(recordCount, (Record)record), false));
    }
}

