/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.griffin.engine.functions.math;

import com.questdb.griffin.FunctionFactory;
import com.questdb.griffin.SqlException;
import com.questdb.griffin.engine.AbstractFunctionFactoryTest;
import com.questdb.griffin.engine.functions.math.RoundDoubleFunctionFactory;
import org.junit.Test;

public class RoundDoubleFunctionFactoryTest
extends AbstractFunctionFactoryTest {
    @Test
    public void testLargeScale() throws SqlException {
        this.call(14.7778, 16).andAssert(Double.NaN, 1.0E-10);
    }

    @Test
    public void testLeftNan() throws SqlException {
        this.call(Double.NaN, 5).andAssert(Double.NaN, 1.0E-4);
    }

    @Test
    public void testRightNan() throws SqlException {
        this.call(123.65, Integer.MIN_VALUE).andAssert(Double.NaN, 1.0E-4);
    }

    @Test
    public void testSimple() throws SqlException {
        this.call(14.7778, 3).andAssert(14.778, 1.0E-10);
    }

    @Override
    protected FunctionFactory getFunctionFactory() {
        return new RoundDoubleFunctionFactory();
    }
}

