/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.griffin.engine.functions.math;

import com.questdb.griffin.FunctionFactory;
import com.questdb.griffin.SqlException;
import com.questdb.griffin.engine.AbstractFunctionFactoryTest;
import com.questdb.griffin.engine.functions.math.DivLongFunctionFactory;
import org.junit.Test;

public class DivLongFunctionFactoryTest
extends AbstractFunctionFactoryTest {
    @Test
    public void testDivByZero() throws SqlException {
        this.call(24L, 0L).andAssert(Long.MIN_VALUE);
    }

    @Test
    public void testLeftNan() throws SqlException {
        this.call(Long.MIN_VALUE, 5L).andAssert(Long.MIN_VALUE);
    }

    @Test
    public void testNegative() throws SqlException {
        this.call(-12L, 4L).andAssert(-3L);
    }

    @Test
    public void testRightNan() throws SqlException {
        this.call(123L, Long.MIN_VALUE).andAssert(Long.MIN_VALUE);
    }

    @Test
    public void testSimple() throws SqlException {
        this.call(24L, 8L).andAssert(3L);
    }

    @Override
    protected FunctionFactory getFunctionFactory() {
        return new DivLongFunctionFactory();
    }
}

