/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.griffin.engine.functions.math;

import com.questdb.griffin.FunctionFactory;
import com.questdb.griffin.SqlException;
import com.questdb.griffin.engine.AbstractFunctionFactoryTest;
import com.questdb.griffin.engine.functions.math.DivDoubleFunctionFactory;
import org.junit.Test;

public class DivDoubleFunctionFactoryTest
extends AbstractFunctionFactoryTest {
    @Test
    public void testDivByZero() throws SqlException {
        this.call(10.0, 0.0).andAssert(Double.POSITIVE_INFINITY, 1.0E-6);
    }

    @Test
    public void testLeftNan() throws SqlException {
        this.call(Double.NaN, 5.0).andAssert(Double.NaN, 0.0);
    }

    @Test
    public void testNegative() throws SqlException {
        this.call(-3.0, 4.0).andAssert(-0.75, 1.0E-6);
    }

    @Test
    public void testRightNan() throws SqlException {
        this.call(123.0, Double.NaN).andAssert(Double.NaN, 1.0E-6);
    }

    @Test
    public void testSimple() throws SqlException {
        this.call(10.0, 8.0).andAssert(1.25, 1.0E-6);
    }

    @Override
    protected FunctionFactory getFunctionFactory() {
        return new DivDoubleFunctionFactory();
    }
}

