/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.griffin.engine.functions.eq;

import com.questdb.cairo.AbstractCairoTest;
import com.questdb.cairo.Engine;
import com.questdb.cairo.sql.CairoEngine;
import com.questdb.cairo.sql.RecordCursor;
import com.questdb.cairo.sql.RecordCursorFactory;
import com.questdb.griffin.SqlCompiler;
import com.questdb.griffin.engine.functions.bind.BindVariableService;
import com.questdb.griffin.engine.functions.rnd.SharedRandom;
import com.questdb.std.Rnd;
import com.questdb.test.tools.TestUtils;
import org.junit.Before;
import org.junit.Test;

public class EqStrFunctionFactoryTest
extends AbstractCairoTest {
    private static final BindVariableService bindVariableService = new BindVariableService();
    private static final Engine engine = new Engine(configuration);
    private static final SqlCompiler compiler = new SqlCompiler((CairoEngine)engine, configuration);

    @Before
    public void setUp2() {
        SharedRandom.RANDOM.set(new Rnd());
    }

    @Test
    public void testSimple() throws Exception {
        String expected = "a\tb\tc\nTO\tTO\t0.864511711022\nJH\tJH\t0.293725743137\nHR\tHR\t0.705236013489\nGT\tGT\t0.320418516505\nFF\tFF\t0.723774060553\nHD\tHD\t0.921018327202\nPG\tPG\t0.569301148082\nNZ\tNZ\t0.750812468878\nTK\tTK\t0.656634057464\nFZ\tFZ\t0.700056044177\nUW\tUW\t0.015101588517\nHD\tHD\t0.379366696164\nTR\tTR\t0.535853377530\nCO\tCO\t0.007992908129\nOS\tOS\t0.769345772543\n";
        TestUtils.assertMemoryLeak(() -> {
            compiler.compile((CharSequence)"create table x as ( select rnd_str(2,2,0) a, rnd_str(2,2,0) b, rnd_double(0) c from long_sequence(10000))", bindVariableService);
            try (RecordCursorFactory factory = compiler.compile((CharSequence)"x where a = b", bindVariableService);){
                sink.clear();
                try (RecordCursor cursor = factory.getCursor(bindVariableService);){
                    printer.print(cursor, factory.getMetadata(), true);
                }
                TestUtils.assertEquals((CharSequence)"a\tb\tc\nTO\tTO\t0.864511711022\nJH\tJH\t0.293725743137\nHR\tHR\t0.705236013489\nGT\tGT\t0.320418516505\nFF\tFF\t0.723774060553\nHD\tHD\t0.921018327202\nPG\tPG\t0.569301148082\nNZ\tNZ\t0.750812468878\nTK\tTK\t0.656634057464\nFZ\tFZ\t0.700056044177\nUW\tUW\t0.015101588517\nHD\tHD\t0.379366696164\nTR\tTR\t0.535853377530\nCO\tCO\t0.007992908129\nOS\tOS\t0.769345772543\n", (CharSequence)sink);
            }
            engine.releaseAllReaders();
            engine.releaseAllWriters();
        });
    }

    @Test
    public void testStrEquals() throws Exception {
        String expected = "a\tb\tc\n\t\t0.736005795481\n\t\t0.888454149250\n\t\t0.507321975059\n\t\t0.006428156810\n\t\t0.195043256107\n\t\t0.857872699497\n\t\t0.374706013658\n\t\t0.323410069144\n\t\t0.051891241416\n\t\t0.351737465333\n\t\t0.610673817312\n\t\t0.569218454032\n\t\t0.658259990960\n\t\t0.408452385193\n\t\t0.990774115459\n\t\t0.141847757100\n\t\t0.916328143564\n\t\t0.259121103066\n\t\t0.262788521934\n\t\t0.062029468049\n\t\t0.644042004544\n\t\t0.511174094681\n\t\t0.644475642173\n\t\t0.689548912727\n\t\t0.416820310888\n\t\t0.847242206369\n\t\t0.671445193691\n\t\t0.361372173908\n\t\t0.329520695357\n";
        TestUtils.assertMemoryLeak(() -> {
            compiler.compile((CharSequence)"create table x as ( select rnd_str(4,4,8) a, rnd_str(4,4,8) b, rnd_double(0) c from long_sequence(10000))", bindVariableService);
            try (RecordCursorFactory factory = compiler.compile((CharSequence)"x where a = b", bindVariableService);){
                sink.clear();
                try (RecordCursor cursor = factory.getCursor(bindVariableService);){
                    printer.print(cursor, factory.getMetadata(), true);
                }
                TestUtils.assertEquals((CharSequence)"a\tb\tc\n\t\t0.736005795481\n\t\t0.888454149250\n\t\t0.507321975059\n\t\t0.006428156810\n\t\t0.195043256107\n\t\t0.857872699497\n\t\t0.374706013658\n\t\t0.323410069144\n\t\t0.051891241416\n\t\t0.351737465333\n\t\t0.610673817312\n\t\t0.569218454032\n\t\t0.658259990960\n\t\t0.408452385193\n\t\t0.990774115459\n\t\t0.141847757100\n\t\t0.916328143564\n\t\t0.259121103066\n\t\t0.262788521934\n\t\t0.062029468049\n\t\t0.644042004544\n\t\t0.511174094681\n\t\t0.644475642173\n\t\t0.689548912727\n\t\t0.416820310888\n\t\t0.847242206369\n\t\t0.671445193691\n\t\t0.361372173908\n\t\t0.329520695357\n", (CharSequence)sink);
            }
            engine.releaseAllReaders();
            engine.releaseAllWriters();
        });
    }

    @Test
    public void testStrEqualsConstant() throws Exception {
        String expected = "a\tb\tc\nUW\tPV\t0.923691478032\nUW\tEW\t0.046158585511\nUW\tLP\t0.812164456445\nUW\tMD\t0.743096200973\nUW\tWN\t0.971829797336\nUW\tPQ\t0.900435046194\nUW\tJS\t0.029348048369\nUW\tEJ\t0.085101480777\nUW\tKZ\t0.666129919823\nUW\tWX\t0.552643516151\nUW\tHQ\t0.529423895223\nUW\tUW\t0.015101588517\nUW\tMK\t0.964233343466\n";
        TestUtils.assertMemoryLeak(() -> {
            compiler.compile((CharSequence)"create table x as ( select rnd_str(2,2,0) a, rnd_str(2,2,0) b, rnd_double(0) c from long_sequence(10000))", bindVariableService);
            try (RecordCursorFactory factory = compiler.compile((CharSequence)"x where a = 'UW'", bindVariableService);){
                sink.clear();
                try (RecordCursor cursor = factory.getCursor(bindVariableService);){
                    printer.print(cursor, factory.getMetadata(), true);
                }
                TestUtils.assertEquals((CharSequence)"a\tb\tc\nUW\tPV\t0.923691478032\nUW\tEW\t0.046158585511\nUW\tLP\t0.812164456445\nUW\tMD\t0.743096200973\nUW\tWN\t0.971829797336\nUW\tPQ\t0.900435046194\nUW\tJS\t0.029348048369\nUW\tEJ\t0.085101480777\nUW\tKZ\t0.666129919823\nUW\tWX\t0.552643516151\nUW\tHQ\t0.529423895223\nUW\tUW\t0.015101588517\nUW\tMK\t0.964233343466\n", (CharSequence)sink);
            }
            engine.releaseAllReaders();
            engine.releaseAllWriters();
        });
    }

    @Test
    public void testStrEqualsConstant2() throws Exception {
        String expected = "a\tb\tc\nUW\tPV\t0.923691478032\nUW\tEW\t0.046158585511\nUW\tLP\t0.812164456445\nUW\tMD\t0.743096200973\nUW\tWN\t0.971829797336\nUW\tPQ\t0.900435046194\nUW\tJS\t0.029348048369\nUW\tEJ\t0.085101480777\nUW\tKZ\t0.666129919823\nUW\tWX\t0.552643516151\nUW\tHQ\t0.529423895223\nUW\tUW\t0.015101588517\nUW\tMK\t0.964233343466\n";
        TestUtils.assertMemoryLeak(() -> {
            compiler.compile((CharSequence)"create table x as ( select rnd_str(2,2,0) a, rnd_str(2,2,0) b, rnd_double(0) c from long_sequence(10000))", bindVariableService);
            try (RecordCursorFactory factory = compiler.compile((CharSequence)"x where 'UW' = a", bindVariableService);){
                sink.clear();
                try (RecordCursor cursor = factory.getCursor(bindVariableService);){
                    printer.print(cursor, factory.getMetadata(), true);
                }
                TestUtils.assertEquals((CharSequence)"a\tb\tc\nUW\tPV\t0.923691478032\nUW\tEW\t0.046158585511\nUW\tLP\t0.812164456445\nUW\tMD\t0.743096200973\nUW\tWN\t0.971829797336\nUW\tPQ\t0.900435046194\nUW\tJS\t0.029348048369\nUW\tEJ\t0.085101480777\nUW\tKZ\t0.666129919823\nUW\tWX\t0.552643516151\nUW\tHQ\t0.529423895223\nUW\tUW\t0.015101588517\nUW\tMK\t0.964233343466\n", (CharSequence)sink);
            }
            engine.releaseAllReaders();
            engine.releaseAllWriters();
        });
    }

    @Test
    public void testStrEqualsNull() throws Exception {
        String expected = "a\tb\tc\n\tSY\t0.962283803859\n\tZU\t0.948685205706\n\tMG\t0.591453611066\n\tHX\t0.438165062627\n\tLG\t0.080922888665\n\tGF\t0.946229102187\n\tXW\t0.306393180274\n\tYE\t0.467723696273\n\tGP\t0.428403698439\n\tLX\t0.971586265072\n\tRB\t0.561342235360\n\tPD\t0.850102613275\n";
        TestUtils.assertMemoryLeak(() -> {
            compiler.compile((CharSequence)"create table x as ( select rnd_str(2,2,400) a, rnd_str(2,2,0) b, rnd_double(0) c from long_sequence(10000))", bindVariableService);
            try (RecordCursorFactory factory = compiler.compile((CharSequence)"x where a = null", bindVariableService);){
                sink.clear();
                try (RecordCursor cursor = factory.getCursor(bindVariableService);){
                    printer.print(cursor, factory.getMetadata(), true);
                }
                TestUtils.assertEquals((CharSequence)"a\tb\tc\n\tSY\t0.962283803859\n\tZU\t0.948685205706\n\tMG\t0.591453611066\n\tHX\t0.438165062627\n\tLG\t0.080922888665\n\tGF\t0.946229102187\n\tXW\t0.306393180274\n\tYE\t0.467723696273\n\tGP\t0.428403698439\n\tLX\t0.971586265072\n\tRB\t0.561342235360\n\tPD\t0.850102613275\n", (CharSequence)sink);
            }
            engine.releaseAllReaders();
            engine.releaseAllWriters();
        });
    }
}

