/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.griffin.engine.functions.date;

import com.questdb.griffin.FunctionFactory;
import com.questdb.griffin.SqlException;
import com.questdb.griffin.engine.AbstractFunctionFactoryTest;
import com.questdb.griffin.engine.functions.date.ToTimestampVCFunctionFactory;
import org.junit.Test;

public class ToTimestampVCFunctionFactoryTest
extends AbstractFunctionFactoryTest {
    @Test
    public void testNonCompliantDate() throws SqlException {
        this.call("2015 03/12 abc", "yyyy dd/MM").andAssertTimestamp(Long.MIN_VALUE);
    }

    @Test
    public void testNullDate() throws SqlException {
        this.call(null, "yyyy dd/MM").andAssertTimestamp(Long.MIN_VALUE);
    }

    @Test
    public void testNullPattern() {
        this.assertFailure(16, (CharSequence)"pattern is required", "2015", null);
    }

    @Test
    public void testSimple() throws SqlException {
        this.call("2015 03/12 514", "yyyy dd/MM UUU").andAssertTimestamp(1449100800000514L);
    }

    @Override
    protected FunctionFactory getFunctionFactory() {
        return new ToTimestampVCFunctionFactory();
    }
}

