/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.griffin.engine.functions.date;

import com.questdb.griffin.FunctionFactory;
import com.questdb.griffin.SqlException;
import com.questdb.griffin.engine.AbstractFunctionFactoryTest;
import com.questdb.griffin.engine.functions.date.ToDateFunctionFactory;
import org.junit.Test;

public class ToDateVCFunctionFactoryTest
extends AbstractFunctionFactoryTest {
    @Test
    public void testNonCompliantDate() throws SqlException {
        this.call("2015 03/12 abc", "yyyy dd/MM").andAssertDate(Long.MIN_VALUE);
    }

    @Test
    public void testNullDate() throws SqlException {
        this.call(null, "yyyy dd/MM").andAssertDate(Long.MIN_VALUE);
    }

    @Test
    public void testNullPattern() {
        this.assertFailure(11, (CharSequence)"pattern is required", "2015", null);
    }

    @Test
    public void testSimple() throws SqlException {
        this.call("2015 03/12", "yyyy dd/MM").andAssertDate(1449100800000L);
    }

    @Override
    protected FunctionFactory getFunctionFactory() {
        return new ToDateFunctionFactory();
    }
}

