/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.griffin.engine.functions.date;

import com.questdb.cairo.sql.Function;
import com.questdb.griffin.FunctionFactory;
import com.questdb.griffin.SqlException;
import com.questdb.griffin.engine.AbstractFunctionFactoryTest;
import com.questdb.griffin.engine.functions.date.TimestampSequenceFunctionFactory;
import com.questdb.griffin.engine.functions.math.NegIntFunctionFactory;
import org.junit.Assert;
import org.junit.Test;

public class TimestampSequenceFunctionFactoryTest
extends AbstractFunctionFactoryTest {
    @Test
    public void testIncrement1() throws SqlException {
        this.assertFunction(this.call(0L, 1000L).getFunction1());
    }

    @Test
    public void testIncrement2() throws SqlException {
        this.assertFunction(this.call(0L, 1000L).getFunction2());
    }

    @Test
    public void testNaN() throws SqlException {
        this.call(Long.MIN_VALUE, 1000L).andAssertTimestamp(Long.MIN_VALUE);
    }

    @Test
    public void testNegativeIncrement() {
        this.assertFailure(35, (CharSequence)"positive increment expected", 0L, -100L);
    }

    @Override
    protected void addExtraFunctions() {
        functions.add(new NegIntFunctionFactory());
    }

    @Override
    protected FunctionFactory getFunctionFactory() {
        return new TimestampSequenceFunctionFactory();
    }

    private void assertFunction(Function function) {
        long next = 0L;
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((long)next, (long)function.getTimestamp(null));
            next += 1000L;
        }
    }
}

