/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.griffin.engine.functions.bind;

import com.questdb.cairo.GenericRecordMetadata;
import com.questdb.cairo.TableColumnMetadata;
import com.questdb.cairo.sql.Function;
import com.questdb.cairo.sql.Record;
import com.questdb.griffin.BaseFunctionFactoryTest;
import com.questdb.griffin.FunctionFactory;
import com.questdb.griffin.FunctionParser;
import com.questdb.griffin.SqlException;
import com.questdb.griffin.engine.TestBinarySequence;
import com.questdb.griffin.engine.functions.bind.BindVariableService;
import com.questdb.griffin.engine.functions.bool.NotFunctionFactory;
import com.questdb.griffin.engine.functions.math.AddByteFunctionFactory;
import com.questdb.griffin.engine.functions.math.AddDoubleFunctionFactory;
import com.questdb.griffin.engine.functions.math.AddFloatFunctionFactory;
import com.questdb.griffin.engine.functions.math.AddIntFunctionFactory;
import com.questdb.griffin.engine.functions.math.AddLongFunctionFactory;
import com.questdb.griffin.engine.functions.math.AddShortFunctionFactory;
import com.questdb.griffin.engine.functions.math.SubIntFunctionFactory;
import com.questdb.griffin.engine.functions.str.LengthBinFunctionFactory;
import com.questdb.griffin.engine.functions.str.LengthStrFunctionFactory;
import com.questdb.griffin.engine.functions.str.SubStrFunctionFactory;
import com.questdb.griffin.engine.functions.str.ToCharBinFunctionFactory;
import com.questdb.griffin.engine.functions.str.ToCharDateFunctionFactory;
import com.questdb.griffin.engine.functions.str.ToCharTimestampFunctionFactory;
import com.questdb.std.BinarySequence;
import com.questdb.std.NumericException;
import com.questdb.std.ObjList;
import com.questdb.std.Rnd;
import com.questdb.std.time.DateFormatUtils;
import com.questdb.test.tools.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class BindVariablesTest
extends BaseFunctionFactoryTest {
    private static final FunctionBuilder builder = new FunctionBuilder();
    private static final BindVariableService bindVariableService = sqlExecutionContext.getBindVariableService();

    @Test
    public void testAmbiguousCall() throws SqlException {
        bindVariableService.setDate((CharSequence)"xyz", 0L);
        Function func = this.expr("to_char(:xyz, 'yyyy-MM')").withFunction((FunctionFactory)new ToCharDateFunctionFactory()).withFunction((FunctionFactory)new ToCharTimestampFunctionFactory()).$();
        func.init(null, bindVariableService);
        TestUtils.assertEquals((CharSequence)"1970-01", func.getStr(builder.getRecord()));
    }

    @Test
    public void testBin() throws SqlException {
        Rnd rnd = new Rnd();
        TestBinarySequence sequence = new TestBinarySequence();
        sequence.of(rnd.nextBytes(256));
        bindVariableService.setBin((CharSequence)"x", (BinarySequence)sequence);
        Function func = this.expr("to_char(:x)").withFunction((FunctionFactory)new ToCharBinFunctionFactory()).withFunction((FunctionFactory)new ToCharTimestampFunctionFactory()).$();
        func.init(null, bindVariableService);
        Function func2 = this.expr("length(:x)").withFunction((FunctionFactory)new LengthBinFunctionFactory()).$();
        func2.init(null, bindVariableService);
        TestUtils.assertEquals((CharSequence)"00000000 56 54 4a 57 43 50 53 57 48 59 52 58 50 45 48 4e\n00000010 52 58 47 5a 53 58 55 58 49 42 42 54 47 50 47 57\n00000020 46 46 59 55 44 45 59 59 51 45 48 42 48 46 4f 57\n00000030 4c 50 44 58 59 53 42 45 4f 55 4f 4a 53 48 52 55\n00000040 45 44 52 51 51 55 4c 4f 46 4a 47 45 54 4a 52 53\n00000050 5a 53 52 59 52 46 42 56 54 4d 48 47 4f 4f 5a 5a\n00000060 56 44 5a 4a 4d 59 49 43 43 58 5a 4f 55 49 43 57\n00000070 45 4b 47 48 56 55 56 53 44 4f 54 53 45 44 59 59\n00000080 43 54 47 51 4f 4c 59 58 57 43 4b 59 4c 53 55 57\n00000090 44 53 57 55 47 53 48 4f 4c 4e 56 54 49 51 42 5a\n000000a0 58 49 4f 56 49 4b 4a 53 4d 53 53 55 51 53 52 4c\n000000b0 54 4b 56 56 53 4a 4f 4a 49 50 48 5a 45 50 49 48\n000000c0 56 4c 54 4f 56 4c 4a 55 4d 4c 47 4c 48 4d 4c 4c\n000000d0 45 4f 59 50 48 52 49 50 5a 49 4d 4e 5a 5a 52 4d\n000000e0 46 4d 42 45 5a 47 48 57 56 44 4b 46 4c 4f 50 4a\n000000f0 4f 58 50 4b 52 47 49 49 48 59 48 42 4f 51 4d 59", func.getStr(builder.getRecord()));
        Assert.assertEquals((long)256L, (long)func2.getLong(builder.getRecord()));
        sequence.of(rnd.nextBytes(16));
        bindVariableService.setBin((CharSequence)"x", (BinarySequence)sequence);
        TestUtils.assertEquals((CharSequence)"00000000 53 53 4d 50 47 4c 55 4f 48 4e 5a 48 5a 53 51 4c", func.getStr(builder.getRecord()));
        bindVariableService.setBin((CharSequence)"x", (BinarySequence)new TestBinarySequence().of(rnd.nextBytes(24)));
        TestUtils.assertEquals((CharSequence)"00000000 44 47 4c 4f 47 49 46 4f 55 53 5a 4d 5a 56 51 45\n00000010 42 4e 44 43 51 43 45 48", func.getStr(builder.getRecord()));
    }

    @Test
    public void testBoolean() throws SqlException {
        bindVariableService.setBoolean((CharSequence)"xyz", false);
        Function func = this.expr("not :xyz").withFunction((FunctionFactory)new NotFunctionFactory()).$();
        func.init(null, bindVariableService);
        Assert.assertTrue((boolean)func.getBool(builder.getRecord()));
        bindVariableService.setBoolean((CharSequence)"xyz", true);
        Assert.assertFalse((boolean)func.getBool(builder.getRecord()));
    }

    @Test
    public void testByte() throws SqlException {
        bindVariableService.setByte((CharSequence)"xyz", (byte)8);
        Function func = this.expr("b + :xyz").withFunction((FunctionFactory)new AddByteFunctionFactory()).withColumn("b", 1, (byte)22).$();
        func.init(null, bindVariableService);
        Assert.assertEquals((long)30L, (long)func.getByte(builder.getRecord()));
        bindVariableService.setByte((CharSequence)"xyz", (byte)10);
        Assert.assertEquals((long)32L, (long)func.getByte(builder.getRecord()));
    }

    @Test
    public void testDate() throws SqlException, NumericException {
        bindVariableService.setDate((CharSequence)"xyz", DateFormatUtils.parseDateTime((CharSequence)"2015-04-10T10:00:00.000Z"));
        Function func = this.expr("to_char(:xyz, 'yyyy-MM')").withFunction((FunctionFactory)new ToCharDateFunctionFactory()).$();
        func.init(null, bindVariableService);
        TestUtils.assertEquals((CharSequence)"2015-04", func.getStr(builder.getRecord()));
        bindVariableService.setDate((CharSequence)"xyz", DateFormatUtils.parseDateTime((CharSequence)"2015-08-10T10:00:00.000Z"));
        TestUtils.assertEquals((CharSequence)"2015-08", func.getStr(builder.getRecord()));
    }

    @Test
    public void testDouble() throws SqlException {
        bindVariableService.setDouble((CharSequence)"xyz", 7.98821);
        Function func = this.expr("a + :xyz").withFunction((FunctionFactory)new AddDoubleFunctionFactory()).withColumn("a", 6, 25.1).$();
        func.init(null, bindVariableService);
        Assert.assertEquals((double)33.08821, (double)func.getDouble(builder.getRecord()), (double)1.0E-5);
        bindVariableService.setDouble((CharSequence)"xyz", 0.12311);
        Assert.assertEquals((double)25.22311, (double)func.getDouble(builder.getRecord()), (double)1.0E-5);
    }

    @Test
    public void testFloat() throws SqlException {
        bindVariableService.setFloat((CharSequence)"xyz", 7.6f);
        Function func = this.expr("a + :xyz").withFunction((FunctionFactory)new AddFloatFunctionFactory()).withColumn("a", 5, Float.valueOf(25.1f)).$();
        func.init(null, bindVariableService);
        Assert.assertEquals((float)32.7f, (float)func.getFloat(builder.getRecord()), (float)0.001f);
        bindVariableService.setFloat((CharSequence)"xyz", 0.78f);
        func.init(null, bindVariableService);
        Assert.assertEquals((float)25.88f, (float)func.getFloat(builder.getRecord()), (float)0.001f);
        func.close();
    }

    @Test
    public void testInt() throws SqlException {
        bindVariableService.setInt((CharSequence)"xyz", 10);
        bindVariableService.setInt((CharSequence)"zz", 5);
        Function func = this.expr("a + :xyz + :xyz - :zz").withFunction((FunctionFactory)new AddIntFunctionFactory()).withFunction((FunctionFactory)new SubIntFunctionFactory()).withColumn("a", 3, 22).$();
        func.init(null, bindVariableService);
        Assert.assertEquals((long)37L, (long)func.getInt(builder.getRecord()));
        bindVariableService.setInt((CharSequence)"zz", 8);
        Assert.assertEquals((long)34L, (long)func.getInt(builder.getRecord()));
    }

    @Test
    public void testLong() throws SqlException {
        bindVariableService.setLong((CharSequence)"xyz", 9L);
        Function func = this.expr("a + :xyz").withFunction((FunctionFactory)new AddLongFunctionFactory()).withColumn("a", 4, 22L).$();
        func.init(null, bindVariableService);
        Assert.assertEquals((long)31L, (long)func.getLong(builder.getRecord()));
        bindVariableService.setLong((CharSequence)"xyz", 11L);
        Assert.assertEquals((long)33L, (long)func.getLong(builder.getRecord()));
    }

    @Test
    public void testShort() throws SqlException {
        bindVariableService.setShort((CharSequence)"xyz", (short)8);
        Function func = this.expr("b + :xyz").withFunction((FunctionFactory)new AddShortFunctionFactory()).withColumn("b", 2, (short)22).$();
        func.init(null, bindVariableService);
        Assert.assertEquals((long)30L, (long)func.getShort(builder.getRecord()));
        bindVariableService.setShort((CharSequence)"xyz", (short)33);
        Assert.assertEquals((long)55L, (long)func.getShort(builder.getRecord()));
    }

    @Test
    public void testStr() throws SqlException {
        bindVariableService.setStr((CharSequence)"str", (CharSequence)"abc");
        Function func = this.expr("length(:str)").withFunction((FunctionFactory)new LengthStrFunctionFactory()).$();
        func.init(null, bindVariableService);
        Assert.assertEquals((long)3L, (long)func.getInt(builder.getRecord()));
        bindVariableService.setStr((CharSequence)"str", (CharSequence)"hello");
        Assert.assertEquals((long)5L, (long)func.getInt(builder.getRecord()));
    }

    @Test
    public void testStr2() throws SqlException {
        bindVariableService.setStr((CharSequence)"str", (CharSequence)"abcd");
        bindVariableService.setInt((CharSequence)"start", 1);
        Function func = this.expr("substr(:str, :start)").withFunction((FunctionFactory)new SubStrFunctionFactory()).$();
        func.init(null, bindVariableService);
        TestUtils.assertEquals((CharSequence)"bcd", func.getStr(builder.getRecord()));
    }

    @Test
    public void testTimestamp() throws SqlException, NumericException {
        bindVariableService.setTimestamp((CharSequence)"xyz", com.questdb.std.microtime.DateFormatUtils.parseDateTime((CharSequence)"2015-04-10T10:00:00.000Z"));
        Function func = this.expr("to_char(:xyz, 'yyyy-MM')").withFunction((FunctionFactory)new ToCharTimestampFunctionFactory()).$();
        func.init(null, bindVariableService);
        TestUtils.assertEquals((CharSequence)"2015-04", func.getStr(builder.getRecord()));
        bindVariableService.setTimestamp((CharSequence)"xyz", com.questdb.std.microtime.DateFormatUtils.parseDateTime((CharSequence)"2015-08-10T10:00:00.000Z"));
        TestUtils.assertEquals((CharSequence)"2015-08", func.getStr(builder.getRecord()));
    }

    @Test
    public void testUndefined() {
        try {
            this.expr("to_char(:xyz, 'yyyy-MM')").withFunction((FunctionFactory)new ToCharDateFunctionFactory()).withFunction((FunctionFactory)new ToCharTimestampFunctionFactory()).$();
        }
        catch (SqlException e) {
            Assert.assertEquals((long)8L, (long)e.getPosition());
            TestUtils.assertContains(e.getMessage(), "undefined bind variable: :xyz");
        }
    }

    private FunctionBuilder expr(String expression) {
        return BindVariablesTest.builder.withExpression(expression);
    }

    private static class FunctionBuilder {
        final ObjList<Object> columnValues = new ObjList();
        final GenericRecordMetadata metadata = new GenericRecordMetadata();
        final Record record = new Record(){

            public byte getByte(int col) {
                return (Byte)columnValues.get(col);
            }

            public double getDouble(int col) {
                return (Double)columnValues.get(col);
            }

            public float getFloat(int col) {
                return ((Float)columnValues.get(col)).floatValue();
            }

            public int getInt(int col) {
                return (Integer)columnValues.get(col);
            }

            public long getLong(int col) {
                return (Long)columnValues.get(col);
            }

            public short getShort(int col) {
                return (Short)columnValues.get(col);
            }
        };
        String expression;

        private FunctionBuilder() {
        }

        private Function $() throws SqlException {
            return BindVariablesTest.parseFunction(this.expression, this.metadata, new FunctionParser(configuration, (Iterable)functions));
        }

        Record getRecord() {
            return this.record;
        }

        private FunctionBuilder withColumn(String name, int type, Object value) {
            this.metadata.add(new TableColumnMetadata(name, type));
            this.columnValues.add(value);
            return this;
        }

        private FunctionBuilder withExpression(String expression) {
            functions.clear();
            this.expression = expression;
            this.columnValues.clear();
            this.metadata.clear();
            return this;
        }

        private FunctionBuilder withFunction(FunctionFactory functionFactory) {
            functions.add(functionFactory);
            return this;
        }
    }
}

