/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.griffin.engine.functions.bind;

import com.questdb.griffin.SqlException;
import com.questdb.griffin.engine.functions.bind.BindVariableService;
import com.questdb.test.tools.TestUtils;
import org.junit.Before;
import org.junit.Test;

public class BindVariableServiceTest {
    private static final BindVariableService bindVariableService = new BindVariableService();

    @Before
    public void setUp() {
        bindVariableService.clear();
    }

    @Test
    public void testBinOverride() throws SqlException {
        bindVariableService.setLong((CharSequence)"a", 10L);
        try {
            bindVariableService.setBin((CharSequence)"a", null);
        }
        catch (SqlException e) {
            TestUtils.assertContains(e.getMessage(), "bind variable 'a' is already defined as LONG");
        }
    }

    @Test
    public void testBooleanOverride() throws SqlException {
        bindVariableService.setLong((CharSequence)"a", 10L);
        try {
            bindVariableService.setBoolean((CharSequence)"a", false);
        }
        catch (SqlException e) {
            TestUtils.assertContains(e.getMessage(), "bind variable 'a' is already defined as LONG");
        }
    }

    @Test
    public void testByteOverride() throws SqlException {
        bindVariableService.setLong((CharSequence)"a", 10L);
        try {
            bindVariableService.setByte((CharSequence)"a", (byte)5);
        }
        catch (SqlException e) {
            TestUtils.assertContains(e.getMessage(), "bind variable 'a' is already defined as LONG");
        }
    }

    @Test
    public void testDateOverride() throws SqlException {
        bindVariableService.setLong((CharSequence)"a", 10L);
        try {
            bindVariableService.setDate((CharSequence)"a", 5L);
        }
        catch (SqlException e) {
            TestUtils.assertContains(e.getMessage(), "bind variable 'a' is already defined as LONG");
        }
    }

    @Test
    public void testDoubleOverride() throws SqlException {
        bindVariableService.setInt((CharSequence)"a", 10);
        try {
            bindVariableService.setDouble((CharSequence)"a", 5.4);
        }
        catch (SqlException e) {
            TestUtils.assertContains(e.getMessage(), "bind variable 'a' is already defined as INT");
        }
    }

    @Test
    public void testFloatOverride() throws SqlException {
        bindVariableService.setLong((CharSequence)"a", 10L);
        try {
            bindVariableService.setFloat((CharSequence)"a", 5.0f);
        }
        catch (SqlException e) {
            TestUtils.assertContains(e.getMessage(), "bind variable 'a' is already defined as LONG");
        }
    }

    @Test
    public void testIntOverride() throws SqlException {
        bindVariableService.setLong((CharSequence)"a", 10L);
        try {
            bindVariableService.setInt((CharSequence)"a", 5);
        }
        catch (SqlException e) {
            TestUtils.assertContains(e.getMessage(), "bind variable 'a' is already defined as LONG");
        }
    }

    @Test
    public void testLongOverride() throws SqlException {
        bindVariableService.setInt((CharSequence)"a", 10);
        try {
            bindVariableService.setLong((CharSequence)"a", 5L);
        }
        catch (SqlException e) {
            TestUtils.assertContains(e.getMessage(), "bind variable 'a' is already defined as INT");
        }
    }

    @Test
    public void testShortOverride() throws SqlException {
        bindVariableService.setLong((CharSequence)"a", 10L);
        try {
            bindVariableService.setShort((CharSequence)"a", (short)5);
        }
        catch (SqlException e) {
            TestUtils.assertContains(e.getMessage(), "bind variable 'a' is already defined as LONG");
        }
    }

    @Test
    public void testStrOverride() throws SqlException {
        bindVariableService.setLong((CharSequence)"a", 10L);
        try {
            bindVariableService.setStr((CharSequence)"a", (CharSequence)"ok");
        }
        catch (SqlException e) {
            TestUtils.assertContains(e.getMessage(), "bind variable 'a' is already defined as LONG");
        }
    }

    @Test
    public void testTimestampOverride() throws SqlException {
        bindVariableService.setLong((CharSequence)"a", 10L);
        try {
            bindVariableService.setTimestamp((CharSequence)"a", 5L);
        }
        catch (SqlException e) {
            TestUtils.assertContains(e.getMessage(), "bind variable 'a' is already defined as LONG");
        }
    }
}

