/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.griffin.engine.functions;

import com.questdb.cairo.ArrayColumnTypes;
import com.questdb.cairo.map.MapValue;
import com.questdb.cairo.sql.Function;
import com.questdb.cairo.sql.Record;
import com.questdb.griffin.engine.functions.DoubleFunction;
import com.questdb.griffin.engine.functions.GroupByFunction;
import org.jetbrains.annotations.NotNull;

public class TestSumDoubleGroupByFunction
extends DoubleFunction
implements GroupByFunction {
    private final Function value1;
    private int valueIndex;

    public TestSumDoubleGroupByFunction(int position, @NotNull Function value1, @NotNull Function value2) {
        super(position);
        value2.getDouble(null);
        this.value1 = value1;
    }

    public void computeFirst(MapValue mapValue, Record record) {
        mapValue.putDouble(this.valueIndex, this.value1.getDouble(record));
    }

    public void computeNext(MapValue mapValue, Record record) {
        mapValue.putDouble(this.valueIndex, mapValue.getDouble(this.valueIndex) + this.value1.getDouble(record));
    }

    public void pushValueTypes(ArrayColumnTypes columnTypes) {
        this.valueIndex = columnTypes.getColumnCount();
        columnTypes.add(6);
    }

    public void setDouble(MapValue mapValue, double value) {
        mapValue.putDouble(this.valueIndex, value);
    }

    public void setNull(MapValue mapValue) {
        mapValue.putDouble(this.valueIndex, Double.NaN);
    }

    public double getDouble(Record rec) {
        return rec.getDouble(this.valueIndex);
    }
}

