/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.griffin.engine;

import com.questdb.griffin.engine.table.LongTreeSet;
import com.questdb.std.LongList;
import com.questdb.std.Rnd;
import com.questdb.test.tools.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class LongTreeSetTest {
    @Test
    public void testDuplicateValues() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try (LongTreeSet set = new LongTreeSet(1024);){
                set.put(1L);
                set.put(2L);
                set.put(2L);
                set.put(3L);
                set.put(4L);
                set.put(4L);
                set.put(5L);
                set.put(5L);
                set.put(5L);
                LongTreeSet.TreeCursor cursor = set.getCursor();
                LongList ll = new LongList();
                while (cursor.hasNext()) {
                    ll.add(cursor.next());
                }
                TestUtils.assertEquals((CharSequence)"[1,2,3,4,5]", ll.toString());
            }
        });
    }

    @Test
    public void testSimple() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try (LongTreeSet set = new LongTreeSet(0x100000);){
                this.doTestSimple(set);
                set.clear();
                this.doTestSimple(set);
            }
        });
    }

    private void doTestSimple(LongTreeSet set) {
        long l;
        int i;
        Rnd rnd = new Rnd();
        LongList ll = new LongList();
        int n = 10000;
        for (i = 0; i < n; ++i) {
            long l2 = rnd.nextLong();
            set.put(l2);
            ll.add(l2);
        }
        ll.sort();
        i = 0;
        LongTreeSet.TreeCursor cursor = set.getCursor();
        while (cursor.hasNext()) {
            l = cursor.next();
            Assert.assertEquals((long)ll.getQuick(i++), (long)l);
        }
        Assert.assertEquals((long)n, (long)i);
        cursor.toTop();
        i = 0;
        while (cursor.hasNext()) {
            l = cursor.next();
            Assert.assertEquals((long)ll.getQuick(i++), (long)l);
        }
    }
}

