/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.griffin.engine;

import com.questdb.cairo.GenericRecordMetadata;
import com.questdb.cairo.TableColumnMetadata;
import com.questdb.cairo.sql.Function;
import com.questdb.cairo.sql.Record;
import com.questdb.griffin.BaseFunctionFactoryTest;
import com.questdb.griffin.FunctionFactory;
import com.questdb.griffin.FunctionParser;
import com.questdb.griffin.OperatorExpression;
import com.questdb.griffin.SqlException;
import com.questdb.griffin.engine.TestBinarySequence;
import com.questdb.griffin.engine.functions.cast.ToByteIntFunctionFactory;
import com.questdb.griffin.engine.functions.cast.ToDateLongFunctionFactory;
import com.questdb.griffin.engine.functions.cast.ToShortIntFunctionFactory;
import com.questdb.griffin.engine.functions.cast.ToTimestampLongFunctionFactory;
import com.questdb.std.BinarySequence;
import com.questdb.std.str.CharSink;
import com.questdb.std.str.StringSink;
import com.questdb.test.tools.TestUtils;
import org.junit.Assert;

public abstract class AbstractFunctionFactoryTest
extends BaseFunctionFactoryTest {
    private static int toTimestampRefs = 0;
    private static int toDateRefs = 0;
    private static int toShortRefs = 0;
    private static int toByteRefs = 0;
    private FunctionFactory factory;

    public void assertFailure(int expectedPosition, CharSequence expectedMsg, Object ... args) {
        this.assertFailure(false, expectedPosition, expectedMsg, args);
    }

    public void assertFailure(boolean forceConstant, int expectedPosition, CharSequence expectedMsg, Object ... args) {
        try {
            this.callCustomised(forceConstant, args);
            Assert.fail();
        }
        catch (SqlException e) {
            Assert.assertEquals((long)expectedPosition, (long)e.getPosition());
            TestUtils.assertContains(e.getMessage(), expectedMsg);
        }
    }

    protected void addExtraFunctions() {
    }

    protected Invocation call(Object ... args) throws SqlException {
        return this.callCustomised(false, args);
    }

    protected Invocation callCustomised(boolean forceConstant, Object ... args) throws SqlException {
        int argCount;
        boolean constVarArg;
        boolean hasVarArg;
        AbstractFunctionFactoryTest.setUp2();
        toShortRefs = 0;
        toByteRefs = 0;
        toTimestampRefs = 0;
        toDateRefs = 0;
        FunctionFactory functionFactory = this.getFactory0();
        String signature = functionFactory.getSignature();
        int pos = FunctionParser.validateSignatureAndGetNameSeparator((String)signature);
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        String name = signature.substring(0, pos);
        if (signature.indexOf(118, pos) != -1) {
            hasVarArg = true;
            constVarArg = true;
        } else if (signature.indexOf(86, pos) != -1) {
            hasVarArg = true;
            constVarArg = false;
        } else {
            hasVarArg = false;
            constVarArg = false;
        }
        if (hasVarArg) {
            argCount = signature.length() - pos - 3;
            Assert.assertTrue((args.length >= argCount ? 1 : 0) != 0);
        } else {
            argCount = signature.length() - pos - 2;
            Assert.assertEquals((String)"Invalid number of arguments", (long)argCount, (long)args.length);
        }
        StringSink expression1 = new StringSink();
        StringSink expression2 = new StringSink();
        boolean setOperation = OperatorExpression.getOperatorType((CharSequence)name) == 3;
        boolean operator = OperatorExpression.isOperator((CharSequence)name);
        if (operator && !setOperation) {
            switch (argCount) {
                case 0: {
                    expression1.put((CharSequence)name);
                    expression2.put((CharSequence)name);
                    break;
                }
                case 1: {
                    expression1.put((CharSequence)name).put(' ');
                    expression2.put((CharSequence)name).put(' ');
                    this.printArgument(signature, pos, forceConstant, metadata, true, constVarArg, expression1, expression2, 0, args[0]);
                    break;
                }
                default: {
                    this.printArgument(signature, pos, forceConstant, metadata, true, constVarArg, expression1, expression2, 0, args[0]);
                    expression1.put(' ').put((CharSequence)name).put(' ');
                    expression2.put(' ').put((CharSequence)name).put(' ');
                    this.printArgument(signature, pos, forceConstant, metadata, true, constVarArg, expression1, expression2, 1, args[1]);
                    break;
                }
            }
        } else {
            if (!setOperation) {
                expression1.put((CharSequence)name).put('(');
                expression2.put((CharSequence)name).put('(');
            }
            int n = args.length;
            for (int i = 0; i < n; ++i) {
                if (setOperation && i > 1 || !setOperation && i > 0) {
                    expression1.put(',');
                    expression2.put(',');
                }
                this.printArgument(signature, pos, forceConstant, metadata, i < argCount, constVarArg, expression1, expression2, i, args[i]);
                if (i != 0 || !setOperation) continue;
                expression1.put(' ').put((CharSequence)name).put(' ').put('(');
                expression2.put(' ').put((CharSequence)name).put(' ').put('(');
            }
            expression1.put(')');
            expression2.put(')');
        }
        functions.add(functionFactory);
        if (toTimestampRefs > 0) {
            functions.add(new ToTimestampLongFunctionFactory());
        }
        if (toDateRefs > 0) {
            functions.add(new ToDateLongFunctionFactory());
        }
        if (toShortRefs > 0) {
            functions.add(new ToShortIntFunctionFactory());
        }
        if (toByteRefs > 0) {
            functions.add(new ToByteIntFunctionFactory());
        }
        this.addExtraFunctions();
        FunctionParser functionParser = new FunctionParser(configuration, (Iterable)functions);
        return new Invocation(AbstractFunctionFactoryTest.parseFunction((CharSequence)expression1, metadata, functionParser), AbstractFunctionFactoryTest.parseFunction((CharSequence)expression2, metadata, functionParser), new TestRecord(args));
    }

    private int getArgType(Object arg) {
        if (arg == null) {
            return 7;
        }
        if (arg instanceof CharSequence) {
            return 7;
        }
        if (arg instanceof Integer) {
            return 3;
        }
        if (arg instanceof Double) {
            return 6;
        }
        if (arg instanceof Long) {
            return 4;
        }
        Assert.fail((String)("Unsupported type: " + arg.getClass()));
        return -1;
    }

    private FunctionFactory getFactory0() {
        if (this.factory == null) {
            this.factory = this.getFunctionFactory();
        }
        return this.factory;
    }

    protected abstract FunctionFactory getFunctionFactory();

    private boolean isNegative(int argType, Object arg) {
        switch (argType) {
            case 3: {
                return (Integer)arg < 0 && (Integer)arg != Integer.MIN_VALUE;
            }
            case 4: {
                return (Long)arg < 0L && (Long)arg != Long.MIN_VALUE;
            }
            case 2: {
                return (Integer)arg < 0;
            }
            case 1: {
                return (Integer)arg < 0;
            }
            case 6: {
                return (Double)arg < 0.0;
            }
            case 5: {
                return ((Float)arg).floatValue() < 0.0f;
            }
        }
        return false;
    }

    private void printArgument(CharSequence signature, int signatureTypeOffset, boolean forceConstant, GenericRecordMetadata metadata, boolean b, boolean constVarArg, StringSink expression1, StringSink expression2, int i, Object arg) {
        int argType;
        boolean constantArg;
        String columnName = "f" + i;
        if (b) {
            char typeChar = signature.charAt(signatureTypeOffset + i + 1);
            constantArg = Character.isLowerCase(typeChar);
            argType = FunctionParser.getArgType((char)typeChar);
        } else {
            constantArg = constVarArg;
            argType = this.getArgType(arg);
        }
        metadata.add(new TableColumnMetadata(columnName, argType));
        if (constantArg || forceConstant) {
            this.printConstant(argType, expression1, arg);
            this.printConstant(argType, expression2, arg);
        } else {
            expression1.put((CharSequence)columnName);
            if (argType == 8 || argType == 9 || this.isNegative(argType, arg)) {
                expression2.put((CharSequence)columnName);
            } else {
                this.printConstant(argType, expression2, arg);
            }
        }
    }

    private void printConstant(int type, StringSink sink, Object value) {
        switch (type) {
            case 7: 
            case 8: {
                if (value == null) {
                    sink.put((CharSequence)"null");
                    break;
                }
                sink.put('\'');
                sink.put((CharSequence)value);
                sink.put('\'');
                break;
            }
            case 3: {
                sink.put(((Integer)value).intValue());
                break;
            }
            case 0: {
                sink.put(((Boolean)value).booleanValue());
                break;
            }
            case 6: {
                sink.put(((Double)value).doubleValue(), 5);
                break;
            }
            case 5: {
                sink.put(((Float)value).floatValue(), 5);
                break;
            }
            case 4: {
                sink.put(((Long)value).longValue());
                break;
            }
            case 10: {
                sink.put((CharSequence)"to_date(").put(((Long)value).longValue()).put((CharSequence)")");
                ++toDateRefs;
                break;
            }
            case 12: {
                sink.put((CharSequence)"to_timestamp(").put(((Long)value).longValue()).put((CharSequence)")");
                ++toTimestampRefs;
                break;
            }
            case 2: {
                sink.put((CharSequence)"to_short(").put(((Integer)value).intValue()).put((CharSequence)")");
                ++toShortRefs;
                break;
            }
            default: {
                sink.put((CharSequence)"to_byte(").put(((Integer)value).intValue()).put((CharSequence)")");
                ++toByteRefs;
            }
        }
    }

    private static class TestRecord
    implements Record {
        private final Object[] args;
        private final TestBinarySequence byteSequence = new TestBinarySequence();

        public TestRecord(Object[] args) {
            this.args = args;
        }

        public BinarySequence getBin(int col) {
            Object o = this.args[col];
            if (o == null) {
                return null;
            }
            return this.byteSequence.of((byte[])o);
        }

        public boolean getBool(int col) {
            return (Boolean)this.args[col];
        }

        public byte getByte(int col) {
            return (byte)((Integer)this.args[col]).intValue();
        }

        public double getDouble(int col) {
            return (Double)this.args[col];
        }

        public CharSequence getStr(int col) {
            return (CharSequence)this.args[col];
        }

        public int getInt(int col) {
            return (Integer)this.args[col];
        }

        public long getLong(int col) {
            return (Long)this.args[col];
        }

        public short getShort(int col) {
            return (short)((Integer)this.args[col]).intValue();
        }

        public CharSequence getStrB(int col) {
            return (CharSequence)this.args[col];
        }

        public int getStrLen(int col) {
            Object o = this.args[col];
            return o != null ? ((CharSequence)o).length() : -1;
        }

        public CharSequence getSym(int col) {
            return (CharSequence)this.args[col];
        }
    }

    public static class Invocation {
        private final Function function1;
        private final Function function2;
        private final Record record;

        public Invocation(Function function1, Function function2, Record record) {
            this.function1 = function1;
            this.function2 = function2;
            this.record = record;
        }

        public void andAssert(boolean expected) {
            Assert.assertEquals((Object)expected, (Object)this.function1.getBool(this.record));
            Assert.assertEquals((Object)expected, (Object)this.function2.getBool(this.record));
        }

        public void andAssert(CharSequence expected) {
            if (this.function1.getType() == 7) {
                this.assertString(this.function1, expected);
                this.assertString(this.function2, expected);
            }
            this.closeFunctions();
        }

        public void andAssert(int expected) {
            Assert.assertEquals((long)expected, (long)this.function1.getInt(this.record));
            Assert.assertEquals((long)expected, (long)this.function2.getInt(this.record));
            this.closeFunctions();
        }

        public void andAssert(byte expected) {
            Assert.assertEquals((long)expected, (long)this.function1.getByte(this.record));
            Assert.assertEquals((long)expected, (long)this.function2.getByte(this.record));
            this.closeFunctions();
        }

        public void andAssert(short expected) {
            Assert.assertEquals((long)expected, (long)this.function1.getShort(this.record));
            Assert.assertEquals((long)expected, (long)this.function2.getShort(this.record));
            this.closeFunctions();
        }

        public void andAssert(long expected) {
            Assert.assertEquals((long)expected, (long)this.function1.getLong(this.record));
            Assert.assertEquals((long)expected, (long)this.function2.getLong(this.record));
            this.closeFunctions();
        }

        public void andAssert(double expected, double delta) {
            Assert.assertEquals((double)expected, (double)this.function1.getDouble(this.record), (double)delta);
            Assert.assertEquals((double)expected, (double)this.function2.getDouble(this.record), (double)delta);
            this.closeFunctions();
        }

        public void andAssertDate(long expected) {
            Assert.assertEquals((long)expected, (long)this.function1.getDate(this.record));
            Assert.assertEquals((long)expected, (long)this.function2.getDate(this.record));
            this.closeFunctions();
        }

        public void andAssertTimestamp(long expected) {
            Assert.assertEquals((long)expected, (long)this.function1.getTimestamp(this.record));
            Assert.assertEquals((long)expected, (long)this.function2.getTimestamp(this.record));
            this.closeFunctions();
        }

        public Function getFunction1() {
            return this.function1;
        }

        public Function getFunction2() {
            return this.function2;
        }

        public Record getRecord() {
            return this.record;
        }

        private void assertString(Function func, CharSequence expected) {
            if (expected == null) {
                Assert.assertNull((Object)func.getStr(this.record));
                Assert.assertNull((Object)func.getStrB(this.record));
                Assert.assertEquals((long)-1L, (long)func.getStrLen(this.record));
                sink.clear();
                func.getStr(this.record, (CharSink)sink);
                Assert.assertEquals((long)0L, (long)sink.length());
            } else {
                CharSequence a = func.getStr(this.record);
                CharSequence b = func.getStrB(this.record);
                if (!(func.isConstant() || a instanceof String && b instanceof String)) {
                    Assert.assertNotSame((Object)a, (Object)b);
                }
                TestUtils.assertEquals(expected, a);
                TestUtils.assertEquals(expected, b);
                TestUtils.assertEquals(expected, func.getStr(this.record));
                TestUtils.assertEquals(expected, func.getStrB(this.record));
                sink.clear();
                func.getStr(this.record, (CharSink)sink);
                TestUtils.assertEquals(expected, (CharSequence)sink);
                Assert.assertEquals((long)expected.length(), (long)func.getStrLen(this.record));
            }
        }

        private void closeFunctions() {
            this.function1.close();
            this.function2.close();
        }
    }
}

