/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.griffin;

import com.questdb.cairo.AbstractCairoTest;
import com.questdb.cairo.CairoTestUtils;
import com.questdb.cairo.Engine;
import com.questdb.cairo.TableModel;
import com.questdb.cairo.TableReader;
import com.questdb.cairo.sql.CairoEngine;
import com.questdb.cairo.sql.RecordMetadata;
import com.questdb.griffin.GriffinParserTestUtils;
import com.questdb.griffin.PostOrderTreeTraversalAlgo;
import com.questdb.griffin.RpnBuilder;
import com.questdb.griffin.SqlCompiler;
import com.questdb.griffin.SqlException;
import com.questdb.griffin.WhereClauseParser;
import com.questdb.griffin.model.ExpressionNode;
import com.questdb.griffin.model.IntrinsicModel;
import com.questdb.griffin.model.QueryModel;
import com.questdb.test.tools.TestUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class WhereClauseParserTest
extends AbstractCairoTest {
    private static final SqlCompiler compiler = new SqlCompiler((CairoEngine)new Engine(configuration), configuration);
    private static TableReader reader;
    private static TableReader noTimestampReader;
    private static TableReader unindexedReader;
    private static RecordMetadata metadata;
    private static RecordMetadata noTimestampMetadata;
    private static RecordMetadata unindexedMetadata;
    private final RpnBuilder rpn = new RpnBuilder();
    private final WhereClauseParser e = new WhereClauseParser();
    private final PostOrderTreeTraversalAlgo traversalAlgo = new PostOrderTreeTraversalAlgo();
    private final PostOrderTreeTraversalAlgo.Visitor rpnBuilderVisitor = this.rpn::onNode;
    private final QueryModel queryModel = QueryModel.FACTORY.newInstance();

    @BeforeClass
    public static void setUp2() {
        try (TableModel model = new TableModel(configuration, "x", 3);){
            model.col("sym", 8).indexed(true, 16).col("bid", 6).col("ask", 6).col("bidSize", 3).col("askSize", 3).col("mode", 8).indexed(true, 4).col("ex", 8).indexed(true, 4).timestamp();
            CairoTestUtils.create(model);
        }
        model = new TableModel(configuration, "y", 3);
        var1_1 = null;
        try {
            model.col("sym", 8).indexed(true, 16).col("bid", 6).col("ask", 6).col("bidSize", 3).col("askSize", 3).col("mode", 8).indexed(true, 4).col("ex", 8).indexed(true, 4);
            CairoTestUtils.create(model);
        }
        catch (Throwable throwable) {
            var1_1 = throwable;
            throw throwable;
        }
        finally {
            if (model != null) {
                if (var1_1 != null) {
                    try {
                        model.close();
                    }
                    catch (Throwable throwable) {
                        var1_1.addSuppressed(throwable);
                    }
                } else {
                    model.close();
                }
            }
        }
        model = new TableModel(configuration, "z", 3);
        var1_1 = null;
        try {
            model.col("sym", 8).col("bid", 6).col("ask", 6).col("bidSize", 3).col("askSize", 3).col("mode", 8).col("ex", 8).indexed(true, 4).timestamp();
            CairoTestUtils.create(model);
        }
        catch (Throwable throwable) {
            var1_1 = throwable;
            throw throwable;
        }
        finally {
            if (model != null) {
                if (var1_1 != null) {
                    try {
                        model.close();
                    }
                    catch (Throwable throwable) {
                        var1_1.addSuppressed(throwable);
                    }
                } else {
                    model.close();
                }
            }
        }
        reader = new TableReader(configuration, (CharSequence)"x");
        metadata = reader.getMetadata();
        noTimestampReader = new TableReader(configuration, (CharSequence)"y");
        noTimestampMetadata = noTimestampReader.getMetadata();
        unindexedReader = new TableReader(configuration, (CharSequence)"z");
        unindexedMetadata = unindexedReader.getMetadata();
    }

    @AfterClass
    public static void tearDown2() {
        reader.close();
        noTimestampReader.close();
        unindexedReader.close();
    }

    @Test
    public void testAndBranchWithNonIndexedField() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp in (\"2014-01-01T12:30:00.000Z\", \"2014-01-02T12:30:00.000Z\") and bid > 100");
        TestUtils.assertEquals((CharSequence)"[{lo=2014-01-01T12:30:00.000000Z, hi=2014-01-02T12:30:00.000000Z}]", GriffinParserTestUtils.intervalToString(m.intervals));
        this.assertFilter(m, "100bid>");
    }

    @Test
    public void testBadCountInInterval() {
        try {
            this.modelOf("timestamp = '2015-02-23T10:00:55.000Z;30m;10;z'");
            Assert.fail();
        }
        catch (SqlException e) {
            Assert.assertEquals((long)12L, (long)e.getPosition());
        }
    }

    @Test
    public void testBadDate() {
        try {
            this.modelOf("timestamp = '2015-02-23T10:00:55.00z;30m'");
            Assert.fail();
        }
        catch (SqlException e) {
            Assert.assertEquals((long)12L, (long)e.getPosition());
        }
    }

    @Test
    public void testBadDateInGreater() {
        try {
            this.modelOf("'2014-0x-01T12:30:00.000Z' > timestamp");
            Assert.fail();
        }
        catch (SqlException e) {
            Assert.assertEquals((long)0L, (long)e.getPosition());
        }
    }

    @Test
    public void testBadDateInGreater2() {
        try {
            this.modelOf("timestamp > '2014-0x-01T12:30:00.000Z'");
            Assert.fail();
        }
        catch (SqlException e) {
            Assert.assertEquals((long)12L, (long)e.getPosition());
        }
    }

    @Test
    public void testBadDateInInterval() {
        try {
            this.modelOf("timestamp = '2014-0x-01T12:30:00.000Z'");
            Assert.fail();
        }
        catch (SqlException e) {
            Assert.assertEquals((long)12L, (long)e.getPosition());
        }
    }

    @Test
    public void testBadEndDate() {
        try {
            this.modelOf("timestamp in (\"2014-01-02T12:30:00.000Z\", \"2014-01Z\")");
            Assert.fail((String)"Exception expected");
        }
        catch (SqlException e) {
            TestUtils.assertContains(e.getMessage(), "Invalid date");
            Assert.assertEquals((long)42L, (long)e.getPosition());
        }
    }

    @Test
    public void testBadOperators() {
        this.testBadOperator(">");
        this.testBadOperator(">=");
        this.testBadOperator("<");
        this.testBadOperator("<=");
        this.testBadOperator("=");
        this.testBadOperator("!=");
    }

    @Test
    public void testBadPeriodInInterval() {
        try {
            this.modelOf("timestamp = '2015-02-23T10:00:55.000Z;30m;x;5'");
            Assert.fail();
        }
        catch (SqlException e) {
            Assert.assertEquals((long)12L, (long)e.getPosition());
        }
    }

    @Test
    public void testBadPeriodInInterval2() {
        try {
            this.modelOf("timestamp = '2015-02-23T10:00:55.000Z;30m;10x;5'");
            Assert.fail();
        }
        catch (SqlException e) {
            Assert.assertEquals((long)12L, (long)e.getPosition());
        }
    }

    @Test
    public void testBadRangeInInterval() {
        try {
            this.modelOf("timestamp = '2014-03-01T12:30:00.000Z;x'");
            Assert.fail();
        }
        catch (SqlException e) {
            Assert.assertEquals((long)12L, (long)e.getPosition());
        }
    }

    @Test
    public void testBadStartDate() {
        try {
            this.modelOf("timestamp in (\"2014-01Z\", \"2014-01-02T12:30:00.000Z\")");
            Assert.fail((String)"Exception expected");
        }
        catch (SqlException e) {
            TestUtils.assertContains(e.getMessage(), "Invalid date");
            Assert.assertEquals((long)14L, (long)e.getPosition());
        }
    }

    @Test
    public void testComplexInterval1() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp = '2015-02-23T10:00;2d'");
        TestUtils.assertEquals((CharSequence)"[{lo=2015-02-23T10:00:00.000000Z, hi=2015-02-25T10:00:59.999999Z}]", GriffinParserTestUtils.intervalToString(m.intervals));
        Assert.assertEquals((Object)"IntrinsicModel{keyValues=[], keyColumn='null', filter=null}", (Object)m.toString());
    }

    @Test
    public void testComplexInterval2() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp = '2015-02-23T10:00:55.000Z;7d'");
        TestUtils.assertEquals((CharSequence)"[{lo=2015-02-23T10:00:55.000000Z, hi=2015-03-02T10:00:55.000000Z}]", GriffinParserTestUtils.intervalToString(m.intervals));
        Assert.assertEquals((Object)"IntrinsicModel{keyValues=[], keyColumn='null', filter=null}", (Object)m.toString());
    }

    @Test
    public void testComplexInterval3() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp = '2015-02-23T10:00:55.000Z;15s'");
        TestUtils.assertEquals((CharSequence)"[{lo=2015-02-23T10:00:55.000000Z, hi=2015-02-23T10:01:10.000000Z}]", GriffinParserTestUtils.intervalToString(m.intervals));
        Assert.assertEquals((Object)"IntrinsicModel{keyValues=[], keyColumn='null', filter=null}", (Object)m.toString());
    }

    @Test
    public void testComplexInterval4() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp = '2015-02-23T10:00:55.000Z;30m'");
        TestUtils.assertEquals((CharSequence)"[{lo=2015-02-23T10:00:55.000000Z, hi=2015-02-23T10:30:55.000000Z}]", GriffinParserTestUtils.intervalToString(m.intervals));
        Assert.assertEquals((Object)"IntrinsicModel{keyValues=[], keyColumn='null', filter=null}", (Object)m.toString());
    }

    @Test
    public void testComplexInterval5() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp = '2015-02-23T10:00:55.000Z;30m' and timestamp != '2015-02-23T10:10:00.000Z'");
        TestUtils.assertEquals((CharSequence)"[{lo=2015-02-23T10:00:55.000000Z, hi=2015-02-23T10:09:59.999999Z},{lo=2015-02-23T10:10:00.000001Z, hi=2015-02-23T10:30:55.000000Z}]", GriffinParserTestUtils.intervalToString(m.intervals));
        Assert.assertEquals((Object)"IntrinsicModel{keyValues=[], keyColumn='null', filter=null}", (Object)m.toString());
    }

    @Test
    public void testConstVsLambda() throws Exception {
        IntrinsicModel m = this.modelOf("ex in (1,2) and sym in (select * from xyz)");
        TestUtils.assertEquals((CharSequence)"sym", m.keyColumn);
        Assert.assertNotNull((Object)m.keySubQuery);
        Assert.assertNotNull((Object)m.filter);
        TestUtils.assertEquals((CharSequence)"ex in (1,2)", GriffinParserTestUtils.toRpn(m.filter));
    }

    @Test
    public void testConstVsLambda2() throws Exception {
        IntrinsicModel m = this.modelOf("sym in (1,2) and sym in (select * from xyz)");
        TestUtils.assertEquals((CharSequence)"sym", m.keyColumn);
        Assert.assertNotNull((Object)m.keySubQuery);
        Assert.assertNotNull((Object)m.filter);
        TestUtils.assertEquals((CharSequence)"sym in (1,2)", GriffinParserTestUtils.toRpn(m.filter));
    }

    @Test
    public void testContradictingNullSearch() throws Exception {
        IntrinsicModel m = this.modelOf("sym = null and sym != null and ex != 'blah'");
        Assert.assertEquals((long)2L, (long)m.intrinsicValue);
        this.assertFilter(m, "'blah'ex!=");
        Assert.assertEquals((Object)"[]", (Object)m.keyValues.toString());
        Assert.assertEquals((Object)"[]", (Object)m.keyValuePositions.toString());
    }

    @Test
    public void testContradictingNullSearch2() throws Exception {
        IntrinsicModel m = this.modelOf("null = sym and null != sym and ex != 'blah'");
        Assert.assertEquals((long)2L, (long)m.intrinsicValue);
        this.assertFilter(m, "'blah'ex!=");
        Assert.assertEquals((Object)"[]", (Object)m.keyValues.toString());
        Assert.assertEquals((Object)"[]", (Object)m.keyValuePositions.toString());
    }

    @Test
    public void testDubiousEquals() throws Exception {
        IntrinsicModel m = this.modelOf("sum(ts) = sum(ts)");
        Assert.assertNull((Object)m.filter);
    }

    @Test
    public void testDubiousGreater() throws Exception {
        IntrinsicModel m = this.modelOf("ts > ts");
        Assert.assertEquals((long)2L, (long)m.intrinsicValue);
    }

    @Test
    public void testDubiousLess() throws Exception {
        IntrinsicModel m = this.modelOf("ts < ts");
        Assert.assertEquals((long)2L, (long)m.intrinsicValue);
    }

    @Test
    public void testDubiousNotEquals() throws Exception {
        IntrinsicModel m = this.modelOf("ts != ts");
        Assert.assertEquals((long)2L, (long)m.intrinsicValue);
    }

    @Test
    public void testEqualsChoiceOfColumns() throws Exception {
        IntrinsicModel m = this.modelOf("sym = 'X' and ex = 'Y'");
        this.assertFilter(m, "'Y'ex=");
        TestUtils.assertEquals((CharSequence)"sym", m.keyColumn);
        Assert.assertEquals((Object)"[X]", (Object)m.keyValues.toString());
    }

    @Test
    public void testEqualsChoiceOfColumns2() throws Exception {
        IntrinsicModel m = this.modelOf("sym = 'X' and ex = 'Y'");
        this.assertFilter(m, "'Y'ex=");
        TestUtils.assertEquals((CharSequence)"sym", m.keyColumn);
        Assert.assertEquals((Object)"[X]", (Object)m.keyValues.toString());
    }

    @Test
    public void testEqualsIndexedSearch() throws Exception {
        IntrinsicModel m = this.modelOf("sym ='X' and bid > 100.05");
        this.assertFilter(m, "100.05bid>");
        TestUtils.assertEquals((CharSequence)"sym", m.keyColumn);
        Assert.assertEquals((Object)"[X]", (Object)m.keyValues.toString());
    }

    @Test
    public void testEqualsInvalidColumn() {
        try {
            this.modelOf("sym = 'X' and x = 'Y'");
            Assert.fail((String)"Exception expected");
        }
        catch (SqlException e) {
            Assert.assertEquals((long)14L, (long)e.getPosition());
        }
    }

    @Test
    public void testEqualsNull() throws Exception {
        IntrinsicModel m = this.modelOf("sym = null");
        TestUtils.assertEquals((CharSequence)"sym", m.keyColumn);
        Assert.assertEquals((Object)"[null]", (Object)m.keyValues.toString());
    }

    @Test
    public void testEqualsOverlapWithIn() throws Exception {
        IntrinsicModel m = this.modelOf("sym in ('x','y') and sym = 'y'");
        Assert.assertNull((Object)m.filter);
        Assert.assertEquals((Object)"[y]", (Object)m.keyValues.toString());
        Assert.assertEquals((Object)"[12]", (Object)m.keyValuePositions.toString());
    }

    @Test
    public void testEqualsOverlapWithIn2() throws Exception {
        IntrinsicModel m = this.modelOf("sym = 'y' and sym in ('x','y')");
        Assert.assertNull((Object)m.filter);
        Assert.assertEquals((Object)"[y]", (Object)m.keyValues.toString());
    }

    @Test
    public void testEqualsOverlapWithIn3() throws Exception {
        IntrinsicModel m = this.modelOf("sym in ('x','y') and sym = 'y'", "ex");
        TestUtils.assertEquals((CharSequence)"'y'sym='y''x'syminand", this.toRpn(m.filter));
        Assert.assertEquals((Object)"[]", (Object)m.keyValues.toString());
        Assert.assertEquals((Object)"[]", (Object)m.keyValuePositions.toString());
    }

    @Test
    public void testEqualsZeroOverlapWithIn() throws Exception {
        IntrinsicModel m = this.modelOf("sym in ('x','y') and sym = 'z'");
        Assert.assertEquals((long)2L, (long)m.intrinsicValue);
    }

    @Test
    public void testEqualsZeroOverlapWithIn2() throws Exception {
        IntrinsicModel m = this.modelOf("sym = 'z' and sym in ('x','y')");
        Assert.assertEquals((long)2L, (long)m.intrinsicValue);
    }

    @Test
    public void testExactDate() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp = '2015-05-10T15:03:10.000Z' and timestamp < '2015-05-11T08:00:55.000Z'");
        TestUtils.assertEquals((CharSequence)"[{lo=2015-05-10T15:03:10.000000Z, hi=2015-05-10T15:03:10.000000Z}]", GriffinParserTestUtils.intervalToString(m.intervals));
        Assert.assertNull((Object)m.filter);
    }

    @Test
    public void testExactDateVsInterval() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp = '2015-05-10T15:03:10.000Z' and timestamp = '2015-05-11'");
        Assert.assertEquals((long)2L, (long)m.intrinsicValue);
        Assert.assertNull((Object)m.filter);
    }

    @Test
    public void testFilterAndInterval() throws Exception {
        IntrinsicModel m = this.modelOf("bid > 100 and timestamp in (\"2014-01-01T12:30:00.000Z\", \"2014-01-02T12:30:00.000Z\")");
        TestUtils.assertEquals((CharSequence)"[{lo=2014-01-01T12:30:00.000000Z, hi=2014-01-02T12:30:00.000000Z}]", GriffinParserTestUtils.intervalToString(m.intervals));
        this.assertFilter(m, "100bid>");
    }

    @Test
    public void testFilterMultipleKeysAndInterval() throws Exception {
        IntrinsicModel m = this.modelOf("sym in (\"a\", \"b\", \"c\") and timestamp in (\"2014-01-01T12:30:00.000Z\", \"2014-01-02T12:30:00.000Z\")");
        TestUtils.assertEquals((CharSequence)"[{lo=2014-01-01T12:30:00.000000Z, hi=2014-01-02T12:30:00.000000Z}]", GriffinParserTestUtils.intervalToString(m.intervals));
        TestUtils.assertEquals((CharSequence)"sym", m.keyColumn);
        Assert.assertEquals((Object)"[a,b,c]", (Object)m.keyValues.toString());
        Assert.assertEquals((Object)"[8,13,18]", (Object)m.keyValuePositions.toString());
        Assert.assertNull((Object)m.filter);
    }

    @Test
    public void testFilterOnIndexedFieldAndInterval() throws Exception {
        IntrinsicModel m = this.modelOf("sym in ('a') and timestamp in (\"2014-01-01T12:30:00.000Z\", \"2014-01-02T12:30:00.000Z\")");
        TestUtils.assertEquals((CharSequence)"[{lo=2014-01-01T12:30:00.000000Z, hi=2014-01-02T12:30:00.000000Z}]", GriffinParserTestUtils.intervalToString(m.intervals));
        TestUtils.assertEquals((CharSequence)"sym", m.keyColumn);
        Assert.assertEquals((Object)"[a]", (Object)m.keyValues.toString());
        Assert.assertNull((Object)m.filter);
    }

    @Test
    public void testFilterOrInterval() throws Exception {
        IntrinsicModel m = this.modelOf("bid > 100 or timestamp in (\"2014-01-01T12:30:00.000Z\", \"2014-01-02T12:30:00.000Z\")");
        Assert.assertNull((Object)m.intervals);
        this.assertFilter(m, "\"2014-01-02T12:30:00.000Z\"\"2014-01-01T12:30:00.000Z\"timestampin100bid>or");
    }

    @Test
    public void testInNull() throws Exception {
        IntrinsicModel m = this.modelOf("sym in ('X', null, 'Y')");
        TestUtils.assertEquals((CharSequence)"sym", m.keyColumn);
        Assert.assertEquals((Object)"[X,null,Y]", (Object)m.keyValues.toString());
    }

    @Test
    public void testInVsEqualInterval() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp in ('2014-01-01T12:30:00.000Z', '2014-01-02T12:30:00.000Z') and timestamp = '2014-01-01'");
        Assert.assertNull((Object)m.filter);
        TestUtils.assertEquals((CharSequence)"[{lo=2014-01-01T12:30:00.000000Z, hi=2014-01-01T23:59:59.999999Z}]", GriffinParserTestUtils.intervalToString(m.intervals));
    }

    @Test
    public void testIndexedFieldTooFewArgs2() throws Exception {
        this.assertFilter(this.modelOf("sym in (x)"), "xsymin");
    }

    @Test
    public void testIndexedFieldTooFewArgs3() {
        try {
            this.modelOf("sym in ()");
            Assert.fail((String)"exception expected");
        }
        catch (SqlException e) {
            TestUtils.assertContains(e.getMessage(), "Too few arguments");
        }
    }

    @Test
    public void testIntervalDontIntersect() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp != '2015-05-11' and timestamp = '2015-05-11'");
        Assert.assertEquals((long)2L, (long)m.intrinsicValue);
    }

    @Test
    public void testIntervalGreater1() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp in ('2014-01-01T12:30:00.000Z', '2014-01-02T12:30:00.000Z') and timestamp > '2014-01-01T15:30:00.000Z'");
        TestUtils.assertEquals((CharSequence)"[{lo=2014-01-01T15:30:00.000001Z, hi=2014-01-02T12:30:00.000000Z}]", GriffinParserTestUtils.intervalToString(m.intervals));
    }

    @Test
    public void testIntervalGreater2() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp > '2014-01-01T15:30:00.000Z' and timestamp in ('2014-01-01T12:30:00.000Z', '2014-01-02T12:30:00.000Z')");
        TestUtils.assertEquals((CharSequence)"[{lo=2014-01-01T15:30:00.000001Z, hi=2014-01-02T12:30:00.000000Z}]", GriffinParserTestUtils.intervalToString(m.intervals));
    }

    @Test
    public void testIntervalGreater3() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp in ('2014-01-01T12:30:00.000Z', '2014-01-02T12:30:00.000Z') and timestamp > x()");
        TestUtils.assertEquals((CharSequence)"[{lo=2014-01-01T12:30:00.000000Z, hi=2014-01-02T12:30:00.000000Z}]", GriffinParserTestUtils.intervalToString(m.intervals));
        TestUtils.assertEquals((CharSequence)"xtimestamp>", this.toRpn(m.filter));
    }

    @Test
    public void testIntervalGreater4() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp in ('2014-01-01T12:30:00.000Z', '2014-01-02T12:30:00.000Z') and x() > timestamp");
        TestUtils.assertEquals((CharSequence)"[{lo=2014-01-01T12:30:00.000000Z, hi=2014-01-02T12:30:00.000000Z}]", GriffinParserTestUtils.intervalToString(m.intervals));
        TestUtils.assertEquals((CharSequence)"timestampx>", this.toRpn(m.filter));
    }

    @Test
    public void testIntervalGreater5() throws Exception {
        IntrinsicModel m = this.noTimestampModelOf("timestamp > '2014-01-01T15:30:00.000Z'");
        Assert.assertNull((Object)m.intervals);
        TestUtils.assertEquals((CharSequence)"'2014-01-01T15:30:00.000Z'timestamp>", this.toRpn(m.filter));
    }

    @Test
    public void testIntervalGreaterOrEq1() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp in ('2014-01-01T12:30:00.000Z', '2014-01-02T12:30:00.000Z') and timestamp >= '2014-01-01T15:30:00.000Z'");
        TestUtils.assertEquals((CharSequence)"[{lo=2014-01-01T15:30:00.000000Z, hi=2014-01-02T12:30:00.000000Z}]", GriffinParserTestUtils.intervalToString(m.intervals));
    }

    @Test
    public void testIntervalGreaterOrEq2() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp >= '2014-01-01T15:30:00.000Z' and timestamp in ('2014-01-01T12:30:00.000Z', '2014-01-02T12:30:00.000Z')");
        TestUtils.assertEquals((CharSequence)"[{lo=2014-01-01T15:30:00.000000Z, hi=2014-01-02T12:30:00.000000Z}]", GriffinParserTestUtils.intervalToString(m.intervals));
    }

    @Test
    public void testIntervalLessNoTimestamp() throws Exception {
        IntrinsicModel m = this.noTimestampModelOf("timestamp < '2014-01-01T15:30:00.000Z'");
        Assert.assertNull((Object)m.intervals);
        TestUtils.assertEquals((CharSequence)"'2014-01-01T15:30:00.000Z'timestamp<", this.toRpn(m.filter));
    }

    @Test
    public void testIntervalSourceDay() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp = '2015-02-23T10:00:55.000Z;30m;2d;5'");
        TestUtils.assertEquals((CharSequence)"[{lo=2015-02-23T10:00:55.000000Z, hi=2015-02-23T10:30:55.000000Z},{lo=2015-02-25T10:00:55.000000Z, hi=2015-02-25T10:30:55.000000Z},{lo=2015-02-27T10:00:55.000000Z, hi=2015-02-27T10:30:55.000000Z},{lo=2015-03-01T10:00:55.000000Z, hi=2015-03-01T10:30:55.000000Z},{lo=2015-03-03T10:00:55.000000Z, hi=2015-03-03T10:30:55.000000Z}]", GriffinParserTestUtils.intervalToString(m.intervals));
    }

    @Test
    public void testIntervalSourceHour() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp = '2015-02-23T10:00:55.000Z;10m;3h;10'");
        String expected = "[{lo=2015-02-23T10:00:55.000000Z, hi=2015-02-23T10:10:55.000000Z},{lo=2015-02-23T13:00:55.000000Z, hi=2015-02-23T13:10:55.000000Z},{lo=2015-02-23T16:00:55.000000Z, hi=2015-02-23T16:10:55.000000Z},{lo=2015-02-23T19:00:55.000000Z, hi=2015-02-23T19:10:55.000000Z},{lo=2015-02-23T22:00:55.000000Z, hi=2015-02-23T22:10:55.000000Z},{lo=2015-02-24T01:00:55.000000Z, hi=2015-02-24T01:10:55.000000Z},{lo=2015-02-24T04:00:55.000000Z, hi=2015-02-24T04:10:55.000000Z},{lo=2015-02-24T07:00:55.000000Z, hi=2015-02-24T07:10:55.000000Z},{lo=2015-02-24T10:00:55.000000Z, hi=2015-02-24T10:10:55.000000Z},{lo=2015-02-24T13:00:55.000000Z, hi=2015-02-24T13:10:55.000000Z}]";
        TestUtils.assertEquals((CharSequence)"[{lo=2015-02-23T10:00:55.000000Z, hi=2015-02-23T10:10:55.000000Z},{lo=2015-02-23T13:00:55.000000Z, hi=2015-02-23T13:10:55.000000Z},{lo=2015-02-23T16:00:55.000000Z, hi=2015-02-23T16:10:55.000000Z},{lo=2015-02-23T19:00:55.000000Z, hi=2015-02-23T19:10:55.000000Z},{lo=2015-02-23T22:00:55.000000Z, hi=2015-02-23T22:10:55.000000Z},{lo=2015-02-24T01:00:55.000000Z, hi=2015-02-24T01:10:55.000000Z},{lo=2015-02-24T04:00:55.000000Z, hi=2015-02-24T04:10:55.000000Z},{lo=2015-02-24T07:00:55.000000Z, hi=2015-02-24T07:10:55.000000Z},{lo=2015-02-24T10:00:55.000000Z, hi=2015-02-24T10:10:55.000000Z},{lo=2015-02-24T13:00:55.000000Z, hi=2015-02-24T13:10:55.000000Z}]", GriffinParserTestUtils.intervalToString(m.intervals));
    }

    @Test
    public void testIntervalSourceMin() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp = '2015-02-23T10:00:55.000Z;15s;15m;5'");
        String expected = "[{lo=2015-02-23T10:00:55.000000Z, hi=2015-02-23T10:01:10.000000Z},{lo=2015-02-23T10:15:55.000000Z, hi=2015-02-23T10:16:10.000000Z},{lo=2015-02-23T10:30:55.000000Z, hi=2015-02-23T10:31:10.000000Z},{lo=2015-02-23T10:45:55.000000Z, hi=2015-02-23T10:46:10.000000Z},{lo=2015-02-23T11:00:55.000000Z, hi=2015-02-23T11:01:10.000000Z}]";
        TestUtils.assertEquals((CharSequence)"[{lo=2015-02-23T10:00:55.000000Z, hi=2015-02-23T10:01:10.000000Z},{lo=2015-02-23T10:15:55.000000Z, hi=2015-02-23T10:16:10.000000Z},{lo=2015-02-23T10:30:55.000000Z, hi=2015-02-23T10:31:10.000000Z},{lo=2015-02-23T10:45:55.000000Z, hi=2015-02-23T10:46:10.000000Z},{lo=2015-02-23T11:00:55.000000Z, hi=2015-02-23T11:01:10.000000Z}]", GriffinParserTestUtils.intervalToString(m.intervals));
    }

    @Test
    public void testIntervalSourceMonth() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp = '2015-02-23T10:00:55.000Z;2h;2M;3'");
        String expected = "[{lo=2015-02-23T10:00:55.000000Z, hi=2015-02-23T12:00:55.000000Z},{lo=2015-04-23T10:00:55.000000Z, hi=2015-04-23T12:00:55.000000Z},{lo=2015-06-23T10:00:55.000000Z, hi=2015-06-23T12:00:55.000000Z}]";
        TestUtils.assertEquals((CharSequence)"[{lo=2015-02-23T10:00:55.000000Z, hi=2015-02-23T12:00:55.000000Z},{lo=2015-04-23T10:00:55.000000Z, hi=2015-04-23T12:00:55.000000Z},{lo=2015-06-23T10:00:55.000000Z, hi=2015-06-23T12:00:55.000000Z}]", GriffinParserTestUtils.intervalToString(m.intervals));
    }

    @Test
    public void testIntervalSourceSec() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp = '2015-02-23T10:00:55.000Z;5s;30s;5'");
        String expected = "[{lo=2015-02-23T10:00:55.000000Z, hi=2015-02-23T10:01:00.000000Z},{lo=2015-02-23T10:01:25.000000Z, hi=2015-02-23T10:01:30.000000Z},{lo=2015-02-23T10:01:55.000000Z, hi=2015-02-23T10:02:00.000000Z},{lo=2015-02-23T10:02:25.000000Z, hi=2015-02-23T10:02:30.000000Z},{lo=2015-02-23T10:02:55.000000Z, hi=2015-02-23T10:03:00.000000Z}]";
        TestUtils.assertEquals((CharSequence)"[{lo=2015-02-23T10:00:55.000000Z, hi=2015-02-23T10:01:00.000000Z},{lo=2015-02-23T10:01:25.000000Z, hi=2015-02-23T10:01:30.000000Z},{lo=2015-02-23T10:01:55.000000Z, hi=2015-02-23T10:02:00.000000Z},{lo=2015-02-23T10:02:25.000000Z, hi=2015-02-23T10:02:30.000000Z},{lo=2015-02-23T10:02:55.000000Z, hi=2015-02-23T10:03:00.000000Z}]", GriffinParserTestUtils.intervalToString(m.intervals));
    }

    @Test
    public void testIntervalSourceYear() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp = '2015-02-23T10:00:55.000Z;1d;1y;5'");
        String expected = "[{lo=2015-02-23T10:00:55.000000Z, hi=2015-02-24T10:00:55.000000Z},{lo=2016-02-23T10:00:55.000000Z, hi=2016-02-24T10:00:55.000000Z},{lo=2017-02-23T10:00:55.000000Z, hi=2017-02-24T10:00:55.000000Z},{lo=2018-02-23T10:00:55.000000Z, hi=2018-02-24T10:00:55.000000Z},{lo=2019-02-23T10:00:55.000000Z, hi=2019-02-24T10:00:55.000000Z}]";
        TestUtils.assertEquals((CharSequence)"[{lo=2015-02-23T10:00:55.000000Z, hi=2015-02-24T10:00:55.000000Z},{lo=2016-02-23T10:00:55.000000Z, hi=2016-02-24T10:00:55.000000Z},{lo=2017-02-23T10:00:55.000000Z, hi=2017-02-24T10:00:55.000000Z},{lo=2018-02-23T10:00:55.000000Z, hi=2018-02-24T10:00:55.000000Z},{lo=2019-02-23T10:00:55.000000Z, hi=2019-02-24T10:00:55.000000Z}]", GriffinParserTestUtils.intervalToString(m.intervals));
    }

    @Test
    public void testIntervalTooFewArgs() {
        try {
            this.modelOf("timestamp in (\"2014-01-01T12:30:00.000Z\")");
            Assert.fail((String)"Exception expected");
        }
        catch (SqlException e) {
            TestUtils.assertContains(e.getMessage(), "Too few arg");
        }
    }

    @Test
    public void testIntervalTooFewArgs2() {
        try {
            this.modelOf("timestamp in ()");
            Assert.fail((String)"Exception expected");
        }
        catch (SqlException e) {
            TestUtils.assertContains(e.getMessage(), "Too few arg");
        }
    }

    @Test
    public void testIntervalTooManyArgs() {
        try {
            this.modelOf("timestamp in (\"2014-01-01T12:30:00.000Z\", \"2014-01-02T12:30:00.000Z\", \"2014-01-03T12:30:00.000Z\")");
            Assert.fail((String)"Exception expected");
        }
        catch (SqlException e) {
            TestUtils.assertContains(e.getMessage(), "Too many arg");
        }
    }

    @Test
    public void testIntrinsicPickup() throws Exception {
        this.assertFilter(this.modelOf("timestamp = '2014-06-20T13:25:00.000Z;10m;2d;4' and sym in ('A', 'B') or ex = 'D'"), "'D'ex='B''A'symin'2014-06-20T13:25:00.000Z;10m;2d;4'timestamp=andor");
        this.assertFilter(this.modelOf("timestamp = '2014-06-20T13:25:00.000Z;10m;2d;4' or ex = 'D' and sym in ('A', 'B')"), "'D'ex='2014-06-20T13:25:00.000Z;10m;2d;4'timestamp=or");
    }

    @Test(expected=SqlException.class)
    public void testInvalidIntervalSource1() throws Exception {
        this.modelOf("timestamp = '2014-06-20T13:25:00.000Z;10m;2d'");
    }

    @Test(expected=SqlException.class)
    public void testInvalidIntervalSource2() throws Exception {
        this.modelOf("timestamp = '2014-06-20T13:25:00.000Z;10m;2d;4;4'");
    }

    @Test
    public void testLambdaVsConst() throws Exception {
        IntrinsicModel m = this.modelOf("sym in (select a from xyz) and ex in (1,2)");
        TestUtils.assertEquals((CharSequence)"sym", m.keyColumn);
        Assert.assertNotNull((Object)m.keySubQuery);
        Assert.assertNotNull((Object)m.filter);
        TestUtils.assertEquals((CharSequence)"ex in (1,2)", GriffinParserTestUtils.toRpn(m.filter));
    }

    @Test
    public void testLambdaVsLambda() throws Exception {
        IntrinsicModel m = this.modelOf("ex in (select * from abc) and sym in (select * from xyz)");
        TestUtils.assertEquals((CharSequence)"sym", m.keyColumn);
        Assert.assertNotNull((Object)m.keySubQuery);
        Assert.assertNotNull((Object)m.filter);
        TestUtils.assertEquals((CharSequence)"ex in (select-choose * column from (abc))", GriffinParserTestUtils.toRpn(m.filter));
    }

    @Test
    public void testLessInvalidDate() {
        try {
            this.modelOf("timestamp < '2014-0x-01T12:30:00.000Z'");
            Assert.fail();
        }
        catch (SqlException e) {
            Assert.assertEquals((long)12L, (long)e.getPosition());
        }
    }

    @Test
    public void testLessInvalidDate2() {
        try {
            this.modelOf("'2014-0x-01T12:30:00.000Z' < timestamp");
            Assert.fail();
        }
        catch (SqlException e) {
            Assert.assertEquals((long)0L, (long)e.getPosition());
        }
    }

    @Test
    public void testLessNonConstant() throws SqlException {
        IntrinsicModel m = this.modelOf("timestamp < x");
        Assert.assertNull((Object)m.intervals);
        Assert.assertEquals((long)0L, (long)m.intrinsicValue);
        TestUtils.assertEquals((CharSequence)"xtimestamp<", this.toRpn(m.filter));
    }

    @Test
    public void testLessNonConstant2() throws SqlException {
        IntrinsicModel m = this.modelOf("x < timestamp");
        Assert.assertNull((Object)m.intervals);
        Assert.assertEquals((long)0L, (long)m.intrinsicValue);
        TestUtils.assertEquals((CharSequence)"timestampx<", this.toRpn(m.filter));
    }

    @Test
    public void testListOfValuesNegativeOverlap() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp in ('2014-01-01T12:30:00.000Z', '2014-01-02T12:30:00.000Z') and sym in ('a', 'z') and sym in ('c')");
        Assert.assertEquals((long)2L, (long)m.intrinsicValue);
    }

    @Test
    public void testListOfValuesOverlapWithNotClause() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp in ('2014-01-01T12:30:00.000Z', '2014-01-02T12:30:00.000Z') and sym in ('a', 'z') and not (sym in ('c', 'd', 'e'))");
        Assert.assertEquals((Object)"[a,z]", (Object)m.keyValues.toString());
        Assert.assertNull((Object)m.filter);
        Assert.assertEquals((long)0L, (long)m.intrinsicValue);
    }

    @Test
    public void testListOfValuesOverlapWithNotClause2() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp in ('2014-01-01T12:30:00.000Z', '2014-01-02T12:30:00.000Z') and sym in ('a', 'z') and not (sym in ('a', 'd', 'e'))");
        Assert.assertNull((Object)m.filter);
        Assert.assertEquals((Object)"[z]", (Object)m.keyValues.toString());
        Assert.assertEquals((long)0L, (long)m.intrinsicValue);
    }

    @Test
    public void testListOfValuesOverlapWithNotClause3() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp in ('2014-01-01T12:30:00.000Z', '2014-01-02T12:30:00.000Z') and sym in ('a', 'z') and not (sym in ('a', 'z', 'e'))");
        Assert.assertEquals((Object)"[]", (Object)m.keyValues.toString());
        Assert.assertEquals((long)2L, (long)m.intrinsicValue);
    }

    @Test
    public void testListOfValuesPositiveOverlap() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp in ('2014-01-01T12:30:00.000Z', '2014-01-02T12:30:00.000Z') and sym in ('a', 'z') and sym in ('z')");
        Assert.assertNull((Object)m.filter);
        Assert.assertEquals((long)0L, (long)m.intrinsicValue);
        Assert.assertEquals((Object)"[z]", (Object)m.keyValues.toString());
    }

    @Test
    public void testListOfValuesPositiveOverlapQuoteIndifference() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp in ('2014-01-01T12:30:00.000Z', '2014-01-02T12:30:00.000Z') and sym in ('a', \"z\") and sym in ('z')");
        Assert.assertNull((Object)m.filter);
        Assert.assertEquals((long)0L, (long)m.intrinsicValue);
        Assert.assertEquals((Object)"[z]", (Object)m.keyValues.toString());
    }

    @Test
    public void testLiteralInInterval() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp in (\"2014-01-01T12:30:00.000Z\", c)");
        Assert.assertNull((Object)m.intervals);
        this.assertFilter(m, "c\"2014-01-01T12:30:00.000Z\"timestampin");
    }

    @Test
    public void testLiteralInListOfValues() throws Exception {
        IntrinsicModel m = this.modelOf("sym in (\"a\", z) and timestamp in (\"2014-01-01T12:30:00.000Z\", \"2014-01-02T12:30:00.000Z\")");
        TestUtils.assertEquals((CharSequence)"[{lo=2014-01-01T12:30:00.000000Z, hi=2014-01-02T12:30:00.000000Z}]", GriffinParserTestUtils.intervalToString(m.intervals));
        Assert.assertNull((Object)m.keyColumn);
        this.assertFilter(m, "z\"a\"symin");
    }

    @Test
    public void testLiteralInListOfValuesInvalidColumn() {
        try {
            this.modelOf("timestamp in ('2014-01-01T12:30:00.000Z', '2014-01-02T12:30:00.000Z') and x in ('a', z)");
            Assert.fail((String)"Exception expected");
        }
        catch (SqlException e) {
            Assert.assertEquals((long)74L, (long)e.getPosition());
        }
    }

    @Test
    public void testManualInterval() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp >= '2014-01-01T15:30:00.000Z' and timestamp < '2014-01-02T12:30:00.000Z'");
        TestUtils.assertEquals((CharSequence)"[{lo=2014-01-01T15:30:00.000000Z, hi=2014-01-02T12:29:59.999999Z}]", GriffinParserTestUtils.intervalToString(m.intervals));
    }

    @Test
    public void testManualIntervalInverted() throws Exception {
        IntrinsicModel m = this.modelOf("'2014-01-02T12:30:00.000Z' > timestamp and '2014-01-01T15:30:00.000Z' <= timestamp ");
        TestUtils.assertEquals((CharSequence)"[{lo=2014-01-01T15:30:00.000000Z, hi=2014-01-02T12:29:59.999999Z}]", GriffinParserTestUtils.intervalToString(m.intervals));
    }

    @Test
    public void testMultipleAnds() throws Exception {
        IntrinsicModel m = this.modelOf("a > 10 and b > 20 and (c > 100 and d < 20 and bid = 30)");
        this.assertFilter(m, "30bid=20d<100c>andand20b>10a>andand");
    }

    @Test
    public void testNestedFunctionTest() throws Exception {
        IntrinsicModel m = this.modelOf("substr(parse(x, 1, 3), 2, 4)");
        Assert.assertNull((Object)m.intervals);
        this.assertFilter(m, "4231xparsesubstr");
    }

    @Test
    public void testNoIntrinsics() throws Exception {
        IntrinsicModel m = this.modelOf("a > 10 or b > 20");
        Assert.assertNull((Object)m.intervals);
        Assert.assertNull((Object)m.keyColumn);
        this.assertFilter(m, "20b>10a>or");
    }

    @Test
    public void testNotEqualInvalidColumn() {
        try {
            this.modelOf("ex != null and abb != 'blah'");
        }
        catch (SqlException e) {
            TestUtils.assertContains(e.getMessage(), "Invalid column");
            Assert.assertEquals((long)15L, (long)e.getPosition());
        }
    }

    @Test
    public void testNotEqualPreferredColumn() throws Exception {
        IntrinsicModel m = this.modelOf("sym = null and sym != null and ex != 'blah'", "ex");
        Assert.assertEquals((long)0L, (long)m.intrinsicValue);
        this.assertFilter(m, "'blah'ex!=nullsym!=nullsym=andand");
        Assert.assertEquals((Object)"[]", (Object)m.keyValues.toString());
        Assert.assertEquals((Object)"[]", (Object)m.keyValuePositions.toString());
    }

    @Test
    public void testNotEqualsDoesNotOverlapWithIn() throws Exception {
        IntrinsicModel m = this.modelOf("sym in ('x','y') and sym != 'z' and ex != 'blah'");
        this.assertFilter(m, "'blah'ex!=");
        Assert.assertEquals((Object)"[x,y]", (Object)m.keyValues.toString());
        Assert.assertEquals((Object)"[8,12]", (Object)m.keyValuePositions.toString());
    }

    @Test
    public void testNotEqualsOverlapWithIn() throws Exception {
        IntrinsicModel m = this.modelOf("sym in ('x','y') and sym != 'y' and ex != 'blah'");
        this.assertFilter(m, "'blah'ex!=");
        Assert.assertEquals((Object)"[x]", (Object)m.keyValues.toString());
        Assert.assertEquals((Object)"[8]", (Object)m.keyValuePositions.toString());
    }

    @Test
    public void testNotInIntervalIntersect() throws Exception {
        IntrinsicModel m = this.modelOf("not (timestamp in  ('2015-05-11T15:00:00.000Z', '2015-05-11T20:00:00.000Z')) and timestamp = '2015-05-11'");
        Assert.assertEquals((long)0L, (long)m.intrinsicValue);
        TestUtils.assertEquals((CharSequence)"[{lo=2015-05-11T00:00:00.000000Z, hi=2015-05-11T14:59:59.999999Z},{lo=2015-05-11T20:00:00.000001Z, hi=2015-05-11T23:59:59.999999Z}]", GriffinParserTestUtils.intervalToString(m.intervals));
        Assert.assertNull((Object)m.filter);
    }

    @Test
    public void testNotInIntervalIntersect2() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp = '2015-05-11' and not (timestamp in  ('2015-05-11T15:00:00.000Z', '2015-05-11T20:00:00.000Z'))");
        Assert.assertEquals((long)0L, (long)m.intrinsicValue);
        TestUtils.assertEquals((CharSequence)"[{lo=2015-05-11T00:00:00.000000Z, hi=2015-05-11T14:59:59.999999Z},{lo=2015-05-11T20:00:00.000001Z, hi=2015-05-11T23:59:59.999999Z}]", GriffinParserTestUtils.intervalToString(m.intervals));
        Assert.assertNull((Object)m.filter);
    }

    @Test
    public void testNotInIntervalIntersect3() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp = '2015-05-11' and not (timestamp in  ('2015-05-11T15:00:00.000Z', '2015-05-11T20:00:00.000Z')) and not (timestamp in ('2015-05-11T12:00:00.000Z', '2015-05-11T14:00:00.000Z')))");
        Assert.assertEquals((long)0L, (long)m.intrinsicValue);
        TestUtils.assertEquals((CharSequence)"[{lo=2015-05-11T00:00:00.000000Z, hi=2015-05-11T11:59:59.999999Z},{lo=2015-05-11T14:00:00.000001Z, hi=2015-05-11T14:59:59.999999Z},{lo=2015-05-11T20:00:00.000001Z, hi=2015-05-11T23:59:59.999999Z}]", GriffinParserTestUtils.intervalToString(m.intervals));
        Assert.assertNull((Object)m.filter);
    }

    @Test
    public void testNotInIntervalInvalidHi() {
        try {
            this.modelOf("not (timestamp in  ('2015-05-11T15:00:00.000Z', 'abc')) and timestamp = '2015-05-11'");
            Assert.fail();
        }
        catch (SqlException e) {
            TestUtils.assertContains(e.getFlyweightMessage(), "Invalid date");
            Assert.assertEquals((long)48L, (long)e.getPosition());
        }
    }

    @Test
    public void testNotInIntervalInvalidLo() {
        try {
            this.modelOf("not (timestamp in  ('abc','2015-05-11T15:00:00.000Z')) and timestamp = '2015-05-11'");
            Assert.fail();
        }
        catch (SqlException e) {
            TestUtils.assertContains(e.getFlyweightMessage(), "Invalid date");
            Assert.assertEquals((long)20L, (long)e.getPosition());
        }
    }

    @Test
    public void testNotInIntervalNonConstant() throws SqlException {
        IntrinsicModel m = this.modelOf("not (timestamp in  (x, 'abc')) and timestamp = '2015-05-11'");
        TestUtils.assertEquals((CharSequence)"[{lo=2015-05-11T00:00:00.000000Z, hi=2015-05-11T23:59:59.999999Z}]", GriffinParserTestUtils.intervalToString(m.intervals));
        Assert.assertEquals((long)0L, (long)m.intrinsicValue);
        TestUtils.assertEquals((CharSequence)"'abc'xtimestampinnot", this.toRpn(m.filter));
    }

    @Test
    public void testNotInIntervalNonLiteral() {
        try {
            this.modelOf("not (timestamp() in  ('2015-05-11T15:00:00.000Z')) and timestamp = '2015-05-11'");
            Assert.fail();
        }
        catch (SqlException e) {
            TestUtils.assertContains(e.getFlyweightMessage(), "Column name");
        }
    }

    @Test
    public void testNotInIntervalTooFew() {
        try {
            this.modelOf("not (timestamp in  ('2015-05-11T15:00:00.000Z')) and timestamp = '2015-05-11'");
            Assert.fail();
        }
        catch (SqlException e) {
            TestUtils.assertContains(e.getFlyweightMessage(), "Too few");
        }
    }

    @Test
    public void testNotInIntervalTooMany() {
        try {
            this.modelOf("not (timestamp in  ('2015-05-11T15:00:00.000Z','2015-05-11T15:00:00.000Z','2015-05-11T15:00:00.000Z')) and timestamp = '2015-05-11'");
            Assert.fail();
        }
        catch (SqlException e) {
            TestUtils.assertContains(e.getFlyweightMessage(), "Too many");
        }
    }

    @Test
    public void testNotInInvalidColumn() {
        try {
            this.modelOf("not (xyz in  ('2015-05-11T15:00:00.000Z')) and timestamp = '2015-05-11'");
            Assert.fail();
        }
        catch (SqlException e) {
            TestUtils.assertContains(e.getFlyweightMessage(), "Invalid column");
            Assert.assertEquals((long)5L, (long)e.getPosition());
        }
    }

    @Test
    public void testNotInTooFew() {
        try {
            this.modelOf("not (ex in  ()) and timestamp = '2015-05-11'");
            Assert.fail();
        }
        catch (SqlException e) {
            TestUtils.assertContains(e.getFlyweightMessage(), "Too few");
            Assert.assertEquals((long)8L, (long)e.getPosition());
        }
    }

    @Test
    public void testOr() throws Exception {
        IntrinsicModel m = this.modelOf("(sym = 'X' or sym = 'Y') and bid > 10");
        Assert.assertEquals((long)0L, (long)m.intrinsicValue);
        this.assertFilter(m, "10bid>'Y'sym='X'sym=orand");
    }

    @Test
    public void testOrNullSearch() throws Exception {
        IntrinsicModel m = this.modelOf("sym = null or sym != null and ex != 'blah'");
        Assert.assertEquals((long)0L, (long)m.intrinsicValue);
        this.assertFilter(m, "'blah'ex!=nullsym!=nullsym=orand");
        Assert.assertEquals((Object)"[]", (Object)m.keyValues.toString());
        Assert.assertEquals((Object)"[]", (Object)m.keyValuePositions.toString());
    }

    @Test
    public void testPreferredColumn() throws Exception {
        IntrinsicModel m = this.modelOf("sym in ('a', 'b') and ex in ('c') and timestamp in ('2014-01-01T12:30:00.000Z', '2014-01-02T12:30:00.000Z') and bid > 100 and ask < 110", "ex");
        this.assertFilter(m, "110ask<100bid>'b''a'syminandand");
        TestUtils.assertEquals((CharSequence)"ex", m.keyColumn);
        Assert.assertEquals((Object)"[c]", (Object)m.keyValues.toString());
        TestUtils.assertEquals((CharSequence)"[{lo=2014-01-01T12:30:00.000000Z, hi=2014-01-02T12:30:00.000000Z}]", GriffinParserTestUtils.intervalToString(m.intervals));
    }

    @Test
    public void testPreferredColumn2() throws Exception {
        IntrinsicModel m = this.modelOf("ex in ('c') and sym in ('a', 'b') and timestamp in ('2014-01-01T12:30:00.000Z', '2014-01-02T12:30:00.000Z') and bid > 100 and ask < 110", "ex");
        this.assertFilter(m, "110ask<100bid>'b''a'syminandand");
        TestUtils.assertEquals((CharSequence)"ex", m.keyColumn);
        Assert.assertEquals((Object)"[c]", (Object)m.keyValues.toString());
        TestUtils.assertEquals((CharSequence)"[{lo=2014-01-01T12:30:00.000000Z, hi=2014-01-02T12:30:00.000000Z}]", GriffinParserTestUtils.intervalToString(m.intervals));
    }

    @Test
    public void testPreferredColumn3() throws Exception {
        IntrinsicModel m = this.modelOf("sym in ('a', 'b') and timestamp in ('2014-01-01T12:30:00.000Z', '2014-01-02T12:30:00.000Z') and bid > 100 and ask < 110", "ex");
        this.assertFilter(m, "110ask<100bid>'b''a'syminandand");
        Assert.assertNull((Object)m.keyColumn);
        TestUtils.assertEquals((CharSequence)"[{lo=2014-01-01T12:30:00.000000Z, hi=2014-01-02T12:30:00.000000Z}]", GriffinParserTestUtils.intervalToString(m.intervals));
    }

    @Test
    public void testSimpleInterval() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp in (\"2014-01-01T12:30:00.000Z\", \"2014-01-02T12:30:00.000Z\")");
        TestUtils.assertEquals((CharSequence)"[{lo=2014-01-01T12:30:00.000000Z, hi=2014-01-02T12:30:00.000000Z}]", GriffinParserTestUtils.intervalToString(m.intervals));
        Assert.assertNull((Object)m.filter);
    }

    @Test
    public void testSimpleLambda() throws Exception {
        IntrinsicModel m = this.modelOf("sym in (select * from xyz)");
        Assert.assertNotNull((Object)m.keySubQuery);
    }

    @Test
    public void testSingleQuoteInterval() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp in ('2014-01-01T12:30:00.000Z', '2014-01-02T12:30:00.000Z')");
        TestUtils.assertEquals((CharSequence)"[{lo=2014-01-01T12:30:00.000000Z, hi=2014-01-02T12:30:00.000000Z}]", GriffinParserTestUtils.intervalToString(m.intervals));
        Assert.assertNull((Object)m.filter);
    }

    @Test
    public void testThreeIntrinsics() throws Exception {
        IntrinsicModel m = this.modelOf("sym in ('a', 'b') and ex in ('c') and timestamp in ('2014-01-01T12:30:00.000Z', '2014-01-02T12:30:00.000Z') and bid > 100 and ask < 110");
        TestUtils.assertEquals((CharSequence)"sym", m.keyColumn);
        Assert.assertEquals((Object)"[a,b]", (Object)m.keyValues.toString());
        TestUtils.assertEquals((CharSequence)"[{lo=2014-01-01T12:30:00.000000Z, hi=2014-01-02T12:30:00.000000Z}]", GriffinParserTestUtils.intervalToString(m.intervals));
    }

    @Test
    public void testThreeIntrinsics2() throws Exception {
        IntrinsicModel m = this.modelOf("ex in ('c') and sym in ('a', 'b') and timestamp in ('2014-01-01T12:30:00.000Z', '2014-01-02T12:30:00.000Z') and bid > 100 and ask < 110");
        this.assertFilter(m, "110ask<100bid>'c'exinandand");
        TestUtils.assertEquals((CharSequence)"sym", m.keyColumn);
        Assert.assertEquals((Object)"[a,b]", (Object)m.keyValues.toString());
        TestUtils.assertEquals((CharSequence)"[{lo=2014-01-01T12:30:00.000000Z, hi=2014-01-02T12:30:00.000000Z}]", GriffinParserTestUtils.intervalToString(m.intervals));
    }

    @Test
    public void testTwoDiffColLambdas() throws Exception {
        IntrinsicModel m = this.modelOf("sym in (select * from xyz) and ex in (select  * from kkk)");
        TestUtils.assertEquals((CharSequence)"sym", m.keyColumn);
        Assert.assertNotNull((Object)m.keySubQuery);
        Assert.assertNotNull((Object)m.filter);
        Assert.assertEquals((long)65L, (long)m.filter.rhs.type);
    }

    @Test
    public void testTwoExactMatchDifferentDates() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp = '2015-05-10T15:03:10.000Z' and timestamp = '2015-05-11T15:03:10.000Z' and timestamp = '2015-05-11'");
        TestUtils.assertEquals((CharSequence)"[]", GriffinParserTestUtils.intervalToString(m.intervals));
        Assert.assertNull((Object)m.filter);
        Assert.assertEquals((long)2L, (long)m.intrinsicValue);
    }

    @Test
    public void testTwoExactSameDates() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp = '2015-05-10T15:03:10.000Z' and timestamp = '2015-05-10T15:03:10.000Z' and timestamp = '2015-05-11'");
        TestUtils.assertEquals((CharSequence)"[]", GriffinParserTestUtils.intervalToString(m.intervals));
        Assert.assertNull((Object)m.filter);
        Assert.assertEquals((long)2L, (long)m.intrinsicValue);
    }

    @Test
    public void testTwoIntervalSources() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp = '2014-06-20T13:25:00.000Z;10m;2d;5' and timestamp = '2015-06-20T13:25:00.000Z;10m;2d;5'");
        TestUtils.assertEquals((CharSequence)"[]", GriffinParserTestUtils.intervalToString(m.intervals));
    }

    @Test
    public void testTwoIntervals() throws Exception {
        IntrinsicModel m = this.modelOf("bid > 100 and timestamp in (\"2014-01-01T12:30:00.000Z\", \"2014-01-02T12:30:00.000Z\") and timestamp in (\"2014-01-01T16:30:00.000Z\", \"2014-01-05T12:30:00.000Z\")");
        TestUtils.assertEquals((CharSequence)"[{lo=2014-01-01T16:30:00.000000Z, hi=2014-01-02T12:30:00.000000Z}]", GriffinParserTestUtils.intervalToString(m.intervals));
    }

    @Test
    public void testTwoSameColLambdas() {
        try {
            this.modelOf("sym in (select * from xyz) and sym in (select * from kkk)");
            Assert.fail((String)"exception expected");
        }
        catch (SqlException e) {
            Assert.assertEquals((long)4L, (long)e.getPosition());
            TestUtils.assertContains(e.getMessage(), "Multiple lambda");
        }
    }

    @Test
    public void testUnindexedEquals() throws SqlException {
        IntrinsicModel m = this.unindexedModelOf("sym = 'ABC'", null);
        Assert.assertNull((Object)m.keyColumn);
        TestUtils.assertEquals((CharSequence)"sym = 'ABC'", GriffinParserTestUtils.toRpn(m.filter));
        TestUtils.assertEquals((CharSequence)"[]", m.keyValues.toString());
    }

    @Test
    public void testUnindexedIn() throws SqlException {
        IntrinsicModel m = this.unindexedModelOf("sym in (1,2)", null);
        Assert.assertNull((Object)m.keyColumn);
        TestUtils.assertEquals((CharSequence)"sym in (1,2)", GriffinParserTestUtils.toRpn(m.filter));
        TestUtils.assertEquals((CharSequence)"[]", m.keyValues.toString());
    }

    @Test
    public void testUnindexedPreferredEquals() throws SqlException {
        IntrinsicModel m = this.unindexedModelOf("sym = 'ABC'", "sym");
        TestUtils.assertEquals((CharSequence)"sym", m.keyColumn);
        Assert.assertNull((Object)m.filter);
        TestUtils.assertEquals((CharSequence)"[ABC]", m.keyValues.toString());
    }

    @Test
    public void testUnindexedPreferredIn() throws SqlException {
        IntrinsicModel m = this.unindexedModelOf("sym in (1,2)", "sym");
        TestUtils.assertEquals((CharSequence)"sym", m.keyColumn);
        Assert.assertNull((Object)m.filter);
        TestUtils.assertEquals((CharSequence)"[1,2]", m.keyValues.toString());
    }

    @Test
    public void testUnindexedPreferredInVsIndexed() throws SqlException {
        IntrinsicModel m = this.unindexedModelOf("sym in (1,2) and ex in ('XYZ')", "sym");
        TestUtils.assertEquals((CharSequence)"sym", m.keyColumn);
        TestUtils.assertEquals((CharSequence)"ex in 'XYZ'", GriffinParserTestUtils.toRpn(m.filter));
        TestUtils.assertEquals((CharSequence)"[1,2]", m.keyValues.toString());
    }

    private void assertFilter(IntrinsicModel m, CharSequence expected) throws SqlException {
        Assert.assertNotNull((Object)m.filter);
        TestUtils.assertEquals(expected, this.toRpn(m.filter));
    }

    private IntrinsicModel modelOf(CharSequence seq) throws SqlException {
        return this.modelOf(seq, null);
    }

    private IntrinsicModel modelOf(CharSequence seq, String preferredColumn) throws SqlException {
        this.queryModel.clear();
        return this.e.extract(column -> column, compiler.parseExpression(seq, this.queryModel), metadata, (CharSequence)preferredColumn, metadata.getTimestampIndex());
    }

    private IntrinsicModel noTimestampModelOf(CharSequence seq) throws SqlException {
        this.queryModel.clear();
        return this.e.extract(column -> column, compiler.parseExpression(seq, this.queryModel), noTimestampMetadata, null, noTimestampMetadata.getTimestampIndex());
    }

    private void testBadOperator(String op) {
        try {
            this.modelOf("sum(ts) " + op);
            Assert.fail();
        }
        catch (SqlException e) {
            Assert.assertEquals((long)8L, (long)e.getPosition());
        }
        try {
            this.modelOf(op + " sum(ts)");
            Assert.fail();
        }
        catch (SqlException e) {
            Assert.assertEquals((long)0L, (long)e.getPosition());
        }
    }

    private CharSequence toRpn(ExpressionNode node) throws SqlException {
        this.rpn.reset();
        this.traversalAlgo.traverse(node, this.rpnBuilderVisitor);
        return this.rpn.rpn();
    }

    private IntrinsicModel unindexedModelOf(CharSequence seq, String preferredColumn) throws SqlException {
        this.queryModel.clear();
        return this.e.extract(column -> column, compiler.parseExpression(seq, this.queryModel), unindexedMetadata, (CharSequence)preferredColumn, unindexedMetadata.getTimestampIndex());
    }
}

