/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.griffin;

import com.questdb.cairo.TableWriter;
import com.questdb.griffin.AbstractGriffinTest;
import com.questdb.griffin.SqlException;
import com.questdb.griffin.engine.functions.rnd.SharedRandom;
import com.questdb.std.Rnd;
import com.questdb.test.tools.TestUtils;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TruncateTest
extends AbstractGriffinTest {
    @Before
    public void setUp3() {
        SharedRandom.RANDOM.set(new Rnd());
    }

    @Test
    public void testExpectTableKeyword() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try {
                compiler.compile((CharSequence)"truncate x", bindVariableService);
                Assert.fail();
            }
            catch (SqlException e) {
                Assert.assertEquals((long)9L, (long)e.getPosition());
                TestUtils.assertContains(e.getFlyweightMessage(), "'table' expected");
            }
        });
    }

    @Test
    public void testExpectTableName() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try {
                compiler.compile((CharSequence)"truncate table", bindVariableService);
                Assert.fail();
            }
            catch (SqlException e) {
                Assert.assertEquals((long)14L, (long)e.getPosition());
                TestUtils.assertContains(e.getFlyweightMessage(), "table name expected");
            }
        });
    }

    @Test
    public void testExpectTableName2() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try {
                this.createX();
                compiler.compile((CharSequence)"truncate table x,", bindVariableService);
                Assert.fail();
            }
            catch (SqlException e) {
                Assert.assertEquals((long)17L, (long)e.getPosition());
                TestUtils.assertContains(e.getFlyweightMessage(), "table name expected");
            }
            finally {
                engine.releaseAllReaders();
                engine.releaseAllWriters();
            }
        });
    }

    @Test
    public void testHappyPath() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try {
                this.createX();
                this.assertQuery("count\n10\n", "select count() from x", null, true);
                Assert.assertNull((Object)compiler.compile((CharSequence)"truncate table x", bindVariableService));
                this.assertQuery("count\n", "select count() from x", null, true);
                Assert.assertEquals((long)0L, (long)engine.getBusyWriterCount());
                Assert.assertEquals((long)0L, (long)engine.getBusyReaderCount());
            }
            finally {
                engine.releaseAllReaders();
                engine.releaseAllWriters();
            }
        });
    }

    @Test
    public void testTableBusy() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            this.createX();
            this.createY();
            this.assertQuery("count\n10\n", "select count() from x", null, true);
            this.assertQuery("count\n20\n", "select count() from y", null, true);
            CyclicBarrier useBarrier = new CyclicBarrier(2);
            CyclicBarrier releaseBarrier = new CyclicBarrier(2);
            CountDownLatch haltLatch = new CountDownLatch(1);
            new Thread(() -> {
                try (TableWriter ignore = engine.getWriter((CharSequence)"y");){
                    useBarrier.await();
                    releaseBarrier.await();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                haltLatch.countDown();
            }).start();
            useBarrier.await();
            try {
                Assert.assertNull((Object)compiler.compile((CharSequence)"truncate table x,y", bindVariableService));
                Assert.fail();
            }
            catch (SqlException e) {
                Assert.assertEquals((long)17L, (long)e.getPosition());
                TestUtils.assertContains(e.getFlyweightMessage(), "table 'y' is busy");
            }
            releaseBarrier.await();
            this.assertQuery("count\n10\n", "select count() from x", null, true);
            this.assertQuery("count\n20\n", "select count() from y", null, true);
            haltLatch.await(1L, TimeUnit.SECONDS);
            engine.releaseAllWriters();
            engine.releaseAllReaders();
        });
    }

    @Test
    public void testTableDoesNotExist() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            this.createX();
            this.createY();
            this.assertQuery("count\n10\n", "select count() from x", null, true);
            this.assertQuery("count\n20\n", "select count() from y", null, true);
            try {
                Assert.assertNull((Object)compiler.compile((CharSequence)"truncate table x, y,z", bindVariableService));
                Assert.fail();
            }
            catch (SqlException e) {
                Assert.assertEquals((long)20L, (long)e.getPosition());
                TestUtils.assertContains(e.getFlyweightMessage(), "table 'z' does not");
            }
            this.assertQuery("count\n10\n", "select count() from x", null, true);
            this.assertQuery("count\n20\n", "select count() from y", null, true);
            engine.releaseAllWriters();
            engine.releaseAllReaders();
        });
    }

    @Test
    public void testTwoTables() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            this.createX();
            this.createY();
            this.assertQuery("count\n10\n", "select count() from x", null, true);
            this.assertQuery("count\n20\n", "select count() from y", null, true);
            Assert.assertNull((Object)compiler.compile((CharSequence)"truncate table x, y", bindVariableService));
            this.assertQuery("count\n", "select count() from x", null, true);
            this.assertQuery("count\n", "select count() from y", null, true);
            engine.releaseAllWriters();
            engine.releaseAllReaders();
        });
    }

    private void createX() throws SqlException {
        compiler.compile((CharSequence)"create table x as (select to_int(x) i, rnd_symbol('msft','ibm', 'googl') sym, round(rnd_double(0)*100, 3) amt, to_timestamp('2018-01', 'yyyy-MM') + x * 720000000 timestamp, rnd_boolean() b, rnd_str('ABC', 'CDE', null, 'XYZ') c, rnd_double(2) d, rnd_float(2) e, rnd_short(10,1024) f, rnd_date(to_date('2015', 'yyyy'), to_date('2016', 'yyyy'), 2) g, rnd_symbol(4,4,4,2) ik, rnd_long() j, timestamp_sequence(to_timestamp(0), 1000000000) k, rnd_byte(2,50) l, rnd_bin(10, 20, 2) m, rnd_str(5,16,2) n from long_sequence(10)) timestamp (timestamp)", bindVariableService);
    }

    private void createY() throws SqlException {
        compiler.compile((CharSequence)"create table y as (select to_int(x) i, rnd_symbol('msft','ibm', 'googl') sym, round(rnd_double(0)*100, 3) amt, to_timestamp('2018-01', 'yyyy-MM') + x * 720000000 timestamp, rnd_boolean() b, rnd_str('ABC', 'CDE', null, 'XYZ') c, rnd_double(2) d, rnd_float(2) e, rnd_short(10,1024) f, rnd_date(to_date('2015', 'yyyy'), to_date('2016', 'yyyy'), 2) g, rnd_symbol(4,4,4,2) ik, rnd_long() j, timestamp_sequence(to_timestamp(0), 1000000000) k, rnd_byte(2,50) l, rnd_bin(10, 20, 2) m, rnd_str(5,16,2) n from long_sequence(20)) timestamp (timestamp)", bindVariableService);
    }
}

